import { jsxs, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { useTheme2 } from '@grafana/ui';

const DataSourceDescription = ({ dataSourceName, docsLink, hasRequiredFields = true, className }) => {
  const theme = useTheme2();
  const styles = {
    container: css({
      p: {
        margin: 0
      },
      "p + p": {
        marginTop: theme.spacing(2)
      }
    }),
    text: css({
      ...theme.typography.body,
      color: theme.colors.text.secondary,
      a: css({
        color: theme.colors.text.link,
        textDecoration: "underline",
        "&:hover": {
          textDecoration: "none"
        }
      })
    })
  };
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.container, className), children: [
    /* @__PURE__ */ jsxs("p", { className: styles.text, children: [
      "Before you can use the ",
      dataSourceName,
      " data source, you must configure it below or in the config file. For detailed instructions,",
      " ",
      /* @__PURE__ */ jsx("a", { href: docsLink, target: "_blank", rel: "noreferrer", children: "view the documentation" }),
      "."
    ] }),
    hasRequiredFields && /* @__PURE__ */ jsx("p", { className: styles.text, children: /* @__PURE__ */ jsx("i", { children: "Fields marked with * are required" }) })
  ] });
};

export { DataSourceDescription };
//# sourceMappingURL=DataSourceDescription.js.map
