import { jsx } from 'react/jsx-runtime';
import { useAsync } from 'react-use';
import { toOption } from '@grafana/data';
import { Select } from '@grafana/ui';
import './types.js';
import 'lodash';

const TableSelector = ({
  db,
  dataset,
  catalog,
  value,
  className,
  onChange,
  inputId,
  enableCatalogs
}) => {
  const state = useAsync(async () => {
    if (!dataset && !catalog) {
      return [];
    }
    if (enableCatalogs && (!catalog || !dataset)) {
      return [];
    }
    const tables = await db.tables(dataset, catalog);
    return tables.map(toOption);
  }, [dataset, catalog, enableCatalogs]);
  return /* @__PURE__ */ jsx(
    Select,
    {
      inputId,
      className,
      "aria-label": "Table selector",
      value,
      options: state.value,
      onChange,
      isLoading: state.loading,
      menuShouldPortal: true,
      placeholder: state.loading ? "Loading tables" : "Select table"
    }
  );
};

export { TableSelector };
//# sourceMappingURL=TableSelector.js.map
