import { jsx } from 'react/jsx-runtime';
import { useAsync } from 'react-use';
import { toOption } from '@grafana/data';
import { SelectRow } from './SelectRow.js';
import '../types.js';
import 'lodash';
import { useSqlChange } from '../utils/useSqlChange.js';

function SQLSelectRow({ fields, query, onQueryChange, db }) {
  const { onSqlChange } = useSqlChange({ query, onQueryChange, db });
  const state = useAsync(async () => {
    const functions = await db.functions();
    return functions.map((f) => toOption(f.name));
  }, [db]);
  return /* @__PURE__ */ jsx(SelectRow, { columns: fields, sql: query.sql, functions: state.value, onSqlChange });
}

export { SQLSelectRow };
//# sourceMappingURL=SQLSelectRow.js.map
