import { __exports as DOMCollection } from '../../../../../../../_virtual/DOMCollection.js';
import { __require as requireCollections } from '../collections.js';

var hasRequiredDOMCollection;

function requireDOMCollection () {
	if (hasRequiredDOMCollection) return DOMCollection;
	hasRequiredDOMCollection = 1;

	Object.defineProperty(DOMCollection, '__esModule', {
	  value: true
	});
	DOMCollection.test = DOMCollection.serialize = DOMCollection.default = undefined;

	var _collections = requireCollections();

	/**
	 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */

	/* eslint-disable local/ban-types-eventually */
	const SPACE = ' ';
	const OBJECT_NAMES = ['DOMStringMap', 'NamedNodeMap'];
	const ARRAY_REGEXP = /^(HTML\w*Collection|NodeList)$/;

	const testName = name =>
	  OBJECT_NAMES.indexOf(name) !== -1 || ARRAY_REGEXP.test(name);

	const test = val =>
	  val &&
	  val.constructor &&
	  !!val.constructor.name &&
	  testName(val.constructor.name);

	DOMCollection.test = test;

	const isNamedNodeMap = collection =>
	  collection.constructor.name === 'NamedNodeMap';

	const serialize = (collection, config, indentation, depth, refs, printer) => {
	  const name = collection.constructor.name;

	  if (++depth > config.maxDepth) {
	    return '[' + name + ']';
	  }

	  return (
	    (config.min ? '' : name + SPACE) +
	    (OBJECT_NAMES.indexOf(name) !== -1
	      ? '{' +
	        (0, _collections.printObjectProperties)(
	          isNamedNodeMap(collection)
	            ? Array.from(collection).reduce((props, attribute) => {
	                props[attribute.name] = attribute.value;
	                return props;
	              }, {})
	            : {...collection},
	          config,
	          indentation,
	          depth,
	          refs,
	          printer
	        ) +
	        '}'
	      : '[' +
	        (0, _collections.printListItems)(
	          Array.from(collection),
	          config,
	          indentation,
	          depth,
	          refs,
	          printer
	        ) +
	        ']')
	  );
	};

	DOMCollection.serialize = serialize;
	const plugin = {
	  serialize,
	  test
	};
	var _default = plugin;
	DOMCollection.default = _default;
	return DOMCollection;
}

export { requireDOMCollection as __require };
//# sourceMappingURL=DOMCollection.js.map
