import { DataTopic, LoadingState, dateTime } from '@grafana/data';
import { c as chanceExports } from '../../_virtual/chance.js';

const mockQueryEditorProps = () => ({
  datasource: {},
  query: {
    refId: chanceExports.Chance().word(),
    hide: false,
    key: chanceExports.Chance().word(),
    queryType: chanceExports.Chance().word(),
    dataTopic: DataTopic.Annotations,
    datasource: chanceExports.Chance().pickone([chanceExports.Chance().word(), null])
  },
  onRunQuery: jest.fn(),
  onChange: jest.fn(),
  onBlur: jest.fn(),
  data: {
    state: mockLoadingState(),
    series: [],
    annotations: [],
    timeRange: mockTimeRange()
  },
  range: mockTimeRange(),
  history: []
});
const mockLoadingState = () => chanceExports.Chance().pickone([
  LoadingState.NotStarted,
  LoadingState.Loading,
  LoadingState.Streaming,
  LoadingState.Done,
  LoadingState.Error
]);
const mockTimeRange = () => ({
  from: dateTime(),
  to: dateTime(),
  raw: {
    from: dateTime(),
    to: dateTime()
  }
});

export { mockLoadingState, mockQueryEditorProps, mockTimeRange };
//# sourceMappingURL=QueryEditorProps.js.map
