/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.comments;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.comments.EndOfLineCommentPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public final class ChangeToCStyleCommentIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new EndOfLineCommentPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        PsiElement prevComment;
        PsiComment selectedComment;
        if (element == null) {
            ChangeToCStyleCommentIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ChangeToCStyleCommentIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ChangeToCStyleCommentIntention.$$$reportNull$$$0(2);
        }
        PsiComment firstComment = selectedComment = (PsiComment)element;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment(prevComment = ChangeToCStyleCommentIntention.getPrevNonWhiteSpace((PsiElement)firstComment))) {
            firstComment = (PsiComment)prevComment;
        }
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)selectedComment.getProject());
        PsiElementFactory factory = manager.getElementFactory();
        Object text = ChangeToCStyleCommentIntention.getCommentContents(firstComment);
        ArrayList<PsiComment> commentsToDelete = new ArrayList<PsiComment>();
        PsiComment nextComment = firstComment;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment((PsiElement)(nextComment = ChangeToCStyleCommentIntention.getNextNonWhiteSpace((PsiElement)nextComment)))) {
            text = (String)text + nextComment.getPrevSibling().getText() + "  " + ChangeToCStyleCommentIntention.getCommentContents(nextComment);
            commentsToDelete.add(nextComment);
        }
        PsiComment newComment = factory.createCommentFromText("/*" + (String)text + " */", selectedComment.getParent());
        firstComment.replace((PsiElement)newComment);
        for (PsiElement psiElement : commentsToDelete) {
            psiElement.delete();
        }
    }

    @Nullable
    private static PsiElement getNextNonWhiteSpace(PsiElement nextComment) {
        PsiElement sibling;
        PsiElement elementToCheck = nextComment;
        while (true) {
            if ((sibling = elementToCheck.getNextSibling()) == null) {
                return null;
            }
            if (!sibling.getText().trim().replace("\n", "").isEmpty()) break;
            elementToCheck = sibling;
        }
        return sibling;
    }

    @Nullable
    private static PsiElement getPrevNonWhiteSpace(PsiElement nextComment) {
        PsiElement sibling;
        PsiElement elementToCheck = nextComment;
        while (true) {
            if ((sibling = elementToCheck.getPrevSibling()) == null) {
                return null;
            }
            if (!sibling.getText().trim().replace("\n", "").isEmpty()) break;
            elementToCheck = sibling;
        }
        return sibling;
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return GroovyTokenTypes.mSL_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(PsiComment comment) {
        String text = comment.getText();
        return text.substring(2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/comments/ChangeToCStyleCommentIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

