/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.find.impl.TextSearchContributor;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywherePopupInstance;
import com.intellij.ide.actions.searcheverywhere.SplitSearchAdapter;
import com.intellij.ide.actions.searcheverywhere.SplitSearchListener;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchFieldStatisticsCollector;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SearchEverywhereCommand
extends AbstractCommand {
    public static final String PREFIX = "%searchEverywhere";
    private static final Logger LOG = Logger.getInstance(SearchEverywhereCommand.class);
    private final Options myOptions;

    public SearchEverywhereCommand(@NotNull String text, int line) {
        if (text == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myOptions = new Options();
        this.getArgs();
    }

    private Boolean isWarmupMode() {
        return this.extractCommandArgument("%").contains("WARMUP");
    }

    private Boolean isStartThoughAction() {
        return this.extractCommandArgument("%").contains("START_THROUGH_ACTION");
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        String insertText;
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(1);
        }
        String[] args = this.getArgs();
        String tab = this.myOptions.tab;
        String string = insertText = args.length > 1 ? args[1] : "";
        if (this.isStartThoughAction().booleanValue()) {
            return this.executeStartingThroughAction(context, insertText);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        boolean warmup = this.isWarmupMode();
        Ref<String> tabId = SearchEverywhereCommand.computeTabId(tab);
        int numberOfPermits = this.getNumberOfPermits(insertText);
        SearchEverywhereManager manager = SearchEverywhereManager.getInstance((Project)project);
        boolean isNewSe = !(manager instanceof SearchEverywhereManagerImpl);
        Semaphore typingSemaphore = new Semaphore(numberOfPermits);
        TraceKt.use((SpanBuilder)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere"), globalSpan -> {
            if (isNewSe) {
                this.showPopupInEdtWaitForPopupAndTypeText(manager, project, context, tabId, insertText, typingSemaphore, warmup);
            } else {
                this.showPopupAndTypeTextAllInEDT(manager, project, context, tabId, insertText, typingSemaphore, warmup);
            }
            try {
                typingSemaphore.acquire();
                SearchEverywherePopupInstance popupInstance = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownPopupInstance();
                assert (popupInstance != null);
                if (this.myOptions.close.booleanValue()) {
                    ApplicationManager.getApplication().invokeAndWait(() -> popupInstance.closePopup());
                }
                if (this.myOptions.selectFirst.booleanValue()) {
                    WriteAction.runAndWait(() -> ApplicationManager.getApplication().invokeAndWait(() -> popupInstance.selectFirstItem()));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            finally {
                actionCallback.setDone();
            }
            return null;
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private void showPopupAndTypeTextAllInEDT(SearchEverywhereManager manager, Project project, @NotNull PlaybackContext context, Ref<String> tabId, String insertText, Semaphore typingSemaphore, boolean warmup) {
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
            try {
                DataContext wrappedDataContext = SearchEverywhereCommand.createDataContext(context, project);
                IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
                TraceKt.use((SpanBuilder)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_dialog_shown"), dialogSpan -> {
                    SearchEverywhereCommand.showPopup(manager, wrappedDataContext, tabId);
                    SearchEverywherePopupInstance popupInstance = manager.getCurrentlyShownPopupInstance();
                    assert (popupInstance != null);
                    this.attachSearchListeners(popupInstance);
                    return null;
                });
                this.typeOrInsertText(context, insertText, typingSemaphore, warmup);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }));
    }

    private void showPopupInEdtWaitForPopupAndTypeText(SearchEverywhereManager manager, Project project, @NotNull PlaybackContext context, Ref<String> tabId, String insertText, Semaphore typingSemaphore, boolean warmup) {
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
            try {
                DataContext wrappedDataContext = SearchEverywhereCommand.createDataContext(context, project);
                IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
                TraceKt.use((SpanBuilder)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_dialog_shown"), dialogSpan -> {
                    SearchEverywhereCommand.showPopup(manager, wrappedDataContext, tabId);
                    return null;
                });
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }));
        SearchEverywherePopupInstance popupInstance = manager.getCurrentlyShownPopupInstance();
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
            try {
                this.attachListenersToPopup(popupInstance);
                this.typeOrInsertText(context, insertText, typingSemaphore, warmup);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }));
    }

    private static DataContext createDataContext(@NotNull PlaybackContext context, @NotNull Project project) {
        Object component;
        TypingTarget target;
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(5);
        }
        if (project == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(6);
        }
        if (!((target = AlphaNumericTypeCommand.findTarget((PlaybackContext)context)) instanceof EditorComponentImpl)) {
            LOG.info("Editor is not opened, focus owner will be used.");
            component = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        } else {
            component = (EditorComponentImpl)target;
        }
        DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)DataManager.getInstance().getDataContext((Component)component), sink -> sink.set(CommonDataKeys.PROJECT, (Object)context.getProject()));
        return SearchFieldStatisticsCollector.wrapDataContextWithActionStartData((DataContext)dataContext);
    }

    private static void showPopup(SearchEverywhereManager manager, DataContext dataContext, Ref<String> tabId) {
        AnActionEvent event = AnActionEvent.createEvent((DataContext)dataContext, null, (String)"EditorPopup", (ActionUiKind)ActionUiKind.POPUP, null);
        manager.show((String)tabId.get(), "", event);
    }

    private void attachListenersToPopup(SearchEverywherePopupInstance popupInstance) {
        assert (popupInstance != null);
        this.attachSearchListeners(popupInstance);
    }

    @NotNull
    private static Ref<String> computeTabId(String tab) {
        Ref tabId = new Ref();
        switch (tab) {
            case "text": {
                tabId.set((Object)TextSearchContributor.class.getSimpleName());
                break;
            }
            case "file": {
                tabId.set((Object)FileSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "class": {
                tabId.set((Object)ClassSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "action": {
                tabId.set((Object)ActionSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "symbol": {
                tabId.set((Object)SymbolSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "all": {
                tabId.set((Object)"SearchEverywhereContributor.All");
                break;
            }
            default: {
                throw new RuntimeException("Tab is not set");
            }
        }
        LOG.info((String)tabId.get());
        Ref ref = tabId;
        if (ref == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(7);
        }
        return ref;
    }

    @NotNull
    private Promise<Object> executeStartingThroughAction(@NotNull PlaybackContext context, String insertText) {
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(8);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        boolean warmup = this.isWarmupMode();
        String actionId = this.computeActionId();
        ActionManager am = ActionManager.getInstance();
        AnAction targetAction = am.getAction(actionId);
        if (targetAction == null) {
            throw new RuntimeException("Unknown action: " + actionId);
        }
        InputEvent input = ActionCommand.getInputEvent((String)actionId);
        int numberOfPermits = this.getNumberOfPermits(insertText);
        Semaphore typingSemaphore = new Semaphore(numberOfPermits);
        TraceKt.use((SpanBuilder)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhereFromAction"), globalSpan -> {
            context.getRobot().delay(Registry.intValue((String)"actionSystem.playback.delay"));
            ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                try {
                    am.tryToExecute(targetAction, input, null, null, false).doWhenProcessed(() -> {
                        SearchEverywherePopupInstance popupInstance = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownPopupInstance();
                        assert (popupInstance != null);
                        this.attachSearchListeners(popupInstance);
                        ApplicationManager.getApplication().invokeAndWait(() -> this.typeOrInsertText(context, insertText, typingSemaphore, warmup));
                        ApplicationManager.getApplication().executeOnPooledThread(() -> this.closePopupOrSelectFirst(typingSemaphore, popupInstance, actionCallback));
                    });
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }));
            return null;
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(9);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePopupOrSelectFirst(Semaphore typingSemaphore, SearchEverywherePopupInstance popupInstance, ActionCallback actionCallback) {
        try {
            typingSemaphore.acquire();
            if (this.myOptions.close.booleanValue()) {
                ApplicationManager.getApplication().invokeAndWait(() -> popupInstance.closePopup());
            }
            if (this.myOptions.selectFirst.booleanValue()) {
                WriteAction.runAndWait(() -> ApplicationManager.getApplication().invokeAndWait(() -> popupInstance.selectFirstItem()));
            }
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        finally {
            actionCallback.setDone();
        }
    }

    private void typeOrInsertText(@NotNull PlaybackContext context, String insertText, Semaphore typingSemaphore, boolean warmup) {
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(10);
        }
        if (!insertText.isEmpty()) {
            this.insertText(context.getProject(), insertText, typingSemaphore, warmup);
        }
        if (!this.myOptions.typingText.isEmpty()) {
            this.typeText(context.getProject(), this.myOptions.typingText, typingSemaphore, warmup);
        }
    }

    @NotNull
    @Language(value="devkit-action-id")
    private String computeActionId() {
        String string = switch (this.myOptions.tab) {
            case "text" -> "TextSearchAction";
            case "file" -> "GotoFile";
            case "class" -> "GotoClass";
            case "action" -> "GotoAction";
            case "symbol" -> "GotoSymbol";
            case "all" -> "SearchEverywhere";
            default -> throw new RuntimeException("Tab is not set, can't run the action");
        };
        if (string == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(11);
        }
        return string;
    }

    private int getNumberOfPermits(String insertText) {
        int numberOfPermits = insertText.isEmpty() && this.myOptions.typingText.isEmpty() ? 1 : (!insertText.isEmpty() && !this.myOptions.typingText.isEmpty() ? -1 : 0);
        return numberOfPermits;
    }

    protected String @NotNull [] getArgs() {
        String[] stringArray = this.getArgs(PREFIX);
        if (stringArray == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    protected String @NotNull [] getArgs(String prefix) {
        String input = this.extractCommandArgument(prefix);
        String[] args = input.split("\\|");
        Args.parse((Object)this.myOptions, (String[])args[0].split(" "), (boolean)false);
        if (args == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(13);
        }
        return args;
    }

    private void insertText(Project project, String insertText, Semaphore typingSemaphore, boolean warmup) {
        SearchEverywherePopupInstance popupInstance = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownPopupInstance();
        assert (popupInstance != null);
        Span insertSpan = PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_items_loaded").startSpan();
        final Span firstBatchAddedSpan = PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_first_elements_added").startSpan();
        popupInstance.addSplitSearchListener((SplitSearchListener)new SplitSearchAdapter(){

            public void elementsAdded(@NotNull @NotNull Map<@NotNull String, ?> uuidToElement) {
                if (uuidToElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.elementsAdded(uuidToElement);
                firstBatchAddedSpan.setAttribute("number", (long)uuidToElement.size());
                firstBatchAddedSpan.end();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uuidToElement", "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand$1", "elementsAdded"));
            }
        });
        Future elements = popupInstance.findElementsForPattern(insertText);
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> {
            insertSpan.setAttribute("text", insertText);
            List result = (List)elements.get();
            insertSpan.setAttribute("number", (long)result.size());
            insertSpan.end();
            typingSemaphore.release();
            return result;
        }));
    }

    private void typeText(Project project, String typingText, final Semaphore typingSemaphore, boolean warmup) {
        SearchEverywherePopupInstance popupInstance = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownPopupInstance();
        assert (popupInstance != null);
        Document document = popupInstance.getSearchFieldDocument();
        final Semaphore oneLetterLock = new Semaphore(1);
        final ThreadPoolExecutor typing = ConcurrencyUtil.newSingleThreadExecutor((String)"Performance plugin delayed type");
        final Ref isTypingFinished = new Ref((Object)false);
        final Ref oneLetterSpan = new Ref();
        final Ref firstBatchAddedSpan = new Ref();
        popupInstance.addSplitSearchListener((SplitSearchListener)new SplitSearchAdapter(){

            public void elementsAdded(@NotNull @NotNull Map<@NotNull String, ?> uuidToElement) {
                if (uuidToElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((Span)firstBatchAddedSpan.get()).setAttribute("number", (long)uuidToElement.size());
                ((Span)firstBatchAddedSpan.get()).end();
            }

            public void searchFinished(int count) {
                super.searchFinished(count);
                if (count < 0) {
                    return;
                }
                oneLetterLock.release();
                if (!oneLetterSpan.isNull()) {
                    ((Span)oneLetterSpan.get()).setAttribute("number", (long)count);
                    ((Span)oneLetterSpan.get()).end();
                }
                if (((Boolean)isTypingFinished.get()).booleanValue()) {
                    typingSemaphore.release();
                    typing.shutdown();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uuidToElement", "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand$2", "elementsAdded"));
            }
        });
        int i = 0;
        while (i < typingText.length()) {
            int index = i++;
            typing.execute(Context.current().wrap(() -> {
                try {
                    oneLetterLock.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                    try {
                        char currentChar = typingText.charAt(index);
                        oneLetterSpan.set((Object)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_items_loaded").startSpan().setAttribute("text", String.valueOf(currentChar)));
                        firstBatchAddedSpan.set((Object)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_first_elements_added").startSpan());
                        document.insertString(document.getLength(), String.valueOf(currentChar), null);
                        if (index == typingText.length() - 1) {
                            isTypingFinished.set((Object)true);
                        }
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }));
        }
    }

    protected void attachSearchListeners(@NotNull SearchEverywherePopupInstance popupInstance) {
        if (popupInstance == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(14);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTabId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executeStartingThroughAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeActionId";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showPopupAndTypeTextAllInEDT";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showPopupInEdtWaitForPopupAndTypeText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDataContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeStartingThroughAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "typeOrInsertText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attachSearchListeners";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    static class Options {
        @Argument
        String tab = "all";
        @Argument
        Boolean close = false;
        @Argument
        Boolean selectFirst = false;
        @Argument(alias="type")
        String typingText = "";

        Options() {
        }
    }
}

