/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.visitor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighting.visitor.KotlinDiagnosticHighlightVisitor;
import org.jetbrains.kotlin.idea.references.KDocReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/visitor/KotlinUnresolvedKDocHighlightVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "<init>", "()V", "_holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "holder", "getHolder", "()Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "suitableForFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "analyze", "updateWholeFile", "action", "Ljava/lang/Runnable;", "clone", "intellij.kotlin.highlighting"})
public final class KotlinUnresolvedKDocHighlightVisitor
implements HighlightVisitor {
    @Nullable
    private HighlightInfoHolder _holder;

    private final HighlightInfoHolder getHolder() {
        HighlightInfoHolder highlightInfoHolder = this._holder;
        Intrinsics.checkNotNull((Object)highlightInfoHolder);
        return highlightInfoHolder;
    }

    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return KotlinDiagnosticHighlightVisitor.Companion.shouldHighlightDiagnostics(psiFile);
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof KDocName)) {
            return;
        }
        KDocReference reference = ReferenceUtilsKt.getMainReference((KDocName)((KDocName)element));
        if (reference.resolve() != null) {
            return;
        }
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(reference.getAbsoluteRange()).descriptionAndTooltip(ProblemsHolder.unresolvedReferenceMessage((PsiReference)((PsiReference)reference)));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"descriptionAndTooltip(...)");
        HighlightInfo.Builder builder3 = builder2;
        UnresolvedReferenceQuickFixProvider.registerUnresolvedReferenceLazyQuickFixes((PsiReference)((PsiReference)reference), (HighlightInfo.Builder)builder3);
        this.getHolder().add(builder3.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder2, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this._holder = holder2;
        try {
            action2.run();
        }
        finally {
            this._holder = null;
        }
        return true;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new KotlinUnresolvedKDocHighlightVisitor();
    }
}

