/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.FailedToRunCaseException;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.RandomUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveKotlinDeclarationsHandlerActions;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinAwareMoveFilesOrDirectoriesModel;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinNestedClassesToUpperLevelModel;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsModel;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J2\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J4\u0010#\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\fH\u0016J8\u0010*\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveKotlinDeclarationsHandlerTestActions;", "Lorg/jetbrains/kotlin/idea/refactoring/move/MoveKotlinDeclarationsHandlerActions;", "<init>", "()V", "invokeMoveKotlinTopLevelDeclarationsRefactoring", "", "project", "Lcom/intellij/openapi/project/Project;", "elementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "targetPackageName", "", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "freezeTargets", "", "moveToPackage", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "getSourceFiles", "", "", "invokeKotlinSelectNestedClassChooser", "nestedClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "targetContainer", "Lcom/intellij/psi/PsiElement;", "doWithMoveKotlinNestedClassesToUpperLevelModel", "invokeKotlinAwareMoveFilesOrDirectoriesRefactoring", "initialDirectory", "elements", "Lcom/intellij/psi/PsiFileSystemItem;", "showErrorHint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "message", "title", "helpId", "invokeMoveKotlinNestedClassesRefactoring", "originalClass", "targetClass", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMoveToSealedMatchingPackageFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveToSealedMatchingPackageFix.kt\norg/jetbrains/kotlin/idea/quickfix/MoveKotlinDeclarationsHandlerTestActions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1563#2:215\n1634#2,3:216\n1#3:219\n*S KotlinDebug\n*F\n+ 1 MoveToSealedMatchingPackageFix.kt\norg/jetbrains/kotlin/idea/quickfix/MoveKotlinDeclarationsHandlerTestActions\n*L\n141#1:215\n141#1:216,3\n*E\n"})
final class MoveKotlinDeclarationsHandlerTestActions
implements MoveKotlinDeclarationsHandlerActions {
    @Override
    public void invokeMoveKotlinTopLevelDeclarationsRefactoring(@NotNull Project project, @NotNull Set<? extends KtNamedDeclaration> elementsToMove, @NotNull String targetPackageName, @Nullable PsiDirectory targetDirectory, @Nullable KtFile targetFile, boolean freezeTargets, boolean moveToPackage, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        List<KtFile> sourceFiles = this.getSourceFiles((Collection<? extends KtNamedDeclaration>)elementsToMove);
        Object object = targetFile;
        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
            object = sourceFiles.get(0).getVirtualFile().getParent().getPath() + "/" + MoveUtilKt.guessNewFileName((Collection<? extends KtNamedDeclaration>)elementsToMove);
        }
        Object targetFilePath = object;
        MoveKotlinTopLevelDeclarationsModel model2 = new MoveKotlinTopLevelDeclarationsModel(project, CollectionsKt.toList((Iterable)elementsToMove), targetPackageName, targetDirectory, "Derived.kt", (String)targetFilePath, true, false, false, false, false, false, null);
        model2.computeModelResult(true).getProcessor().run();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> getSourceFiles(Collection<? extends KtNamedDeclaration> elementsToMove) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = elementsToMove;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            KtPureElement ktPureElement = (KtPureElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getContainingKtFile());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void invokeKotlinSelectNestedClassChooser(@NotNull KtClassOrObject nestedClass, @Nullable PsiElement targetContainer) {
        Intrinsics.checkNotNullParameter((Object)nestedClass, (String)"nestedClass");
        this.doWithMoveKotlinNestedClassesToUpperLevelModel(nestedClass, targetContainer);
    }

    private final void doWithMoveKotlinNestedClassesToUpperLevelModel(KtClassOrObject nestedClass, PsiElement targetContainer) {
        PsiElement newTarget;
        Object object;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)nestedClass));
        if (ktClassOrObject == null) {
            throw new FailedToRunCaseException();
        }
        KtClassOrObject outerClass = ktClassOrObject;
        PsiElement psiElement = targetContainer;
        if (psiElement == null) {
            KtClassOrObject ktClassOrObject2 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)outerClass));
            if (ktClassOrObject2 != null) {
                psiElement = (PsiElement)ktClassOrObject2;
            } else {
                PsiFileSystemItem psiFileSystemItem;
                PsiFile it = outerClass.getContainingFile();
                boolean bl = false;
                PsiDirectory psiDirectory = it.getContainingDirectory();
                if (psiDirectory != null) {
                    psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
                } else {
                    Intrinsics.checkNotNull((Object)it);
                    psiFileSystemItem = (PsiFileSystemItem)it;
                }
                psiElement = (PsiElement)psiFileSystemItem;
            }
        }
        if ((object = MoveUtilKt.getTargetPackageFqName(newTarget = psiElement)) == null || (object = object.asString()) == null) {
            object = "";
        }
        Object packageName = object;
        Project project = nestedClass.getProject();
        String string = nestedClass.getName();
        if (string == null) {
            string = "";
        }
        String string2 = string;
        MoveKotlinNestedClassesToUpperLevelModel model2 = new MoveKotlinNestedClassesToUpperLevelModel(nestedClass, newTarget, (String)packageName, project, string2){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $nestedClass, $newTarget, "", $super_call_param$2, false, false, false, $packageName, false);
            }

            protected VirtualFile chooseSourceRoot(PackageWrapper newPackage, List<? extends VirtualFile> contentSourceRoots, PsiDirectory initialDir) {
                Intrinsics.checkNotNullParameter((Object)newPackage, (String)"newPackage");
                Intrinsics.checkNotNullParameter(contentSourceRoots, (String)"contentSourceRoots");
                return (VirtualFile)CollectionsKt.firstOrNull(contentSourceRoots);
            }
        };
        model2.computeModelResult(true).getProcessor().run();
    }

    @Override
    public void invokeKotlinAwareMoveFilesOrDirectoriesRefactoring(@NotNull Project project, @Nullable PsiDirectory initialDirectory, @NotNull List<? extends PsiFileSystemItem> elements, @Nullable MoveCallback moveCallback) {
        PsiFileSystemItem psiFileSystemItem;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Object object = initialDirectory;
        if ((object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) && ((psiFileSystemItem = (PsiFileSystemItem)CollectionsKt.firstOrNull(elements)) != null && (psiFileSystemItem = psiFileSystemItem.getContainingFile()) != null && (psiFileSystemItem = psiFileSystemItem.getVirtualFile()) != null ? psiFileSystemItem.getPath() : (object = null)) == null) {
            throw new NotImplementedError(null, 1, null);
        }
        Object targetPath = object;
        KotlinAwareMoveFilesOrDirectoriesModel model2 = new KotlinAwareMoveFilesOrDirectoriesModel(project, elements, RandomUtilsKt.randomDirectoryPathMutator((String)targetPath), RandomUtilsKt.randomBoolean(), RandomUtilsKt.randomBoolean(), null);
        String string = MoveHandler.getRefactoringName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRefactoringName(...)");
        ApplicationUtilsKt.executeCommand$default(project, string, null, () -> MoveKotlinDeclarationsHandlerTestActions.invokeKotlinAwareMoveFilesOrDirectoriesRefactoring$lambda$0(model2), 2, null);
    }

    @NotNull
    public Void showErrorHint(@NotNull Project project, @Nullable Editor editor, @NotNull String message2, @NotNull String title, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public Void invokeMoveKotlinNestedClassesRefactoring(@NotNull Project project, @NotNull List<? extends KtClassOrObject> elementsToMove, @NotNull KtClassOrObject originalClass, @NotNull KtClassOrObject targetClass, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        throw new NotImplementedError(null, 1, null);
    }

    private static final Unit invokeKotlinAwareMoveFilesOrDirectoriesRefactoring$lambda$0(KotlinAwareMoveFilesOrDirectoriesModel $model) {
        $model.computeModelResult().getProcessor().run();
        return Unit.INSTANCE;
    }
}

