/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @Nullable
    public static CompilerMessageSourceLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        return MessageUtil.psiFileToMessageLocation(file, "<no path>", DiagnosticUtils.getLineAndColumnRangeInPsiFile(file, element.getTextRange()));
    }

    @Nullable
    public static CompilerMessageSourceLocation psiFileToMessageLocation(@NotNull PsiFile file, @Nullable String defaultValue, @NotNull PsiDiagnosticUtils.LineAndColumnRange range) {
        VirtualFile virtualFile;
        if (file == null) {
            MessageUtil.$$$reportNull$$$0(0);
        }
        if (range == null) {
            MessageUtil.$$$reportNull$$$0(1);
        }
        String path = (virtualFile = file.getVirtualFile()) != null ? MessageUtil.virtualFileToPath(virtualFile) : defaultValue;
        PsiDiagnosticUtils.LineAndColumn start = range.getStart();
        PsiDiagnosticUtils.LineAndColumn end = range.getEnd();
        return MessageUtil.createMessageLocation(path, start.getLineContent(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
    }

    @Nullable
    public static CompilerMessageLocationWithRange createMessageLocation(@Nullable String path, @Nullable String lineContent, int line, int column, int endLine, int endColumn) {
        return CompilerMessageLocationWithRange.create((String)path, (int)line, (int)column, (Integer)endLine, (Integer)endColumn, (String)lineContent);
    }

    @NotNull
    public static String virtualFileToPath(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            MessageUtil.$$$reportNull$$$0(2);
        }
        String string = FileUtil.toSystemDependentName((String)virtualFile.getPath());
        if (string == null) {
            MessageUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "virtualFileToPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToMessageLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToPath";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

