/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.actions.DescriptorBasedAutoImportVariant;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionInfo;
import org.jetbrains.kotlin.idea.actions.VariantWithPriority;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.completion.KotlinStatisticsInfo;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "variants", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/actions/VariantWithPriority;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/sequences/Sequence;)V", "singleImportVariant", "Lorg/jetbrains/kotlin/idea/actions/DescriptorBasedAutoImportVariant;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "variantsList", "", "showHint", "", "getKind", "", "Lcom/intellij/psi/PsiElement;", "execute", "addImport", "", "variant", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinAddImportAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAddImportAction.kt\norg/jetbrains/kotlin/idea/actions/KotlinAddImportAction\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n73#2:353\n73#2:354\n73#2:355\n608#3:356\n1869#4:357\n1870#4:359\n1#5:358\n*S KotlinDebug\n*F\n+ 1 KotlinAddImportAction.kt\norg/jetbrains/kotlin/idea/actions/KotlinAddImportAction\n*L\n147#1:353\n154#1:354\n207#1:355\n151#1:356\n231#1:357\n231#1:359\n*E\n"})
public final class KotlinAddImportAction
implements QuestionAction {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Sequence<VariantWithPriority> variants;
    @Nullable
    private DescriptorBasedAutoImportVariant singleImportVariant;
    @NotNull
    private final SmartPsiElementPointer<KtElement> elementPointer;

    public KotlinAddImportAction(@NotNull Project project, @NotNull Editor editor, @NotNull KtElement element, @NotNull Sequence<VariantWithPriority> variants) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        this.project = project;
        this.editor = editor;
        this.variants = variants;
        this.elementPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element));
    }

    private final List<DescriptorBasedAutoImportVariant> variantsList() {
        List list2;
        if (this.singleImportVariant != null) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                DescriptorBasedAutoImportVariant descriptorBasedAutoImportVariant = this.singleImportVariant;
                Intrinsics.checkNotNull((Object)descriptorBasedAutoImportVariant);
                return CollectionsKt.listOf((Object)descriptorBasedAutoImportVariant);
            }
        }
        Function0 variantsList = () -> KotlinAddImportAction.variantsList$lambda$0(this);
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            list2 = (List)variantsList.invoke();
        } else {
            list2 = (List)ProgressUtilsKt.runSynchronouslyWithProgress(this.project, KotlinBundle.message((String)"import.progress.text.resolve.imports", (Object[])new Object[0]), true, () -> KotlinAddImportAction.variantsList$lambda$1(variantsList));
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        }
        return list2;
    }

    public final boolean showHint() {
        boolean bl;
        KtElement ktElement = (KtElement)this.elementPointer.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element = ktElement;
        Iterator iterator2 = this.variants.iterator();
        if (!iterator2.hasNext()) {
            return false;
        }
        DescriptorBasedAutoImportVariant first2 = ((VariantWithPriority)iterator2.next()).getVariant();
        if (iterator2.hasNext()) {
            bl = true;
        } else {
            this.singleImportVariant = first2;
            bl = false;
        }
        boolean multiple = bl;
        String string = ShowAutoImportPass.getMessage((boolean)multiple, (String)this.getKind(first2.getDeclarationToImport()), (String)first2.getHint());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String hintText = string;
        HintManager.getInstance().showQuestionHint(this.editor, hintText, PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element)), (QuestionAction)this);
        return true;
    }

    private final String getKind(PsiElement element) {
        if (element instanceof PsiClass) {
            return KotlinBundle.message((String)"text.class", (Object[])new Object[0]);
        }
        if (element instanceof PsiField) {
            return KotlinBundle.message((String)"text.property", (Object[])new Object[0]);
        }
        if (element instanceof PsiMethod) {
            return KotlinBundle.message((String)"text.function", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean execute() {
        List<DescriptorBasedAutoImportVariant> variantsList;
        block8: {
            block7: {
                KtElement ktElement = (KtElement)this.elementPointer.getElement();
                if (ktElement == null) {
                    return false;
                }
                KtElement element = ktElement;
                PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
                if (!element.isValid()) {
                    return false;
                }
                variantsList = this.variantsList();
                KtFile ktFile2 = element.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                KotlinAddImportActionInfo.ExecuteListener executeListener = KotlinAddImportActionInfo.INSTANCE.getExecuteListener((PsiFile)ktFile2);
                if (executeListener != null) {
                    executeListener.onExecute(variantsList);
                }
                if (variantsList.isEmpty()) {
                    return false;
                }
                if (variantsList.size() == 1) break block7;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block8;
            }
            this.addImport((AutoImportVariant)CollectionsKt.first(variantsList));
            return true;
        }
        ImportFixHelper.INSTANCE.createListPopupWithImportVariants(this.project, variantsList, (Function1<? super AutoImportVariant, Unit>)((Function1)new Function1<AutoImportVariant, Unit>((Object)this){

            public final void invoke(AutoImportVariant p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                KotlinAddImportAction.access$addImport((KotlinAddImportAction)this.receiver, p0);
            }
        })).showInBestPositionFor(this.editor);
        return true;
    }

    private final void addImport(AutoImportVariant variant) {
        if (!(variant instanceof DescriptorBasedAutoImportVariant)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KtElement ktElement = (KtElement)this.elementPointer.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element = ktElement;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        psiDocumentManager.commitAllDocuments();
        String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ApplicationUtilsKt.executeWriteCommand(this.project, string, (Function0<Unit>)((Function0)() -> KotlinAddImportAction.addImport$lambda$0(element, variant, this)));
    }

    private static final List variantsList$lambda$0(KotlinAddImportAction this$0) {
        return (List)ActionsKt.runReadAction(() -> KotlinAddImportAction.variantsList$lambda$0$0(this$0));
    }

    private static final List variantsList$lambda$0$0(KotlinAddImportAction this$0) {
        Sequence<VariantWithPriority> $this$sortedBy$iv = this$0.variants;
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VariantWithPriority it = (VariantWithPriority)a;
                boolean bl = false;
                Comparable comparable = it.getPriority();
                it = (VariantWithPriority)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getPriority());
            }
        }), KotlinAddImportAction::variantsList$lambda$0$0$1));
    }

    private static final DescriptorBasedAutoImportVariant variantsList$lambda$0$0$1(VariantWithPriority it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVariant();
    }

    private static final List variantsList$lambda$1(Function0 $variantsList) {
        return (List)ActionsKt.runReadAction(() -> KotlinAddImportAction.variantsList$lambda$1$0($variantsList));
    }

    private static final List variantsList$lambda$1$0(Function0 $variantsList) {
        return (List)$variantsList.invoke();
    }

    private static final Unit addImport$lambda$0(KtElement $element, AutoImportVariant $variant, KotlinAddImportAction this$0) {
        if (!$element.isValid()) {
            return Unit.INSTANCE;
        }
        KtFile ktFile2 = $element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        StatisticsManager statisticsManager = StatisticsManager.getInstance();
        Iterable $this$forEach$iv = ((DescriptorBasedAutoImportVariant)$variant).getDescriptorsToImport();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtImportAlias ktImportAlias;
            DeclarationDescriptor descriptor2 = (DeclarationDescriptor)element$iv;
            boolean bl = false;
            StatisticsInfo statisticsInfo = KotlinStatisticsInfo.forDescriptor$default(KotlinStatisticsInfo.INSTANCE, descriptor2, null, 2, null);
            statisticsManager.incUseCount(statisticsInfo);
            FqName importableFqName = ImportsUtils.getImportableFqName(descriptor2);
            if (importableFqName != null) {
                FqName it;
                boolean bl2 = false;
                ktImportAlias = file.findAliasByFqName(it);
            } else {
                ktImportAlias = null;
            }
            KtImportAlias importAlias = ktImportAlias;
            FqName fqName2 = importableFqName;
            if (!(fqName2 != null ? FqNamesUtilKt.isOneSegmentFQN((FqName)fqName2) : false) && (importAlias != null || descriptor2 instanceof ClassDescriptor || descriptor2 instanceof PackageViewDescriptor)) {
                if (!($element instanceof KtSimpleNameExpression)) continue;
                if (importAlias != null) {
                    DeclarationDescriptor resultDescriptor;
                    PsiElement psiElement = importAlias.getNameIdentifier();
                    if (psiElement != null && (psiElement = psiElement.copy()) != null) {
                        PsiElement it = psiElement;
                        boolean bl3 = false;
                        PsiElement psiElement2 = ((KtSimpleNameExpression)$element).getIdentifier();
                        if (psiElement2 != null) {
                            psiElement2.replace(it);
                        }
                    }
                    DeclarationDescriptor declarationDescriptor = resultDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors($element));
                    if (Intrinsics.areEqual((Object)importableFqName, (Object)(declarationDescriptor != null ? ImportsUtils.getImportableFqName(declarationDescriptor) : null))) continue;
                }
                if (importableFqName == null) continue;
                Object[] objectArray = new Object[]{importableFqName.asString()};
                ApplicationUtilsKt.underModalProgressOrUnderWriteActionWithNonCancellableProgressInDispatchThread(this$0.project, KotlinBundle.message((String)"add.import.for.0", (Object[])objectArray), () -> KotlinAddImportAction.addImport$lambda$0$0$2($element, importableFqName));
                continue;
            }
            ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(this$0.project), file, descriptor2, false, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addImport$lambda$0$0$2(KtElement $element, FqName $importableFqName) {
        KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)$element)), (FqName)$importableFqName, (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING, null, (int)4, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addImport(KotlinAddImportAction $this, AutoImportVariant variant) {
        $this.addImport(variant);
    }
}

