/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.openapi.util.TextRange;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\u00020\u0011*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u0006*\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/VariablesCollector;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "myLineRange", "Lcom/intellij/openapi/util/TextRange;", "myExpressions", "", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "<init>", "(Lcom/intellij/openapi/util/TextRange;Ljava/util/Set;)V", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitQualifiedExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "isRefToProperty", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitReferenceExpression", "isInRange", "createText", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlin.jvm-debugger.core-fe10"})
final class VariablesCollector
extends KtTreeVisitorVoid {
    @NotNull
    private final TextRange myLineRange;
    @NotNull
    private final Set<TextWithImports> myExpressions;

    public VariablesCollector(@NotNull TextRange myLineRange, @NotNull Set<TextWithImports> myExpressions) {
        Intrinsics.checkNotNullParameter((Object)myLineRange, (String)"myLineRange");
        Intrinsics.checkNotNullParameter(myExpressions, (String)"myExpressions");
        this.myLineRange = myLineRange;
        this.myExpressions = myExpressions;
    }

    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isInRange(element)) {
            super.visitKtElement(element);
        }
    }

    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
        KtExpression selector2;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isInRange((KtElement)expression) && (selector2 = expression.getSelectorExpression()) instanceof KtReferenceExpression && this.isRefToProperty((KtReferenceExpression)selector2)) {
            this.myExpressions.add(this.createText((KtElement)expression));
            return;
        }
        super.visitQualifiedExpression(expression);
    }

    private final boolean isRefToProperty(KtReferenceExpression expression) {
        BindingContext context2 = ResolutionUtils.analyzeWithAllCompilerChecks((KtElement)expression).getBindingContext();
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)context2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression);
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyGetterDescriptor getter = ((PropertyDescriptor)descriptor2).getGetter();
            return (getter == null || context2.get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)getter) == null) && ((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null;
        }
        return false;
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isInRange((KtElement)expression) && this.isRefToProperty(expression)) {
            this.myExpressions.add(this.createText((KtElement)expression));
        }
        super.visitReferenceExpression(expression);
    }

    private final boolean isInRange(KtElement $this$isInRange) {
        return this.myLineRange.intersects($this$isInRange.getTextRange());
    }

    private final TextWithImports createText(KtElement $this$createText) {
        return (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, $this$createText.getText());
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
    }
}

