/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameDispatcherHandler;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0005H\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinMemberInplaceRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler;", "<init>", "()V", "substitute", "Lcom/intellij/psi/PsiElement;", "doRename", "Lcom/intellij/refactoring/rename/inplace/InplaceRefactoring;", "elementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createMemberRenamer", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "RenamerImpl", "kotlin.refactorings.common"})
public final class KotlinMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    private final PsiElement substitute(PsiElement $this$substitute) {
        if ($this$substitute instanceof KtPrimaryConstructor) {
            return (PsiElement)((KtPrimaryConstructor)$this$substitute).getContainingClassOrObject();
        }
        if ($this$substitute instanceof KtNameReferenceExpression) {
            PsiElement psiElement = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)$this$substitute)).resolve();
            if (psiElement == null) {
                psiElement = $this$substitute;
            }
            return psiElement;
        }
        return $this$substitute;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, @NotNull Editor editor, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (elementToRename instanceof KtNameReferenceExpression) {
            PsiElement psiElement = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)elementToRename)).resolve();
            if (psiElement == null) {
                psiElement = elementToRename;
            }
            return super.doRename(psiElement, editor, dataContext);
        }
        return super.doRename(elementToRename, editor, dataContext);
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiElement psiElement = this.substitute((PsiElement)elementToRename);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
        PsiNameIdentifierOwner currentElementToRename = (PsiNameIdentifierOwner)psiElement;
        PsiElement nameIdentifier = currentElementToRename.getNameIdentifier();
        int offset = editor.getCaretModel().getOffset();
        PsiFile editorPsiFile = PsiDocumentManager.getInstance((Project)element.getProject()).getPsiFile(editor.getDocument());
        if (nameIdentifier != null && Intrinsics.areEqual((Object)editorPsiFile, (Object)elementToRename.getContainingFile()) && elementToRename instanceof KtPrimaryConstructor && !nameIdentifier.getTextRange().contains(offset) && ((KtPrimaryConstructor)elementToRename).getTextRange().contains(offset)) {
            editor.getCaretModel().moveToOffset(nameIdentifier.getTextOffset());
        }
        if ((object = nameIdentifier) == null || (object = object.getText()) == null) {
            object = "";
        }
        Object currentName = object;
        return new RenamerImpl((PsiNamedElement)currentElementToRename, element, editor, (String)currentName, (String)currentName);
    }

    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        PsiElement psiElement = element;
        PsiElement psiElement2 = psiElement != null ? this.substitute(psiElement) : null;
        KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration currentElement = ktNamedDeclaration;
        PsiElement elementAtCaret = file.findElementAt(editor.getCaretModel().getOffset());
        KtThisExpression thisExpression = (KtThisExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, KtThisExpression.class);
        if (thisExpression != null) {
            PsiElement psiElement3 = (PsiElement)thisExpression.getInstanceReference();
            PsiElement psiElement4 = elementAtCaret;
            Intrinsics.checkNotNull((Object)psiElement4);
            if (PsiTreeUtil.isAncestor((PsiElement)psiElement3, (PsiElement)psiElement4, (boolean)false)) {
                return false;
            }
        }
        return currentElement.getNameIdentifier() != null && !KotlinVariableInplaceRenameHandler.Companion.isInplaceRenameAvailable((PsiElement)currentElement);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0014J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\tH\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinMemberInplaceRenameHandler$RenamerImpl;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiNamedElement;", "substitutedElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "currentName", "", "oldName", "<init>", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;)V", "isIdentifier", "", "newName", "language", "Lcom/intellij/lang/Language;", "acceptReference", "reference", "Lcom/intellij/psi/PsiReference;", "startsOnTheSameElement", "handler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "element", "createInplaceRenamerToRestart", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "variable", "initialName", "kotlin.refactorings.common"})
    private static final class RenamerImpl
    extends MemberInplaceRenamer {
        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @Nullable PsiElement substitutedElement, @NotNull Editor editor, @NotNull String currentName, @NotNull String oldName) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)currentName, (String)"currentName");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            super(elementToRename, substitutedElement, editor, currentName, oldName);
        }

        protected boolean isIdentifier(@Nullable String newName, @Nullable Language language) {
            if (Intrinsics.areEqual((Object)newName, (Object)"")) {
                PsiNamedElement psiNamedElement = this.getVariable();
                KtObjectDeclaration ktObjectDeclaration = psiNamedElement instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiNamedElement : null;
                boolean bl = ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
                if (bl) {
                    return true;
                }
            }
            return super.isIdentifier(newName, language);
        }

        protected boolean acceptReference(@NotNull PsiReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PsiElement psiElement = reference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            PsiElement refElement = psiElement;
            TextRange textRange = reference.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
            TextRange textRange2 = textRange;
            String string = refElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = textRange2.getStartOffset();
            int n2 = textRange2.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String referenceText = string3;
            if (reference instanceof KtReferenceExpression && Intrinsics.areEqual((Object)KotlinPsiModificationUtils.unquoteKotlinIdentifier(referenceText), (Object)this.myElementToRename.getName())) {
                return true;
            }
            PsiNamedElement psiNamedElement = this.myElementToRename;
            Object object = psiNamedElement instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiNamedElement : null;
            if (object == null || (object = object.getNameIdentifier()) == null || (object = object.getText()) == null) {
                object = this.myElementToRename.getName();
            }
            return Intrinsics.areEqual((Object)referenceText, (Object)object);
        }

        protected boolean startsOnTheSameElement(@Nullable RefactoringActionHandler handler2, @Nullable PsiElement element) {
            return Intrinsics.areEqual((Object)this.getVariable(), (Object)element) && (handler2 instanceof MemberInplaceRenameHandler || handler2 instanceof KotlinRenameDispatcherHandler);
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(@NotNull PsiNamedElement variable, @NotNull Editor editor, @NotNull String initialName2) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)initialName2, (String)"initialName");
            PsiElement psiElement = this.getSubstituted();
            String string = this.myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myOldName");
            return (VariableInplaceRenamer)new RenamerImpl(variable, psiElement, editor, initialName2, string);
        }
    }
}

