/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.ConfigurableStore;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.internals.SessionStoreBuilder;
import org.apache.kafka.streams.state.internals.TimestampedWindowStoreBuilder;
import org.apache.kafka.streams.state.internals.VersionedKeyValueStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowStoreBuilder;

public class StoreBuilderWrapper
implements StoreFactory {
    private final StoreBuilder<?> builder;
    private final Set<String> connectedProcessorNames = new HashSet<String>();

    public static StoreFactory wrapStoreBuilder(StoreBuilder<?> builder) {
        if (builder instanceof StoreFactory.FactoryWrappingStoreBuilder) {
            return ((StoreFactory.FactoryWrappingStoreBuilder)builder).storeFactory();
        }
        return new StoreBuilderWrapper(builder);
    }

    private StoreBuilderWrapper(StoreBuilder<?> builder) {
        this.builder = builder;
    }

    @Override
    public void configure(StreamsConfig config) {
        if (this.builder instanceof ConfigurableStore) {
            ((ConfigurableStore)((Object)this.builder)).configure(config);
        }
    }

    @Override
    public StoreBuilder<?> builder() {
        return this.builder;
    }

    @Override
    public long retentionPeriod() {
        if (this.builder instanceof WindowStoreBuilder) {
            return ((WindowStoreBuilder)this.builder).retentionPeriod();
        }
        if (this.builder instanceof TimestampedWindowStoreBuilder) {
            return ((TimestampedWindowStoreBuilder)this.builder).retentionPeriod();
        }
        if (this.builder instanceof SessionStoreBuilder) {
            return ((SessionStoreBuilder)this.builder).retentionPeriod();
        }
        throw new IllegalStateException("retentionPeriod is not supported when not a window store");
    }

    @Override
    public long historyRetention() {
        if (this.builder instanceof VersionedKeyValueStoreBuilder) {
            return ((VersionedKeyValueStoreBuilder)this.builder).historyRetention();
        }
        throw new IllegalStateException("historyRetention is not supported when not a versioned store");
    }

    @Override
    public Set<String> connectedProcessorNames() {
        return this.connectedProcessorNames;
    }

    @Override
    public boolean loggingEnabled() {
        return this.builder.loggingEnabled();
    }

    @Override
    public String storeName() {
        return this.builder.name();
    }

    @Override
    public boolean isWindowStore() {
        return this.builder instanceof WindowStoreBuilder || this.builder instanceof TimestampedWindowStoreBuilder || this.builder instanceof SessionStoreBuilder;
    }

    @Override
    public boolean isVersionedStore() {
        return this.builder instanceof VersionedKeyValueStoreBuilder;
    }

    @Override
    public Map<String, String> logConfig() {
        return this.builder.logConfig();
    }

    @Override
    public StoreFactory withCachingDisabled() {
        this.builder.withCachingDisabled();
        return this;
    }

    @Override
    public StoreFactory withLoggingDisabled() {
        this.builder.withLoggingDisabled();
        return this;
    }

    @Override
    public boolean isCompatibleWith(StoreFactory storeFactory) {
        return storeFactory instanceof StoreBuilderWrapper && this.builder.equals(((StoreBuilderWrapper)storeFactory).builder);
    }
}

