/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;

public class RefreshEvent
extends AbstractEvent {
    private final Object object;
    private String entityName;
    private LockOptions lockOptions = new LockOptions(LockMode.READ, -1, Locking.Scope.ROOT_ONLY, Locking.FollowOn.ALLOW);

    public RefreshEvent(Object object, EventSource source) {
        super(source);
        if (object == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        this.object = object;
    }

    public RefreshEvent(String entityName, Object object, EventSource source) {
        this(object, source);
        this.entityName = entityName;
    }

    public RefreshEvent(Object object, LockMode lockMode, EventSource source) {
        this(object, source);
        if (lockMode == null) {
            throw new IllegalArgumentException("LockMode may not be null");
        }
        this.lockOptions.setLockMode(lockMode);
    }

    public RefreshEvent(Object object, LockOptions lockOptions, EventSource source) {
        this(object, source);
        if (lockOptions == null) {
            throw new IllegalArgumentException("LockMode may not be null");
        }
        this.lockOptions = lockOptions;
    }

    @Deprecated(since="7.0")
    public RefreshEvent(String entityName, Object object, LockOptions lockOptions, EventSource source) {
        this(object, lockOptions, source);
        this.entityName = entityName;
    }

    public Object getObject() {
        return this.object;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Deprecated(since="7.1")
    public LockMode getLockMode() {
        return this.lockOptions.getLockMode();
    }

    @Deprecated(since="7.1")
    public int getLockTimeout() {
        return this.lockOptions.getTimeOut();
    }

    @Deprecated(since="7.1")
    public boolean getLockScope() {
        return this.lockOptions.getScope() != Locking.Scope.ROOT_ONLY;
    }
}

