/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.Filter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyEval
extends AbstractEval {
    private static final boolean DEBUG = false;
    Filter<String> punctFilter;

    public DependencyEval(String str, boolean runningAverages, Filter<String> punctFilter) {
        super(str, runningAverages);
        this.punctFilter = punctFilter;
    }

    @Override
    protected Set<?> makeObjects(Tree tree) {
        HashSet<UnnamedDependency> deps = new HashSet<UnnamedDependency>();
        for (Tree node : tree.subTreeList()) {
            if (node.isLeaf() || node.children().length < 2) continue;
            String head = ((HasWord)((Object)node.label())).word();
            boolean seenHead = false;
            for (int cNum = 0; cNum < node.children().length; ++cNum) {
                Tree child = node.children()[cNum];
                String arg = ((HasWord)((Object)child.label())).word();
                if (head.equals(arg) && !seenHead) {
                    seenHead = true;
                    continue;
                }
                if (this.punctFilter.accept(arg)) continue;
                deps.add(new UnnamedDependency(head, arg));
            }
        }
        return deps;
    }
}

