/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.node;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.painless.Location;
import org.opensearch.painless.node.ANode;
import org.opensearch.painless.node.SBlock;
import org.opensearch.painless.phase.UserTreeVisitor;

public class SFunction
extends ANode {
    private final String returnCanonicalTypeName;
    private final String functionName;
    private final List<String> canonicalTypeNameParameters;
    private final List<String> parameterNames;
    private final SBlock blockNode;
    private final boolean isInternal;
    private final boolean isStatic;
    private final boolean isSynthetic;
    private final boolean isAutoReturnEnabled;

    public SFunction(int identifier, Location location, String returnCanonicalTypeName, String name, List<String> canonicalTypeNameParameters, List<String> parameterNames, SBlock blockNode, boolean isInternal, boolean isStatic, boolean isSynthetic, boolean isAutoReturnEnabled) {
        super(identifier, location);
        this.returnCanonicalTypeName = Objects.requireNonNull(returnCanonicalTypeName);
        this.functionName = Objects.requireNonNull(name);
        this.canonicalTypeNameParameters = Collections.unmodifiableList(Objects.requireNonNull(canonicalTypeNameParameters));
        this.parameterNames = Collections.unmodifiableList(Objects.requireNonNull(parameterNames));
        this.blockNode = Objects.requireNonNull(blockNode);
        this.isInternal = isInternal;
        this.isSynthetic = isSynthetic;
        this.isStatic = isStatic;
        this.isAutoReturnEnabled = isAutoReturnEnabled;
    }

    public String getReturnCanonicalTypeName() {
        return this.returnCanonicalTypeName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<String> getCanonicalTypeNameParameters() {
        return this.canonicalTypeNameParameters;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public SBlock getBlockNode() {
        return this.blockNode;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isAutoReturnEnabled() {
        return this.isAutoReturnEnabled;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitFunction(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        this.blockNode.visit(userTreeVisitor, scope);
    }
}

