/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.apache.lucene.search.uhighlight.CharArrayMatcher;
import org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.util.BytesRef;

public class MemoryIndexOffsetStrategy
extends AnalysisOffsetStrategy {
    private final MemoryIndex memoryIndex;
    private final LeafReader memIndexLeafReader;
    private final CharArrayMatcher preMemIndexFilterAutomaton;

    public MemoryIndexOffsetStrategy(UHComponents components, Analyzer analyzer) {
        super(components, analyzer);
        boolean storePayloads = components.phraseHelper().hasPositionSensitivity();
        this.memoryIndex = new MemoryIndex(true, storePayloads);
        this.memIndexLeafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
        this.preMemIndexFilterAutomaton = MemoryIndexOffsetStrategy.buildCombinedAutomaton(components);
    }

    private static CharArrayMatcher buildCombinedAutomaton(UHComponents components) {
        if (components.terms() == null || components.automata() == null) {
            return null;
        }
        ArrayList<CharArrayMatcher> allAutomata = new ArrayList<CharArrayMatcher>();
        if (components.terms().length > 0) {
            List<BytesRef> filteredTerms = Arrays.stream(components.terms()).filter(b -> b.length < 1000).toList();
            allAutomata.add(CharArrayMatcher.fromTerms(filteredTerms));
        }
        Collections.addAll(allAutomata, components.automata());
        for (SpanQuery spanQuery : components.phraseHelper().getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata((Query)spanQuery, components.fieldMatcher(), true));
        }
        if (allAutomata.size() == 1) {
            return (CharArrayMatcher)allAutomata.get(0);
        }
        return (chars, offset, length) -> {
            for (int i = 0; i < allAutomata.size(); ++i) {
                if (!((CharArrayMatcher)allAutomata.get(i)).match(chars, offset, length)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        if (this.preMemIndexFilterAutomaton != null) {
            tokenStream = MemoryIndexOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
        }
        this.memoryIndex.reset();
        this.memoryIndex.addField(this.getField(), tokenStream);
        if (reader == null) {
            return this.createOffsetsEnumFromReader(this.memIndexLeafReader, 0);
        }
        return this.createOffsetsEnumFromReader((LeafReader)new OverlaySingleDocTermsLeafReader(reader, this.memIndexLeafReader, this.getField(), docId), docId);
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharArrayMatcher matcher) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(arg0);
                this.charAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            }

            protected boolean accept() throws IOException {
                return matcher.match(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }
}

