/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.IsoFields;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import shaded.com.google.common.collect.ImmutableMap;

public class StrftimeFormatterUtil {
    private static final String PERCENT_PLACEHOLDER = "\u0001PERCENT\u0001";
    private static final String PERCENT_LITERAL = "%%";
    private static final int DEFAULT_NANOSECOND_PRECISION = 9;
    private static final int DEFAULT_MILLISECOND_PRECISION = 3;
    private static final int MICROSECOND_PRECISION = 6;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MAX_UNIX_TIMESTAMP = 32536771199L;
    private static final int UNIX_TIMESTAMP_DIGITS = 10;
    private static final Pattern SUBSECOND_PATTERN = Pattern.compile("%(\\d)?([NQ])");
    private static final Map<String, StrftimeFormatHandler> STRFTIME_HANDLERS = StrftimeFormatterUtil.buildHandlers();

    private static Map<String, StrftimeFormatHandler> buildHandlers() {
        return ImmutableMap.builder().put((Object)"%c", dt -> dt.format(DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy", Locale.ROOT))).put((Object)"%+", dt -> dt.format(DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ROOT))).put((Object)"%Ez", StrftimeFormatterUtil::formatTimezoneOffsetMinutes).put((Object)"%f", dt -> String.format("%06d", dt.getNano() / 1000)).put((Object)"%H", dt -> dt.format(DateTimeFormatter.ofPattern("HH", Locale.ROOT))).put((Object)"%I", dt -> dt.format(DateTimeFormatter.ofPattern("hh", Locale.ROOT))).put((Object)"%k", dt -> String.format("%2d", dt.getHour())).put((Object)"%M", dt -> dt.format(DateTimeFormatter.ofPattern("mm", Locale.ROOT))).put((Object)"%p", dt -> dt.format(DateTimeFormatter.ofPattern("a", Locale.ROOT))).put((Object)"%S", dt -> dt.format(DateTimeFormatter.ofPattern("ss", Locale.ROOT))).put((Object)"%s", dt -> String.valueOf(dt.toEpochSecond())).put((Object)"%T", dt -> dt.format(DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT))).put((Object)"%X", dt -> dt.format(DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT))).put((Object)"%Z", dt -> dt.getZone().getDisplayName(TextStyle.SHORT, Locale.ROOT)).put((Object)"%z", dt -> dt.format(DateTimeFormatter.ofPattern("xx", Locale.ROOT))).put((Object)"%:z", dt -> dt.format(DateTimeFormatter.ofPattern("xxx", Locale.ROOT))).put((Object)"%::z", dt -> dt.format(DateTimeFormatter.ofPattern("xxx:ss", Locale.ROOT))).put((Object)"%:::z", dt -> dt.format(DateTimeFormatter.ofPattern("x", Locale.ROOT))).put((Object)"%F", dt -> dt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ROOT))).put((Object)"%x", dt -> dt.format(DateTimeFormatter.ofPattern("MM/dd/yyyy", Locale.ROOT))).put((Object)"%A", dt -> dt.format(DateTimeFormatter.ofPattern("EEEE", Locale.ROOT))).put((Object)"%a", dt -> dt.format(DateTimeFormatter.ofPattern("EEE", Locale.ROOT))).put((Object)"%w", dt -> String.valueOf(dt.getDayOfWeek().getValue() % 7)).put((Object)"%d", dt -> dt.format(DateTimeFormatter.ofPattern("dd", Locale.ROOT))).put((Object)"%e", dt -> String.format("%2d", dt.getDayOfMonth())).put((Object)"%j", dt -> dt.format(DateTimeFormatter.ofPattern("DDD", Locale.ROOT))).put((Object)"%V", dt -> String.format("%02d", dt.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR))).put((Object)"%U", dt -> String.format("%02d", dt.get(WeekFields.SUNDAY_START.weekOfYear()) - 1)).put((Object)"%b", dt -> dt.format(DateTimeFormatter.ofPattern("MMM", Locale.ROOT))).put((Object)"%B", dt -> dt.format(DateTimeFormatter.ofPattern("MMMM", Locale.ROOT))).put((Object)"%m", dt -> dt.format(DateTimeFormatter.ofPattern("MM", Locale.ROOT))).put((Object)"%C", dt -> String.format("%02d", dt.getYear() / 100)).put((Object)"%g", dt -> String.format("%02d", dt.get(IsoFields.WEEK_BASED_YEAR) % 100)).put((Object)"%G", dt -> String.format("%04d", dt.get(IsoFields.WEEK_BASED_YEAR))).put((Object)"%y", dt -> dt.format(DateTimeFormatter.ofPattern("yy", Locale.ROOT))).put((Object)"%Y", dt -> dt.format(DateTimeFormatter.ofPattern("yyyy", Locale.ROOT))).put((Object)PERCENT_LITERAL, dt -> "%").build();
    }

    private StrftimeFormatterUtil() {
    }

    public static ExprValue formatZonedDateTime(ZonedDateTime dateTime, String formatString) {
        String result = StrftimeFormatterUtil.processFormatString(formatString, dateTime);
        return new ExprStringValue(result);
    }

    private static String processFormatString(String formatString, ZonedDateTime dateTime) {
        String result = StrftimeFormatterUtil.handleSubSecondFormats(formatString, dateTime);
        result = result.replace(PERCENT_LITERAL, PERCENT_PLACEHOLDER);
        result = StrftimeFormatterUtil.replaceFormatSpecifiers(result, dateTime);
        return result.replace(PERCENT_PLACEHOLDER, "%");
    }

    private static String replaceFormatSpecifiers(String input, ZonedDateTime dateTime) {
        String result = input;
        for (Map.Entry<String, StrftimeFormatHandler> entry : STRFTIME_HANDLERS.entrySet()) {
            String specifier = entry.getKey();
            if (!result.contains(specifier)) continue;
            String replacement = entry.getValue().format(dateTime);
            result = result.replace(specifier, replacement);
        }
        return result;
    }

    private static String handleSubSecondFormats(String format, ZonedDateTime dateTime) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = SUBSECOND_PATTERN.matcher(format);
        while (matcher.find()) {
            String precisionStr = matcher.group(1);
            String type = matcher.group(2);
            int precision = StrftimeFormatterUtil.parsePrecision(precisionStr, type);
            String replacement = StrftimeFormatterUtil.formatSubseconds(dateTime, type, precision);
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static int parsePrecision(String precisionStr, String type) {
        if (precisionStr != null) {
            return Integer.parseInt(precisionStr);
        }
        return "N".equals(type) ? 9 : 3;
    }

    private static String formatSubseconds(ZonedDateTime dateTime, String type, int precision) {
        if ("N".equals(type)) {
            return StrftimeFormatterUtil.formatNanoseconds(dateTime.getNano(), precision);
        }
        return StrftimeFormatterUtil.formatQSubseconds(dateTime, precision);
    }

    private static String formatNanoseconds(long nanos, int precision) {
        double scaled = (double)nanos / 1.0E9;
        long truncated = (long)(scaled * Math.pow(10.0, precision));
        return String.format("%0" + precision + "d", truncated);
    }

    private static String formatQSubseconds(ZonedDateTime dateTime, int precision) {
        switch (precision) {
            case 6: {
                long micros = dateTime.getNano() / 1000;
                return String.format("%06d", micros);
            }
            case 9: {
                return String.format("%09d", dateTime.getNano());
            }
        }
        long millis = dateTime.toInstant().toEpochMilli() % 1000L;
        return String.format("%03d", millis);
    }

    private static String formatTimezoneOffsetMinutes(ZonedDateTime dt) {
        int offsetMinutes = dt.getOffset().getTotalSeconds() / 60;
        return String.format("%+d", offsetMinutes);
    }

    public static long extractUnixSeconds(double timestamp) {
        if (timestamp >= -3.2536771199E10 && timestamp <= 3.2536771199E10) {
            return (long)timestamp;
        }
        return StrftimeFormatterUtil.extractFirstNDigits(timestamp, 10);
    }

    private static long extractFirstNDigits(double value, int digits) {
        boolean isNegative = value < 0.0;
        long absValue = Math.abs((long)value);
        String valueStr = String.valueOf(absValue);
        long result = valueStr.length() <= digits ? absValue : Long.parseLong(valueStr.substring(0, digits));
        return isNegative ? -result : result;
    }

    @FunctionalInterface
    private static interface StrftimeFormatHandler {
        public String format(ZonedDateTime var1);
    }
}

