"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

// eslint-disable-next-line import/no-default-export
function _default(Client, config, components) {
  const ca = components.clientAction.factory;
  if (!Client.prototype.opensearch_security) {
    Client.prototype.opensearch_security = components.clientAction.namespaceFactory();
  }

  /**
   * Gets auth info.
   */
  Client.prototype.opensearch_security.prototype.authinfo = ca({
    url: {
      fmt: '/_plugins/_security/authinfo'
    }
  });
  Client.prototype.opensearch_security.prototype.dashboardsinfo = ca({
    url: {
      fmt: '/_plugins/_security/dashboardsinfo'
    }
  });

  /**
   * Gets tenant info and opensearch-dashboards server info.
   *
   * e.g.
   * {
   *   "user_name": "admin",
   *   "not_fail_on_forbidden_enabled": false,
   *   "opensearch_dashboards_mt_enabled": true,
   *   "opensearch_dashboards_index": ".opensearch_dashboards",
   *   "opensearch_dashboards_server_user": "kibanaserver"
   * }
   */
  Client.prototype.opensearch_security.prototype.multitenancyinfo = ca({
    url: {
      fmt: '/_plugins/_security/dashboardsinfo'
    }
  });

  /**
   * Gets tenant info. The output looks like:
   * {
   *   ".opensearch_dashboards_92668751_admin":"__private__"
   * }
   */
  Client.prototype.opensearch_security.prototype.tenantinfo = ca({
    url: {
      fmt: '/_plugins/_security/tenantinfo'
    }
  });

  /**
   * Gets SAML token.
   */
  Client.prototype.opensearch_security.prototype.authtoken = ca({
    method: 'POST',
    needBody: true,
    url: {
      fmt: '/_plugins/_security/api/authtoken'
    }
  });
  Client.prototype.opensearch_security.prototype.tenancy_configs = ca({
    method: 'PUT',
    needBody: true,
    url: {
      fmt: '/_plugins/_security/api/tenancy/config'
    }
  });

  /**
   * Gets registered resource types.
   */
  Client.prototype.opensearch_security.prototype.listResourceTypes = ca({
    url: {
      fmt: '/_plugins/_security/api/resource/types'
    }
  });

  /**
   * Gets accessible shared resources filtered by resourceType.
   */
  Client.prototype.opensearch_security.prototype.listResourceSharing = ca({
    url: {
      fmt: '/_plugins/_security/api/resource/list?resource_type=<%=resource_type%>',
      req: {
        resource_type: {
          type: 'string',
          required: true
        }
      }
    }
  });

  /**
   * Gets sharing info for a specific resource.
   */
  Client.prototype.opensearch_security.prototype.getResourceSharing = ca({
    url: {
      fmt: '/_plugins/_security/api/resource/share?resource_id=<%=resource_id%>&resource_type=<%=resource_type%>',
      req: {
        resource_id: {
          type: 'string',
          required: true
        },
        resource_type: {
          type: 'string',
          required: true
        }
      }
    }
  });

  /**
   * Shares a resource.
   */
  Client.prototype.opensearch_security.prototype.shareResource = ca({
    method: 'PUT',
    needBody: true,
    url: {
      fmt: '/_plugins/_security/api/resource/share'
    }
  });

  /**
   * Updates resource sharing.
   */
  Client.prototype.opensearch_security.prototype.updateResourceSharing = ca({
    method: 'POST',
    needBody: true,
    url: {
      fmt: '/_plugins/_security/api/resource/share'
    }
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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