/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class GetCacheEntryInput {
    private final ByteBuffer identifier;
    private final Long bytesUsed;

    protected GetCacheEntryInput(BuilderImpl builder) {
        this.identifier = builder.identifier();
        this.bytesUsed = builder.bytesUsed();
    }

    public ByteBuffer identifier() {
        return this.identifier;
    }

    public Long bytesUsed() {
        return this.bytesUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer identifier;
        protected Long bytesUsed;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetCacheEntryInput model) {
            this.identifier = model.identifier();
            this.bytesUsed = model.bytesUsed();
        }

        @Override
        public Builder identifier(ByteBuffer identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public ByteBuffer identifier() {
            return this.identifier;
        }

        @Override
        public Builder bytesUsed(Long bytesUsed) {
            this.bytesUsed = bytesUsed;
            return this;
        }

        @Override
        public Long bytesUsed() {
            return this.bytesUsed;
        }

        @Override
        public GetCacheEntryInput build() {
            if (Objects.isNull(this.identifier())) {
                throw new IllegalArgumentException("Missing value for required field `identifier`");
            }
            return new GetCacheEntryInput(this);
        }
    }

    public static interface Builder {
        public Builder identifier(ByteBuffer var1);

        public ByteBuffer identifier();

        public Builder bytesUsed(Long var1);

        public Long bytesUsed();

        public GetCacheEntryInput build();
    }
}

