/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.CategoryMask;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Transform;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SemanticSegmentationTranslator
extends BaseImageTranslator<CategoryMask> {
    private BaseImageTranslator.SynsetLoader synsetLoader;
    private final int shortEdge;
    private final int maxEdge;
    private List<String> classes;

    public SemanticSegmentationTranslator(Builder builder) {
        super(builder);
        this.synsetLoader = builder.synsetLoader;
        this.shortEdge = builder.shortEdge;
        this.maxEdge = builder.maxEdge;
        this.pipeline.insert(0, null, (Transform)new ResizeShort());
    }

    @Override
    public void prepare(TranslatorContext ctx) throws IOException {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(ctx.getModel());
        }
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Image image) {
        return super.processInput(ctx, image);
    }

    @Override
    public CategoryMask processOutput(TranslatorContext ctx, NDList list) {
        float[] scores = ((NDArray)list.get(1)).toFloatArray();
        Shape shape = ((NDArray)list.get(1)).getShape();
        int width = (int)shape.get(2);
        int height = (int)shape.get(1);
        int[][] mask = new int[height][width];
        int imageSize = width * height;
        int numOfClasses = this.classes.size();
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int index = h * width + w;
                int maxi = 0;
                double maxnum = -1.7976931348623157E308;
                for (int i = 0; i < numOfClasses; ++i) {
                    float score = scores[i * imageSize + index];
                    if (!((double)score > maxnum)) continue;
                    maxnum = score;
                    maxi = i;
                }
                mask[h][w] = maxi;
            }
        }
        return new CategoryMask(this.classes, mask);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    public static class Builder
    extends BaseImageTranslator.ClassificationBuilder<Builder> {
        int shortEdge = 600;
        int maxEdge = 1000;

        Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            super.configPostProcess(arguments);
            this.shortEdge = ArgumentsUtil.intValue(arguments, "shortEdge", 600);
            this.maxEdge = ArgumentsUtil.intValue(arguments, "maxEdge", 1000);
        }

        public SemanticSegmentationTranslator build() {
            this.validate();
            return new SemanticSegmentationTranslator(this);
        }
    }

    private class ResizeShort
    implements Transform {
        private ResizeShort() {
        }

        @Override
        public NDArray transform(NDArray array) {
            Shape shape = array.getShape();
            int width = (int)shape.get(1);
            int height = (int)shape.get(0);
            int min = Math.min(width, height);
            int max = Math.max(width, height);
            float scale = (float)SemanticSegmentationTranslator.this.shortEdge / (float)min;
            if (Math.round(scale * (float)max) > SemanticSegmentationTranslator.this.maxEdge) {
                scale = (float)SemanticSegmentationTranslator.this.maxEdge / (float)max;
            }
            int rescaledHeight = Math.round((float)height * scale);
            int rescaledWidth = Math.round((float)width * scale);
            return NDImageUtils.resize(array, rescaledWidth, rescaledHeight);
        }
    }
}

