/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.StringSupport;

public class Namespace {
    @Nullable
    private String namespaceURI;
    @Nullable
    private String namespacePrefix;
    @Nullable
    private String nsStr;

    public Namespace(@Nullable String uri, @Nullable String prefix) {
        this.namespaceURI = StringSupport.trimOrNull(uri);
        this.namespacePrefix = StringSupport.trimOrNull(prefix);
        this.nsStr = null;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Nullable
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Nonnull
    public String ensureNamespaceURI() {
        if (this.namespaceURI != null) {
            return this.namespaceURI;
        }
        throw new IllegalStateException("Namespace URI was not set");
    }

    public String toString() {
        if (this.nsStr == null) {
            this.constructStringRepresentation();
        }
        return this.nsStr;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.toString().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        Namespace otherNamespace;
        if (obj == this) {
            return true;
        }
        return obj instanceof Namespace && Objects.equals((otherNamespace = (Namespace)obj).getNamespaceURI(), this.getNamespaceURI()) && Objects.equals(otherNamespace.getNamespacePrefix(), this.getNamespacePrefix());
    }

    protected void constructStringRepresentation() {
        StringBuffer stringRep = new StringBuffer();
        stringRep.append("xmlns");
        if (this.namespacePrefix != null) {
            stringRep.append(":");
            stringRep.append(this.namespacePrefix);
        }
        stringRep.append("=\"");
        if (this.namespaceURI != null) {
            stringRep.append(this.namespaceURI);
        }
        stringRep.append("\"");
        this.nsStr = stringRep.toString();
    }
}

