/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.ast.statement.Query;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstBuilder;

public class AstStatementBuilder
extends OpenSearchPPLParserBaseVisitor<Statement> {
    private final AstBuilder astBuilder;
    private final StatementBuilderContext context;

    @Override
    public Statement visitPplStatement(OpenSearchPPLParser.PplStatementContext ctx) {
        Query query = new Query(this.addSelectAll((UnresolvedPlan)this.astBuilder.visit((ParseTree)ctx)), this.context.getFetchSize(), QueryType.PPL);
        if (ctx.explainStatement() != null) {
            if (ctx.explainStatement().explainMode() == null) {
                return new Explain((Statement)query, QueryType.PPL);
            }
            return new Explain((Statement)query, QueryType.PPL, ctx.explainStatement().explainMode().getText());
        }
        return this.context.isExplain ? new Explain((Statement)query, QueryType.PPL, this.context.explainMode) : query;
    }

    protected Statement aggregateResult(Statement aggregate, Statement nextResult) {
        return nextResult != null ? nextResult : aggregate;
    }

    private UnresolvedPlan addSelectAll(UnresolvedPlan plan) {
        if (plan instanceof Project && !((Project)plan).isExcluded()) {
            return plan;
        }
        return new Project((List)ImmutableList.of((Object)AllFields.of())).attach(plan);
    }

    @Generated
    public AstStatementBuilder(AstBuilder astBuilder, StatementBuilderContext context) {
        this.astBuilder = astBuilder;
        this.context = context;
    }

    public static class StatementBuilderContext {
        private final boolean isExplain;
        private final int fetchSize;
        private final String format;
        private final String explainMode;

        @Generated
        StatementBuilderContext(boolean isExplain, int fetchSize, String format, String explainMode) {
            this.isExplain = isExplain;
            this.fetchSize = fetchSize;
            this.format = format;
            this.explainMode = explainMode;
        }

        @Generated
        public static StatementBuilderContextBuilder builder() {
            return new StatementBuilderContextBuilder();
        }

        @Generated
        public boolean isExplain() {
            return this.isExplain;
        }

        @Generated
        public int getFetchSize() {
            return this.fetchSize;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public String getExplainMode() {
            return this.explainMode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementBuilderContext)) {
                return false;
            }
            StatementBuilderContext other = (StatementBuilderContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExplain() != other.isExplain()) {
                return false;
            }
            if (this.getFetchSize() != other.getFetchSize()) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            String this$explainMode = this.getExplainMode();
            String other$explainMode = other.getExplainMode();
            return !(this$explainMode == null ? other$explainMode != null : !this$explainMode.equals(other$explainMode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatementBuilderContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExplain() ? 79 : 97);
            result = result * 59 + this.getFetchSize();
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            String $explainMode = this.getExplainMode();
            result = result * 59 + ($explainMode == null ? 43 : $explainMode.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AstStatementBuilder.StatementBuilderContext(isExplain=" + this.isExplain() + ", fetchSize=" + this.getFetchSize() + ", format=" + this.getFormat() + ", explainMode=" + this.getExplainMode() + ")";
        }

        @Generated
        public static class StatementBuilderContextBuilder {
            @Generated
            private boolean isExplain;
            @Generated
            private int fetchSize;
            @Generated
            private String format;
            @Generated
            private String explainMode;

            @Generated
            StatementBuilderContextBuilder() {
            }

            @Generated
            public StatementBuilderContextBuilder isExplain(boolean isExplain) {
                this.isExplain = isExplain;
                return this;
            }

            @Generated
            public StatementBuilderContextBuilder fetchSize(int fetchSize) {
                this.fetchSize = fetchSize;
                return this;
            }

            @Generated
            public StatementBuilderContextBuilder format(String format) {
                this.format = format;
                return this;
            }

            @Generated
            public StatementBuilderContextBuilder explainMode(String explainMode) {
                this.explainMode = explainMode;
                return this;
            }

            @Generated
            public StatementBuilderContext build() {
                return new StatementBuilderContext(this.isExplain, this.fetchSize, this.format, this.explainMode);
            }

            @Generated
            public String toString() {
                return "AstStatementBuilder.StatementBuilderContext.StatementBuilderContextBuilder(isExplain=" + this.isExplain + ", fetchSize=" + this.fetchSize + ", format=" + this.format + ", explainMode=" + this.explainMode + ")";
            }
        }
    }
}

