/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryArrowAndCircle;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircle;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleConnect;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleCross;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleCrowfoot;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleLine;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCrowfoot;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryDiamond;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryDoubleLine;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtendsLike;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryHalfArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryLineCrowfoot;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryNotNavigable;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryParenthesis;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryPlus;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactorySquare;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryTriangle;

public enum LinkDecor {
    NONE(null, null, 2, false, 0.0),
    EXTENDS(LinkDecor.decors1("<|", "^"), LinkDecor.decors2("|>", "^"), 30, false, 2.0),
    COMPOSITION(LinkDecor.decors1("*"), LinkDecor.decors2("*"), 15, true, 1.3),
    AGREGATION(LinkDecor.decors1("o"), LinkDecor.decors2("o"), 15, false, 1.3),
    NOT_NAVIGABLE(LinkDecor.decors1("x"), LinkDecor.decors2("x"), 1, false, 0.5),
    REDEFINES(LinkDecor.decors1("<||"), LinkDecor.decors2("||>"), 30, false, 2.0),
    DEFINEDBY(LinkDecor.decors1("<|:"), LinkDecor.decors2(":|>"), 30, false, 2.0),
    CROWFOOT(LinkDecor.decors1("}"), LinkDecor.decors2("{"), 10, true, 0.8),
    CIRCLE_CROWFOOT(LinkDecor.decors1("}o"), LinkDecor.decors2("o{"), 14, false, 0.8),
    CIRCLE_LINE(LinkDecor.decors1("|o"), LinkDecor.decors2("o|"), 10, false, 0.8),
    DOUBLE_LINE(LinkDecor.decors1("||"), LinkDecor.decors2("||"), 7, false, 0.7),
    LINE_CROWFOOT(LinkDecor.decors1("}|"), LinkDecor.decors2("|{"), 10, false, 0.8),
    ARROW(LinkDecor.decors1("<", "<_"), LinkDecor.decors2(">", "_>"), 10, true, 0.5),
    ARROW_TRIANGLE(LinkDecor.decors1("<<"), LinkDecor.decors2(">>"), 10, true, 0.8),
    ARROW_AND_CIRCLE(null, null, 10, false, 0.5),
    CIRCLE(LinkDecor.decors1("0"), LinkDecor.decors2("0"), 0, false, 0.5),
    CIRCLE_FILL(LinkDecor.decors1("@"), LinkDecor.decors2("@"), 0, false, 0.5),
    CIRCLE_CONNECT(LinkDecor.decors1("0)"), LinkDecor.decors2("(0"), 0, false, 0.5),
    PARENTHESIS(LinkDecor.decors1(")"), LinkDecor.decors2("("), 0, false, 1.0),
    SQUARE(LinkDecor.decors1("#"), LinkDecor.decors2("#"), 0, false, 0.5),
    CIRCLE_CROSS(null, null, 0, false, 0.5),
    PLUS(LinkDecor.decors1("+"), LinkDecor.decors2("+"), 0, false, 1.5),
    HALF_ARROW_UP(null, LinkDecor.decors2("\\\\"), 0, false, 1.5),
    HALF_ARROW_DOWN(null, LinkDecor.decors2("//"), 0, false, 1.5),
    SQUARE_toberemoved(null, null, 30, false, 0.0);

    private final double arrowSize;
    private final int margin;
    private final boolean fill;
    private final String[] decors1;
    private final String[] decors2;
    private static final Map<String, LinkDecor> DECORS1;
    private static final Map<String, LinkDecor> DECORS2;

    private static String[] decors1(String ... tmp) {
        return tmp;
    }

    private static String[] decors2(String ... tmp) {
        return tmp;
    }

    private LinkDecor(String[] decors1, String[] decors2, int margin, boolean fill, double arrowSize) {
        this.margin = margin;
        this.fill = fill;
        this.arrowSize = arrowSize;
        this.decors1 = decors1;
        this.decors2 = decors2;
    }

    public int getMargin() {
        return this.margin;
    }

    public boolean isFill() {
        return this.fill;
    }

    public double getArrowSize() {
        return this.arrowSize;
    }

    public boolean isExtendsLike() {
        return this == EXTENDS || this == REDEFINES || this == DEFINEDBY;
    }

    public ExtremityFactory getExtremityFactoryComplete(HColor backgroundColor) {
        if (this == EXTENDS) {
            return new ExtremityFactoryTriangle(null, 18, 6, 18);
        }
        return this.getExtremityFactoryLegacy(backgroundColor);
    }

    public ExtremityFactory getExtremityFactoryLegacy(HColor backgroundColor) {
        switch (this.ordinal()) {
            case 21: {
                return new ExtremityFactoryPlus(backgroundColor);
            }
            case 5: {
                return new ExtremityFactoryExtendsLike(backgroundColor, false);
            }
            case 6: {
                return new ExtremityFactoryExtendsLike(backgroundColor, true);
            }
            case 22: {
                return new ExtremityFactoryHalfArrow(1);
            }
            case 23: {
                return new ExtremityFactoryHalfArrow(-1);
            }
            case 13: {
                return new ExtremityFactoryTriangle(null, 8, 3, 8);
            }
            case 7: {
                return new ExtremityFactoryCrowfoot();
            }
            case 8: {
                return new ExtremityFactoryCircleCrowfoot();
            }
            case 11: {
                return new ExtremityFactoryLineCrowfoot();
            }
            case 9: {
                return new ExtremityFactoryCircleLine();
            }
            case 10: {
                return new ExtremityFactoryDoubleLine();
            }
            case 20: {
                return new ExtremityFactoryCircleCross(backgroundColor);
            }
            case 12: {
                return new ExtremityFactoryArrow();
            }
            case 14: {
                return new ExtremityFactoryArrowAndCircle(backgroundColor);
            }
            case 4: {
                return new ExtremityFactoryNotNavigable();
            }
            case 3: {
                return new ExtremityFactoryDiamond(false);
            }
            case 2: {
                return new ExtremityFactoryDiamond(true);
            }
            case 15: {
                return new ExtremityFactoryCircle(false, backgroundColor);
            }
            case 16: {
                return new ExtremityFactoryCircle(true, backgroundColor);
            }
            case 19: {
                return new ExtremityFactorySquare(backgroundColor);
            }
            case 18: {
                return new ExtremityFactoryParenthesis();
            }
            case 17: {
                return new ExtremityFactoryCircleConnect(backgroundColor);
            }
        }
        return null;
    }

    public static LinkDecor lookupDecors1(String s) {
        if (s == null) {
            return NONE;
        }
        return DECORS1.getOrDefault(StringUtils.trin(s), NONE);
    }

    public static LinkDecor lookupDecors2(String s) {
        if (s == null) {
            return NONE;
        }
        return DECORS2.getOrDefault(StringUtils.trin(s), NONE);
    }

    public static String getRegexDecors1() {
        return LinkDecor.buildRegexFromDecorKeys(DECORS1.keySet());
    }

    public static String getRegexDecors2() {
        return LinkDecor.buildRegexFromDecorKeys(DECORS2.keySet());
    }

    private static String buildRegexFromDecorKeys(Set<String> keys) {
        return keys.stream().sorted(Comparator.comparingInt(String::length).reversed()).map(key -> {
            String quoted = Pattern.quote(key);
            boolean startsWithO = key.startsWith("o");
            boolean endsWithO = key.endsWith("o");
            if (startsWithO && endsWithO) {
                return "\\b" + quoted + "\\b";
            }
            if (startsWithO) {
                return "\\b" + quoted;
            }
            if (endsWithO) {
                return quoted + "\\b";
            }
            return quoted;
        }).collect(Collectors.joining("|", "(", ")?"));
    }

    static {
        DECORS1 = new HashMap<String, LinkDecor>();
        DECORS2 = new HashMap<String, LinkDecor>();
        for (LinkDecor decor : LinkDecor.values()) {
            if (decor.decors1 != null) {
                for (String s : decor.decors1) {
                    DECORS1.put(s, decor);
                }
            }
            if (decor.decors2 == null) continue;
            for (String s : decor.decors2) {
                DECORS2.put(s, decor);
            }
        }
    }
}

