/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.sql.SQLException;

public class RedshiftByteTypes {
    public static byte[] toBytes(byte[] s) throws SQLException {
        if (s == null) {
            return null;
        }
        return RedshiftByteTypes.toBytesFromHex(s);
    }

    public static String convertToString(byte[] data) {
        char[] hex = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            hexChars[i * 2] = hex[v >>> 4];
            hexChars[i * 2 + 1] = hex[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] toBytesFromHex(byte[] s) {
        byte[] output = new byte[s.length / 2];
        for (int i = 0; i < output.length; ++i) {
            byte b1 = RedshiftByteTypes.gethex(s[i * 2]);
            byte b2 = RedshiftByteTypes.gethex(s[i * 2 + 1]);
            output[i] = (byte)(b1 << 4 | b2 & 0xFF);
        }
        return output;
    }

    private static byte gethex(byte b) {
        if (b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97) {
            return (byte)(b - 97 + 10);
        }
        return (byte)(b - 65 + 10);
    }
}

