/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ordereddict;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictKeysBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictKeysBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDict;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDictIterator;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.POrderedDictKeys})
public class OrderedDictKeysBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = OrderedDictKeysBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return OrderedDictKeysBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        ReversedNode() {
        }

        @Specialization
        static Object iter(PDictView.PDictKeysView self, @Bind PythonLanguage language) {
            return PFactory.createOrderedDictIterator(language, (POrderedDict)self.getWrappedDict(), POrderedDictIterator.IteratorType.KEYS, true);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object iter(PDictView.PDictKeysView self, @Bind PythonLanguage language) {
            return PFactory.createOrderedDictIterator(language, (POrderedDict)self.getWrappedDict(), POrderedDictIterator.IteratorType.KEYS, false);
        }
    }
}

