/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.ssl.PMemoryBIO;
import com.oracle.graal.python.builtins.objects.ssl.PSSLContext;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public final class PSSLSocket
extends PythonBuiltinObject {
    private final PSSLContext context;
    private final PSocket socket;
    private final SSLEngine engine;
    private Object owner;
    private TruffleString serverHostname;
    private final PMemoryBIO networkInboundBIO;
    private final PMemoryBIO networkOutboundBIO;
    private final PMemoryBIO applicationInboundBIO;
    private SSLException exception;
    private boolean handshakeComplete = false;

    public PSSLSocket(Object cls, Shape instanceShape, PSSLContext context, SSLEngine engine, PSocket socket, PMemoryBIO networkInboundBIO, PMemoryBIO networkOutboundBIO, PMemoryBIO applicationInboundBIO) {
        super(cls, instanceShape);
        this.context = context;
        this.engine = engine;
        this.socket = socket;
        this.networkInboundBIO = networkInboundBIO;
        this.networkOutboundBIO = networkOutboundBIO;
        this.applicationInboundBIO = applicationInboundBIO;
    }

    public PSSLContext getContext() {
        return this.context;
    }

    public PSocket getSocket() {
        return this.socket;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public void setHandshakeComplete(boolean handshakeComplete) {
        this.handshakeComplete = handshakeComplete;
    }

    public PMemoryBIO getNetworkInboundBIO() {
        return this.networkInboundBIO;
    }

    public PMemoryBIO getNetworkOutboundBIO() {
        return this.networkOutboundBIO;
    }

    public PMemoryBIO getApplicationInboundBIO() {
        return this.applicationInboundBIO;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public TruffleString getServerHostname() {
        return this.serverHostname;
    }

    public void setServerHostname(TruffleString serverHostname) {
        this.serverHostname = serverHostname;
    }

    public boolean hasSavedException() {
        return this.exception != null;
    }

    public SSLException getAndClearSavedException() {
        SSLException savedException = this.exception;
        this.exception = null;
        return savedException;
    }

    public void setException(SSLException exception) {
        this.exception = exception;
    }
}

