/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyErrExceptionMatchesNodeGen;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;

@GenerateInline(inlineByDefault=true)
@GenerateUncached
public abstract class PyErrExceptionMatchesNode
extends Node {
    public abstract boolean execute(Node var1, Object var2, Object var3);

    public static boolean executeUncached(Object exception, Object typeOrTuple) {
        return PyErrExceptionMatchesNodeGen.getUncached().execute(null, exception, typeOrTuple);
    }

    @Specialization(guards={"isExceptionType(inliningTarget, type, isTypeNode, isBuiltinClassProfile)"}, limit="1")
    static boolean doException(Node inliningTarget, Object exception, Object type, @Cached BuiltinClassProfiles.IsBuiltinClassProfile isBuiltinClassProfile, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PyExceptionInstanceCheckNode exceptionCheck, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode) {
        if (exceptionCheck.execute(inliningTarget, exception)) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, exception), type);
        }
        if (isTypeNode.execute(inliningTarget, exception)) {
            return isSubtypeNode.execute(exception, type);
        }
        return false;
    }

    @Specialization(guards={"tupleCheck.execute(inliningTarget, tuple)"}, limit="1")
    static boolean doTuple(Node inliningTarget, Object exception, Object tuple, @Cached PyTupleCheckNode tupleCheck, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached(inline=false) PyErrExceptionMatchesNode recursive) {
        SequenceStorage storage = getTupleStorage.execute(inliningTarget, tuple);
        int len = storage.length();
        loopConditionProfile.profileCounted(inliningTarget, (long)len);
        int i = 0;
        while (loopConditionProfile.inject(inliningTarget, i < len)) {
            if (recursive.execute(null, exception, getItemScalarNode.execute(inliningTarget, storage, i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Fallback
    static boolean fallback(Object exception, Object invalid) {
        return false;
    }

    protected static boolean isExceptionType(Node inliningTarget, Object type, TypeNodes.IsTypeNode isTypeNode, BuiltinClassProfiles.IsBuiltinClassProfile isBuiltinClassProfile) {
        return isTypeNode.execute(inliningTarget, type) && isBuiltinClassProfile.profileClass(inliningTarget, type, PythonBuiltinClassType.PBaseException);
    }
}

