/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.posix.PScandirIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyNumberDivmodNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyOSFSPathNode;
import com.oracle.graal.python.lib.PyObjectAsFileDescriptor;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="posix", extendsModule="nt", isEager=true)
public final class PosixModuleBuiltins
extends PythonBuiltins {
    static final StructSequence.BuiltinTypeDescriptor STAT_RESULT_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStatResult, 10, new String[]{"st_mode", "st_ino", "st_dev", "st_nlink", "st_uid", "st_gid", "st_size", null, null, null, "st_atime", "st_mtime", "st_ctime", "st_atime_ns", "st_mtime_ns", "st_ctime_ns"}, new String[]{"protection bits", "inode", "device", "number of hard links", "user ID of owner", "group ID of owner", "total size, in bytes", "integer time of last access", "integer time of last modification", "integer time of last change", "time of last access", "time of last modification", "time of last change", "time of last access in nanoseconds", "time of last modification in nanoseconds", "time of last change in nanoseconds"});
    static final StructSequence.BuiltinTypeDescriptor STATVFS_RESULT_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStatvfsResult, 10, new String[]{"f_bsize", "f_frsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_favail", "f_flag", "f_namemax", "f_fsid"}, null);
    private static final StructSequence.BuiltinTypeDescriptor TERMINAL_SIZE_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PTerminalSize, 2, new String[]{"columns", "lines"}, new String[]{"width of the terminal window in characters", "height of the terminal window in characters"});
    private static final StructSequence.BuiltinTypeDescriptor UNAME_RESULT_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PUnameResult, 5, new String[]{"sysname", "nodename", "release", "version", "machine"}, new String[]{"operating system name", "name of machine on network (implementation-defined)", "operating system release", "operating system version", "hardware identifier"});
    public static final int EMULATED_WNOHANG = 1;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PosixModuleBuiltinsFactory.getFactories();
    }

    public PosixModuleBuiltins() {
        this.addConstants(PosixConstants.openFlags);
        this.addConstants(PosixConstants.waitOptions);
        this.addConstants(PosixConstants.accessMode);
        this.addConstants(PosixConstants.exitStatus);
        this.addConstants(PosixConstants.rtld);
        for (PosixConstants.IntConstant c : PosixConstants.winapiLoadLibraryFlags) {
            if (!c.defined) continue;
            this.addBuiltinConstant("_" + c.name, (Object)c.getValueIfDefined());
        }
        this.addConstant(PosixConstants.SEEK_DATA);
        this.addConstant(PosixConstants.SEEK_HOLE);
    }

    private void addConstant(PosixConstants.IntConstant c) {
        if (c.defined) {
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
    }

    private void addConstants(PosixConstants.IntConstant[] constants) {
        for (PosixConstants.IntConstant c : constants) {
            this.addConstant(c);
        }
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        ArrayList<TruffleString> haveFunctions = new ArrayList<TruffleString>();
        if (PythonOS.getPythonOS() != PythonOS.PLATFORM_WIN32) {
            Collections.addAll(haveFunctions, PythonUtils.tsLiteral("HAVE_FACCESSAT"), PythonUtils.tsLiteral("HAVE_FCHDIR"), PythonUtils.tsLiteral("HAVE_FCHMOD"), PythonUtils.tsLiteral("HAVE_FCHMODAT"), PythonUtils.tsLiteral("HAVE_FDOPENDIR"), PythonUtils.tsLiteral("HAVE_FSTATAT"), PythonUtils.tsLiteral("HAVE_FTRUNCATE"), PythonUtils.tsLiteral("HAVE_FUTIMES"), PythonUtils.tsLiteral("HAVE_LUTIMES"), PythonUtils.tsLiteral("HAVE_MKDIRAT"), PythonUtils.tsLiteral("HAVE_OPENAT"), PythonUtils.tsLiteral("HAVE_READLINKAT"), PythonUtils.tsLiteral("HAVE_RENAMEAT"), PythonUtils.tsLiteral("HAVE_SYMLINKAT"), PythonUtils.tsLiteral("HAVE_UNLINKAT"));
            if (PosixConstants.HAVE_FUTIMENS.value) {
                haveFunctions.add(PythonUtils.tsLiteral("HAVE_FUTIMENS"));
            }
            if (PosixConstants.HAVE_UTIMENSAT.value) {
                haveFunctions.add(PythonUtils.tsLiteral("HAVE_UTIMENSAT"));
            }
        } else {
            haveFunctions.add(PythonUtils.tsLiteral("HAVE_FTRUNCATE"));
            haveFunctions.add(PythonUtils.tsLiteral("MS_WINDOWS"));
        }
        PythonLanguage language = core.getLanguage();
        this.addBuiltinConstant("_have_functions", (Object)PFactory.createList(language, haveFunctions.toArray()));
        this.addBuiltinConstant(BuiltinNames.T_ENVIRON, (Object)PFactory.createDict(language));
        LinkedHashMap<String, Object> sysconfigNames = new LinkedHashMap<String, Object>();
        for (PosixConstants.IntConstant name : PosixConstants.sysconfigNames) {
            if (!name.defined) continue;
            String pythonName = name.name.startsWith("_") ? name.name.substring(1) : name.name;
            sysconfigNames.put(pythonName, name.getValueIfDefined());
        }
        this.addBuiltinConstant("sysconf_names", (Object)PFactory.createDictFromMap(language, sysconfigNames));
        StructSequence.initType(core, STAT_RESULT_DESC);
        StructSequence.initType(core, STATVFS_RESULT_DESC);
        StructSequence.initType(core, TERMINAL_SIZE_DESC);
        StructSequence.initType(core, UNAME_RESULT_DESC);
        PythonModule posix = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? core.lookupBuiltinModule(BuiltinNames.T_NT) : core.lookupBuiltinModule(BuiltinNames.T_POSIX);
        posix.setAttribute(PythonBuiltinClassType.PStatResult.getName(), core.lookupType(PythonBuiltinClassType.PStatResult));
        posix.setAttribute(PythonBuiltinClassType.PStatvfsResult.getName(), core.lookupType(PythonBuiltinClassType.PStatvfsResult));
        posix.setAttribute(PythonBuiltinClassType.PTerminalSize.getName(), core.lookupType(PythonBuiltinClassType.PTerminalSize));
        posix.setAttribute(PythonUtils.tsLiteral("error"), core.lookupType(PythonBuiltinClassType.OSError));
    }

    @Override
    public void postInitialize(Python3Core core) {
        PythonModule posix;
        super.postInitialize(core);
        PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
        PosixSupport posixSupport = core.getContext().getPosixSupport();
        PythonLanguage language = core.getLanguage();
        Map getenv = core.getContext().getEnv().getEnvironment();
        PDict environ = PFactory.createDict(language);
        String pyenvLauncherKey = "__PYVENV_LAUNCHER__";
        for (Map.Entry entry : getenv.entrySet()) {
            if ((((String)entry.getKey()).equals("GRAAL_PYTHON_ARGS") || ((String)entry.getKey()).equals("GRAAL_PYTHON_VM_ARGS")) && ((String)entry.getValue()).endsWith("\u000b") || PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 && ((String)entry.getKey()).startsWith("=")) continue;
            Object key = PosixModuleBuiltins.toEnv(language, (String)entry.getKey());
            Object val = PosixModuleBuiltins.toEnv(language, (String)entry.getValue());
            if (pyenvLauncherKey.equals(entry.getKey())) {
                TruffleString value = core.getContext().getOption(PythonOptions.Executable);
                try {
                    Object k = posixLib.createPathFromString(posixSupport, PythonUtils.toTruffleStringUncached(pyenvLauncherKey));
                    Object v = posixLib.createPathFromString(posixSupport, value);
                    posixLib.setenv(posixSupport, k, v, true);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
                val = PosixModuleBuiltins.toEnv(language, value);
            }
            environ.setItem(key, val);
        }
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            environ.setItem(PosixModuleBuiltins.toEnv(language, "PIP_NO_CACHE_DIR"), PosixModuleBuiltins.toEnv(language, "0"));
        }
        environ.setItem(PosixModuleBuiltins.toEnv(language, "UNSAFE_PYO3_SKIP_VERSION_CHECK"), PosixModuleBuiltins.toEnv(language, "1"));
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            posix = core.lookupBuiltinModule(BuiltinNames.T_NT);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("chown"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("fchown"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("lchown"), PNone.NO_VALUE);
        } else {
            posix = core.lookupBuiltinModule(BuiltinNames.T_POSIX);
        }
        Object environAttr = posix.getAttribute(BuiltinNames.T_ENVIRON);
        ((PDict)environAttr).setDictStorage(environ.getDictStorage());
        if (posixLib.getBackend(posixSupport).toJavaStringUncached().equals("java")) {
            posix.setAttribute(PythonUtils.toTruffleStringUncached("geteuid"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("getegid"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("WNOHANG"), 1);
        }
    }

    private static Object toEnv(PythonLanguage language, String value) {
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            return PythonUtils.toTruffleStringUncached(value);
        }
        return PFactory.createBytes(language, value.getBytes());
    }

    private static Object toEnv(PythonLanguage language, TruffleString value) {
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            return value;
        }
        return PFactory.createBytes(language, value.toJavaStringUncached().getBytes());
    }

    public static int mapPythonSeekWhenceToPosix(int pythonWhence) {
        switch (pythonWhence) {
            case 0: {
                return PosixConstants.SEEK_SET.value;
            }
            case 1: {
                return PosixConstants.SEEK_CUR.value;
            }
            case 2: {
                return PosixConstants.SEEK_END.value;
            }
        }
        return pythonWhence;
    }

    private static PTuple createStatvfsResult(Node inliningTarget, long[] out, InlinedConditionProfile positiveLongProfile, PythonLanguage language) {
        Object[] res = new Object[out.length];
        for (int i = 0; i < out.length; ++i) {
            res[i] = PInt.createPythonIntFromUnsignedLong(inliningTarget, language, positiveLongProfile, out[i]);
        }
        return PFactory.createStructSeq(language, STATVFS_RESULT_DESC, res);
    }

    static Object dupAndFdopendir(VirtualFrame frame, Node inliningTarget, PosixSupportLibrary posixLib, Object posixSupport, PosixFd fd, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
        int dupFd = -1;
        try {
            dupFd = posixLib.dup(posixSupport, fd.fd);
            return posixLib.fdopendir(posixSupport, dupFd);
        }
        catch (PosixSupportLibrary.PosixException e) {
            if (dupFd != -1) {
                try {
                    posixLib.close(posixSupport, dupFd);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
            }
            throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
        }
    }

    static int dirFdForAudit(int dirFd) {
        return dirFd == PosixConstants.AT_FDCWD.value ? -1 : dirFd;
    }

    public static PTuple createStatResult(Node inliningTarget, PythonLanguage language, InlinedConditionProfile positiveLongProfile, long[] out) {
        int i;
        Object[] res = new Object[16];
        for (i = 0; i < 7; ++i) {
            res[i] = PInt.createPythonIntFromUnsignedLong(inliningTarget, language, positiveLongProfile, out[i]);
        }
        res[6] = out[6];
        for (i = 7; i < 10; ++i) {
            long seconds = out[i];
            long nsFraction = out[i + 3];
            res[i] = seconds;
            res[i + 3] = (double)seconds + (double)nsFraction * 1.0E-9;
            res[i + 6] = PFactory.createInt(language, PosixModuleBuiltins.convertToNanoseconds(seconds, nsFraction));
        }
        return PFactory.createStructSeq(language, STAT_RESULT_DESC, res);
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger convertToNanoseconds(long sec, long ns) {
        BigInteger r = BigInteger.valueOf(sec);
        r = r.multiply(BigInteger.valueOf(1000000000L));
        return r.add(BigInteger.valueOf(ns));
    }

    public static PBytes opaquePathToBytes(Object opaquePath, PosixSupportLibrary posixLib, Object posixSupport, PythonLanguage language) {
        PosixSupportLibrary.Buffer buf = posixLib.getPathAsBytes(posixSupport, opaquePath);
        if (buf.length > Integer.MAX_VALUE) {
            throw CompilerDirectives.shouldNotReachHere((String)"Posix path cannot fit into a Java array");
        }
        return PFactory.createBytes(language, buf.data, (int)buf.length);
    }

    public static class PosixFd
    extends PosixFileHandle {
        public final int fd;

        public PosixFd(Object originalObject, int fd) {
            super(originalObject);
            this.fd = fd;
        }
    }

    public static class PosixPath
    extends PosixFileHandle {
        public final Object value;
        public final boolean wasBufferLike;

        public PosixPath(Object originalObject, Object value, boolean wasBufferLike) {
            super(originalObject);
            this.value = value;
            this.wasBufferLike = wasBufferLike;
        }
    }

    public static abstract class PosixFileHandle {
        public final Object originalObject;

        protected PosixFileHandle(Object originalObject) {
            this.originalObject = originalObject;
        }
    }

    public static abstract class GidConversionNode
    extends AbstractIdConversionNode {
        @Override
        protected String getIdName() {
            return "gid";
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static GidConversionNode create() {
            return PosixModuleBuiltinsFactory.GidConversionNodeGen.create();
        }
    }

    public static abstract class UidConversionNode
    extends AbstractIdConversionNode {
        @Override
        protected String getIdName() {
            return "uid";
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static UidConversionNode create() {
            return PosixModuleBuiltinsFactory.UidConversionNodeGen.create();
        }
    }

    @GenerateCached(value=false)
    public static abstract class AbstractIdConversionNode
    extends ArgumentCastNode {
        private static final long MAX_UINT32 = 0xFFFFFFFFL;

        public abstract long executeLong(VirtualFrame var1, Object var2);

        @Specialization
        long doInt(int value, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return this.checkValue(inliningTarget, value, raiseNode);
        }

        @Specialization
        long doLong(long value, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return this.checkValue(inliningTarget, value, raiseNode);
        }

        @Specialization(guards={"!isInteger(value)"})
        long doGeneric(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyNumberIndexNode pyNumberIndexNode, @Cached PyLongAsLongNode asLongNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object index;
            try {
                index = pyNumberIndexNode.execute((Frame)frame, inliningTarget, value);
            }
            catch (PException ex) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_SHOULD_BE_INTEGER_NOT_P, this.getIdName(), value);
            }
            return this.checkValue(inliningTarget, asLongNode.execute((Frame)frame, inliningTarget, index), raiseNode);
        }

        private long checkValue(Node inliningTarget, long value, PRaiseNode raiseNode) {
            if (value < -1L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.S_IS_LESS_THAN_MINIMUM, this.getIdName());
            }
            if (value > 0xFFFFFFFFL) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.S_IS_GREATER_THAN_MAXIUMUM, this.getIdName());
            }
            return value;
        }

        protected abstract String getIdName();
    }

    public static abstract class PidtConversionNode
    extends ArgumentCastNode {
        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Specialization(guards={"!isInteger(value)"})
        static long doGeneric(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyLongAsLongNode asLongNode) {
            return asLongNode.execute((Frame)frame, inliningTarget, value);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static PidtConversionNode create() {
            return PosixModuleBuiltinsFactory.PidtConversionNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class FileDescriptorConversionNode
    extends ArgumentCastNode {
        @Specialization
        static int doIndex(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyObjectAsFileDescriptor asFileDescriptor) {
            return asFileDescriptor.execute((Frame)frame, inliningTarget, value);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
        @NeverDefault
        public static FileDescriptorConversionNode create() {
            return PosixModuleBuiltinsFactory.FileDescriptorConversionNodeGen.create();
        }
    }

    public static abstract class OffsetConversionNode
    extends ArgumentCastNode {
        @Specialization
        static long doInt(int i) {
            return i;
        }

        @Specialization
        static long doLong(long l) {
            return l;
        }

        @Specialization
        static long doOthers(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyLongAsLongNode asLongNode) {
            return asLongNode.execute((Frame)frame, inliningTarget, value);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static OffsetConversionNode create() {
            return PosixModuleBuiltinsFactory.OffsetConversionNodeGen.create();
        }
    }

    public static abstract class PathConversionNode
    extends ArgumentCastNode {
        private final String functionNameWithColon;
        private final String argumentName;
        protected final boolean nullable;
        protected final boolean allowFd;

        public PathConversionNode(String functionName, String argumentName, boolean nullable, boolean allowFd) {
            this.functionNameWithColon = functionName != null ? functionName + ": " : "";
            this.argumentName = argumentName != null ? argumentName : "path";
            this.nullable = nullable;
            this.allowFd = allowFd;
        }

        @Specialization(guards={"nullable"})
        PosixFileHandle doNone(PNone value, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object path = posixLib.createPathFromString(context.getPosixSupport(), StringLiterals.T_DOT);
            return new PosixPath(null, this.checkPath(inliningTarget, path, raiseNode), false);
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdBool(boolean value) {
            return new PosixFd(value, PInt.intValue(value));
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdInt(int value) {
            return new PosixFd(value, value);
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdLong(long value, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return new PosixFd(value, DirFdConversionNode.longToFd(inliningTarget, value, raiseNode));
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdPInt(PInt value, @Bind Node inliningTarget, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return new PosixFd(value, DirFdConversionNode.longToFd(inliningTarget, castToLongNode.execute(inliningTarget, value), raiseNode));
        }

        @Specialization(guards={"isString(value)"})
        PosixFileHandle doUnicode(Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode castToStringNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString str = castToStringNode.execute(inliningTarget, value);
            Object path = posixLib.createPathFromString(context.getPosixSupport(), str);
            return new PosixPath(value, this.checkPath(inliningTarget, path, raiseNode), false);
        }

        @Specialization
        PosixFileHandle doBytes(PBytes value, @Bind Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.ToBytesNode toByteArrayNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object path = posixLib.createPathFromBytes(context.getPosixSupport(), toByteArrayNode.execute(value));
            return new PosixPath(value, this.checkPath(inliningTarget, path, raiseNode), true);
        }

        @Specialization(guards={"!isHandled(value)", "allowFd", "indexCheckNode.execute(this, value)"}, limit="1")
        PosixFileHandle doIndex(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object o = indexNode.execute((Frame)frame, inliningTarget, value);
            return new PosixFd(value, DirFdConversionNode.longToFd(inliningTarget, castToLongNode.execute(inliningTarget, o), raiseNode));
        }

        @Specialization(guards={"!isHandled(value)", "!allowFd || !indexCheckNode.execute(this, value)"}, limit="1")
        PosixFileHandle doGeneric(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyIndexCheckNode indexCheckNode, @Cached(value="create(T___FSPATH__)") LookupAndCallUnaryNode callFSPath, @Cached.Exclusive @Cached BytesNodes.ToBytesNode toByteArrayNode, @Cached.Exclusive @Cached CastToTruffleStringNode castToStringNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object pathObject = callFSPath.executeObject(frame, value);
            if (pathObject == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_S_SHOULD_BE_S_NOT_P, this.functionNameWithColon, this.argumentName, this.getAllowedTypes(), value);
            }
            if (pathObject instanceof PBytes) {
                return this.doBytes((PBytes)pathObject, inliningTarget, toByteArrayNode, context, posixLib, raiseNode);
            }
            if (PGuards.isString(pathObject)) {
                return this.doUnicode(pathObject, inliningTarget, castToStringNode, context, posixLib, raiseNode);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_FSPATH_TO_RETURN_STR_OR_BYTES, value, pathObject);
        }

        protected boolean isHandled(Object value) {
            return PGuards.isPNone(value) && this.nullable || PGuards.canBeInteger(value) && this.allowFd || PGuards.isString(value) || PGuards.isPBytes(value);
        }

        private String getAllowedTypes() {
            return this.allowFd && this.nullable ? "string, bytes, os.PathLike, integer or None" : (this.allowFd ? "string, bytes, os.PathLike or integer" : (this.nullable ? "string, bytes, os.PathLike or None" : "string, bytes or os.PathLike"));
        }

        private Object checkPath(Node inliningTarget, Object path, PRaiseNode raiseNode) {
            if (path == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.S_EMBEDDED_NULL_CHARACTER_IN_S, this.functionNameWithColon, this.argumentName);
            }
            return path;
        }

        @ClinicConverterFactory
        @NeverDefault
        public static PathConversionNode create(@ClinicConverterFactory.BuiltinName String functionName, @ClinicConverterFactory.ArgumentName String argumentName, boolean nullable, boolean allowFd) {
            return PosixModuleBuiltinsFactory.PathConversionNodeGen.create(functionName, argumentName, nullable, allowFd);
        }
    }

    public static abstract class DirFdConversionNode
    extends ArgumentCastNode {
        @Specialization
        static int doNone(PNone value) {
            return PosixConstants.AT_FDCWD.value;
        }

        @Specialization
        static int doFdBool(boolean value) {
            return PInt.intValue(value);
        }

        @Specialization
        static int doFdInt(int value) {
            return value;
        }

        @Specialization
        static int doFdLong(long value, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return DirFdConversionNode.longToFd(inliningTarget, value, raiseNode);
        }

        @Specialization
        static int doFdPInt(PInt value, @Bind Node inliningTarget, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return DirFdConversionNode.doFdLong(castToLongNode.execute(inliningTarget, value), inliningTarget, raiseNode);
        }

        @Specialization(guards={"!isPNone(value)", "!canBeInteger(value)"})
        static int doIndex(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (indexCheckNode.execute(inliningTarget, value)) {
                Object o = indexNode.execute((Frame)frame, inliningTarget, value);
                return DirFdConversionNode.doFdLong(castToLongNode.execute(inliningTarget, o), inliningTarget, raiseNode);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_SHOULD_BE_INT_OR_NONE_T, value);
        }

        private static int longToFd(Node inliningTarget, long value, PRaiseNode raiseNode) {
            if (value > Integer.MAX_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.FD_IS_GREATER_THAN_MAXIMUM);
            }
            if (value < Integer.MIN_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.FD_IS_LESS_THAN_MINIMUM);
            }
            return (int)value;
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
        @NeverDefault
        public static DirFdConversionNode create() {
            return PosixModuleBuiltinsFactory.DirFdConversionNodeGen.create();
        }
    }

    public static abstract class FsConverterNode
    extends ArgumentCastNode {
        @Specialization
        static PBytes convert(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyOSFSPathNode fspathNode, @Cached StringOrBytesToBytesNode stringOrBytesToBytesNode) {
            return stringOrBytesToBytesNode.execute(inliningTarget, fspathNode.execute((Frame)frame, inliningTarget, value));
        }

        @ClinicConverterFactory
        @NeverDefault
        public static FsConverterNode create() {
            return PosixModuleBuiltinsFactory.FsConverterNodeGen.create();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class SplitLongToSAndNsNode
    extends ConvertToTimespecBaseNode {
        private static final long BILLION = 1000000000L;

        SplitLongToSAndNsNode() {
        }

        @Specialization
        static void doInt(int value, long[] timespec, int offset) {
            SplitLongToSAndNsNode.doLong(value, timespec, offset);
        }

        @Specialization
        static void doLong(long value, long[] timespec, int offset) {
            timespec[offset] = Math.floorDiv(value, 1000000000L);
            timespec[offset + 1] = Math.floorMod(value, 1000000000L);
        }

        @Specialization(guards={"!isInteger(value)"})
        static void doGeneric(VirtualFrame frame, Node inliningTarget, Object value, long[] timespec, int offset, @Cached PyNumberDivmodNode divmodNode, @Cached SequenceNodes.LenNode lenNode, @Cached(value="createNotNormalized()", inline=false) SequenceStorageNodes.GetItemNode getItemNode, @Cached PyLongAsLongNode asLongNode, @Cached PRaiseNode raiseNode) {
            Object divmod = divmodNode.execute(frame, inliningTarget, value, 1000000000L);
            if (!PGuards.isPTuple(divmod) || lenNode.execute(inliningTarget, (PSequence)divmod) != 2) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_RETURN_2TUPLE, value, divmod);
            }
            SequenceStorage storage = ((PTuple)divmod).getSequenceStorage();
            timespec[offset] = asLongNode.execute((Frame)frame, inliningTarget, getItemNode.execute(storage, 0));
            timespec[offset + 1] = asLongNode.execute((Frame)frame, inliningTarget, getItemNode.execute(storage, 1));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class ObjectToTimespecNode
    extends ConvertToTimespecBaseNode {
        ObjectToTimespecNode() {
        }

        @Specialization
        static void doDouble(Node inliningTarget, double value, long[] timespec, int offset, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (Double.isNaN(value)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INVALID_VALUE_NAN);
            }
            double denominator = 1.0E9;
            double floatPart = value % 1.0;
            double intPart = value - floatPart;
            if ((floatPart = Math.floor(floatPart * denominator)) >= denominator) {
                floatPart -= denominator;
                intPart += 1.0;
            } else if (floatPart < 0.0) {
                floatPart += denominator;
                intPart -= 1.0;
            }
            assert (0.0 <= floatPart && floatPart < denominator);
            if (!MathGuards.fitLong(intPart)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.TIMESTAMP_OUT_OF_RANGE);
            }
            timespec[offset] = (long)intPart;
            timespec[offset + 1] = (long)floatPart;
            assert (0L <= timespec[offset + 1] && timespec[offset + 1] < (long)denominator);
        }

        @Specialization
        static void doPFloat(Node inliningTarget, PFloat obj, long[] timespec, int offset, @Cached.Shared @Cached PRaiseNode raiseNode) {
            ObjectToTimespecNode.doDouble(inliningTarget, obj.getValue(), timespec, offset, raiseNode);
        }

        @Specialization
        static void doInt(int value, long[] timespec, int offset) {
            timespec[offset] = value;
            timespec[offset + 1] = 0L;
        }

        @Specialization
        static void doLong(long value, long[] timespec, int offset) {
            timespec[offset] = value;
            timespec[offset + 1] = 0L;
        }

        @Specialization(guards={"!isDouble(value)", "!isPFloat(value)", "!isInteger(value)"})
        static void doGeneric(VirtualFrame frame, Node inliningTarget, Object value, long[] timespec, int offset, @Cached PyLongAsLongAndOverflowNode asLongNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            try {
                timespec[offset] = asLongNode.execute((Frame)frame, inliningTarget, value);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.TIMESTAMP_OUT_OF_RANGE);
            }
            timespec[offset + 1] = 0L;
        }
    }

    static abstract class ConvertToTimespecBaseNode
    extends Node {
        ConvertToTimespecBaseNode() {
        }

        abstract void execute(VirtualFrame var1, Node var2, Object var3, long[] var4, int var5);
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ObjectToOpaquePathNode
    extends Node {
        ObjectToOpaquePathNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, boolean var4);

        @Specialization(guards={"!checkEmpty"})
        static Object noCheck(VirtualFrame frame, Node inliningTarget, Object obj, boolean checkEmpty, @Cached.Exclusive @Cached PyOSFSPathNode fspathNode, @Cached.Exclusive @Cached StringOrBytesToOpaquePathNode stringOrBytesToOpaquePathNode) {
            return stringOrBytesToOpaquePathNode.execute(inliningTarget, fspathNode.execute((Frame)frame, inliningTarget, obj));
        }

        @Specialization(guards={"checkEmpty"})
        static Object withCheck(VirtualFrame frame, Node inliningTarget, Object obj, boolean checkEmpty, @Cached.Exclusive @Cached PyOSFSPathNode fspathNode, @Cached PyObjectSizeNode sizeNode, @Cached.Exclusive @Cached StringOrBytesToOpaquePathNode stringOrBytesToOpaquePathNode, @Cached PRaiseNode raiseNode) {
            Object stringOrBytes = fspathNode.execute((Frame)frame, inliningTarget, obj);
            if (sizeNode.execute((Frame)frame, inliningTarget, obj) == 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EXECV_ARG2_FIRST_ELEMENT_CANNOT_BE_EMPTY);
            }
            return stringOrBytesToOpaquePathNode.execute(inliningTarget, stringOrBytes);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class StringOrBytesToOpaquePathNode
    extends Node {
        StringOrBytesToOpaquePathNode() {
        }

        abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"isString(strObj)"})
        static Object doString(Node inliningTarget, Object strObj, @Cached CastToTruffleStringNode castToStringNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString str = castToStringNode.execute(inliningTarget, strObj);
            return StringOrBytesToOpaquePathNode.checkPath(inliningTarget, posixLib.createPathFromString(context.getPosixSupport(), str), raiseNode);
        }

        @Specialization
        static Object doBytes(Node inliningTarget, PBytes bytes, @Cached(inline=false) BytesNodes.ToBytesNode toBytesNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return StringOrBytesToOpaquePathNode.checkPath(inliningTarget, posixLib.createPathFromBytes(context.getPosixSupport(), toBytesNode.execute(bytes)), raiseNode);
        }

        private static Object checkPath(Node inliningTarget, Object path, PRaiseNode raiseNode) {
            if (path == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return path;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class StringOrBytesToBytesNode
    extends Node {
        public abstract PBytes execute(Node var1, Object var2);

        @Specialization(guards={"isString(strObj)"})
        static PBytes doString(Node inliningTarget, Object strObj, @Bind PythonLanguage language, @Cached CastToTruffleStringNode castToStringNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached(inline=false) TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            TruffleString str = castToStringNode.execute(inliningTarget, strObj);
            TruffleString utf8 = switchEncodingNode.execute((AbstractTruffleString)str, TruffleString.Encoding.UTF_8);
            byte[] bytes = new byte[utf8.byteLength(TruffleString.Encoding.UTF_8)];
            copyToByteArrayNode.execute((AbstractTruffleString)utf8, 0, bytes, 0, bytes.length, TruffleString.Encoding.UTF_8);
            return PFactory.createBytes(language, bytes);
        }

        @Specialization
        static PBytes doBytes(PBytes bytes) {
            return bytes;
        }
    }

    @Builtin(name="register_at_fork", keywordOnlyNames={"before", "after_in_child", "after_in_parent"})
    @GenerateNodeFactory
    static abstract class RegisterAtForkNode
    extends PythonBuiltinNode {
        RegisterAtForkNode() {
        }

        @Specialization
        static Object register(Object before, Object afterInChild, Object afterInParent) {
            return PNone.NONE;
        }
    }

    @Builtin(name="fspath", minNumOfPositionalArgs=1, parameterNames={"path"})
    @GenerateNodeFactory
    public static abstract class FspathNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doTrivial(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyOSFSPathNode fsPathNode) {
            return fsPathNode.execute((Frame)frame, inliningTarget, value);
        }
    }

    @Builtin(name="killpg", minNumOfPositionalArgs=2, parameterNames={"pgid", "signal"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pgid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="signal", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    static abstract class KillPgNode
    extends PythonBinaryClinicBuiltinNode {
        KillPgNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.KillNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone kill(VirtualFrame frame, long pid, int signal, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "killpg", pid, signal);
            try {
                posixLib.killpg(context.getPosixSupport(), pid, signal);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
        }
    }

    @Builtin(name="kill", minNumOfPositionalArgs=2, parameterNames={"pid", "signal"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="signal", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    static abstract class KillNode
    extends PythonBinaryClinicBuiltinNode {
        KillNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.KillNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone kill(VirtualFrame frame, long pid, int signal, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "kill", pid, signal);
            try {
                posixLib.kill(context.getPosixSupport(), pid, signal);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
        }
    }

    @Builtin(name="ctermid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class CtermId
    extends PythonBuiltinNode {
        CtermId() {
        }

        @Specialization
        static TruffleString ctermid(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.ctermid(context.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="umask", minNumOfPositionalArgs=1, parameterNames={"mask"})
    @ArgumentClinic(name="mask", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class UmaskNode
    extends PythonUnaryClinicBuiltinNode {
        UmaskNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UmaskNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int umask(VirtualFrame frame, int mask, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.umask(context.getPosixSupport(), mask);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="sysconf", minNumOfPositionalArgs=2, parameterNames={"$self", "name"}, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class SysconfNode
    extends PythonBinaryBuiltinNode {
        private static final TruffleString T_SYSCONF_NAMES = PythonUtils.tsLiteral("sysconf_names");

        SysconfNode() {
        }

        @Specialization
        static long sysconf(VirtualFrame frame, PythonModule self, Object arg, @Bind Node inliningTarget, @Cached PyLongCheckNode longCheckNode, @Cached PyLongAsIntNode asIntNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PyObjectGetAttr getAttr, @Cached PyObjectGetItem getItem, @Cached PRaiseNode raiseNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int id;
            if (longCheckNode.execute(inliningTarget, arg)) {
                id = asIntNode.execute((Frame)frame, inliningTarget, arg);
            } else if (unicodeCheckNode.execute(inliningTarget, arg)) {
                try {
                    Object sysconfigNamesObject = getAttr.execute((Frame)frame, inliningTarget, self, T_SYSCONF_NAMES);
                    Object idObj = getItem.execute((Frame)frame, inliningTarget, sysconfigNamesObject, arg);
                    id = asIntNode.execute((Frame)frame, inliningTarget, idObj);
                }
                catch (PException e) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.UNRECOGNIZED_CONF_NAME);
                }
            } else {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CONFIGURATION_NAMES_MUST_BE_STRINGS_OR_INTEGERS);
            }
            try {
                return posixLib.sysconf(context.getPosixSupport(), id);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="cpu_count", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class CpuCountNode
    extends PythonBuiltinNode {
        CpuCountNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static int getCpuCount() {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    @Builtin(name="urandom", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class URandomNode
    extends PythonUnaryClinicBuiltinNode {
        URandomNode() {
        }

        @Specialization(guards={"size >= 0"})
        static PBytes urandom(int size, @Bind Node inliningTarget, @Bind PythonContext context) {
            byte[] bytes = new byte[size];
            URandomNode.nextBytes(context.getSecureRandom(), bytes);
            return PFactory.createBytes(context.getLanguage(inliningTarget), bytes);
        }

        @Specialization(guards={"size < 0"})
        static Object urandomNeg(int size, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NEG_ARG_NOT_ALLOWED);
        }

        @CompilerDirectives.TruffleBoundary
        private static void nextBytes(SecureRandom secureRandom, byte[] bytes) {
            secureRandom.nextBytes(bytes);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.URandomNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="system", minNumOfPositionalArgs=1, parameterNames={"command"})
    @ArgumentClinic(name="command", conversionClass=FsConverterNode.class)
    @GenerateNodeFactory
    static abstract class SystemNode
    extends PythonUnaryClinicBuiltinNode {
        SystemNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SystemNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static int system(PBytes command, @Bind Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil) {
            auditNode.audit(inliningTarget, "os.system", command);
            byte[] bytes = toBytesNode.execute(command);
            gil.release(true);
            try {
                Object cmdOpaque = posixLib.createPathFromBytes(context.getPosixSupport(), bytes);
                int n = posixLib.system(context.getPosixSupport(), cmdOpaque);
                return n;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="WSTOPSIG", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WstopsigNode
    extends PythonUnaryClinicBuiltinNode {
        WstopsigNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WstopsigNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int wstopsig(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wstopsig(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WTERMSIG", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WtermsigNode
    extends PythonUnaryClinicBuiltinNode {
        WtermsigNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WtermsigNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int wtermsig(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wtermsig(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WEXITSTATUS", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WexitstatusNode
    extends PythonUnaryClinicBuiltinNode {
        WexitstatusNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WexitstatusNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int wexitstatus(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wexitstatus(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFEXITED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifexitedNode
    extends PythonUnaryClinicBuiltinNode {
        WifexitedNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifexitedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean wifexited(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wifexited(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFSIGNALED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifsignaledNode
    extends PythonUnaryClinicBuiltinNode {
        WifsignaledNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifsignaledNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean wifsignaled(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wifsignaled(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFSTOPPED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifstoppedNode
    extends PythonUnaryClinicBuiltinNode {
        WifstoppedNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifstoppedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean wifstopped(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wifstopped(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFCONTINUED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifcontinuedNode
    extends PythonUnaryClinicBuiltinNode {
        WifcontinuedNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifcontinuedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean wifcontinued(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wifcontinued(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="WCOREDUMP", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WcoredumpNode
    extends PythonUnaryClinicBuiltinNode {
        WcoredumpNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WcoredumpNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean wcoredump(int status, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.wcoredump(context.getPosixSupport(), status);
        }
    }

    @Builtin(name="waitstatus_to_exitcode", minNumOfPositionalArgs=1, parameterNames={"status"})
    @GenerateNodeFactory
    static abstract class WaitstatusToExitcodeNode
    extends PythonUnaryBuiltinNode {
        WaitstatusToExitcodeNode() {
        }

        @Specialization
        static int waitstatusToExitcode(VirtualFrame frame, Object statusObj, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached PyLongAsIntNode longAsInt, @Cached PRaiseNode raiseNode) {
            int status = longAsInt.execute((Frame)frame, inliningTarget, statusObj);
            PosixSupport posixSupport = context.getPosixSupport();
            if (posixLib.wifexited(posixSupport, status)) {
                int exitcode = posixLib.wexitstatus(posixSupport, status);
                if (exitcode < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_WEXITSTATUS, exitcode);
                }
                return exitcode;
            }
            if (posixLib.wifsignaled(posixSupport, status)) {
                int signum = posixLib.wtermsig(posixSupport, status);
                if (signum <= 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_WTERMSIG, signum);
                }
                return -signum;
            }
            if (posixLib.wifstopped(posixSupport, status)) {
                int signum = posixLib.wstopsig(posixSupport, status);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.PROCESS_STOPPED_BY_DELIVERY_OF_SIGNAL, signum);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_WAIT_STATUS, status);
        }
    }

    @Builtin(name="waitpid", minNumOfPositionalArgs=2, parameterNames={"pid", "options"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="options", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class WaitpidNode
    extends PythonBinaryClinicBuiltinNode {
        WaitpidNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WaitpidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTuple waitpid(VirtualFrame frame, long pid, int options, @Bind Node inliningTarget, @Cached GilNode gil, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            gil.release(true);
            while (true) {
                try {
                    long[] result = posixLib.waitpid(context.getPosixSupport(), pid, options);
                    PTuple pTuple = PFactory.createTuple(context.getLanguage(inliningTarget), new Object[]{result[0], result[1]});
                    return pTuple;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="_exit", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class ExitNode
    extends PythonUnaryClinicBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public static Object exit(final int status, final @Bind Node node) {
            PythonContext context = PythonContext.get(node);
            if (context.getOption(PythonOptions.RunViaLauncher).booleanValue()) {
                Runtime.getRuntime().halt(status);
            }
            ArrayList<Thread> otherThreads = new ArrayList<Thread>(Arrays.asList(context.getThreads()));
            otherThreads.remove(context.getMainThread());
            otherThreads.remove(Thread.currentThread());
            context.getEnv().submitThreadLocal(otherThreads.toArray(new Thread[0]), new ThreadLocalAction(true, false){

                protected void perform(ThreadLocalAction.Access access) {
                    throw new ThreadDeath();
                }
            });
            if (Thread.currentThread() == context.getMainThread()) {
                throw new PythonExitException(node, status);
            }
            context.getEnv().submitThreadLocal(new Thread[]{context.getMainThread()}, new ThreadLocalAction(true, false){

                protected void perform(ThreadLocalAction.Access access) {
                    throw new PythonExitException(node, status);
                }
            });
            throw new ThreadDeath();
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ExitNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="strerror", minNumOfPositionalArgs=1, parameterNames={"code"})
    @ArgumentClinic(name="code", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class StrErrorNode
    extends PythonUnaryClinicBuiltinNode {
        StrErrorNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.StrErrorNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString getStrError(int code, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.strerror(context.getPosixSupport(), code);
        }
    }

    @Builtin(name="readlink", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"}, doc="readlink(path, *, dir_fd=None) -> path\n\nReturn a string representing the path to which the symbolic link points.\n")
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class ReadlinkNode
    extends PythonClinicBuiltinNode {
        ReadlinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ReadlinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object readlinkAsBytes(VirtualFrame frame, PosixPath path, int dirFd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile wasBufferLikeProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                Object link = posixLib.readlinkat(context.getPosixSupport(), dirFd, path.value);
                if (wasBufferLikeProfile.profile(inliningTarget, path.wasBufferLike)) {
                    return PosixModuleBuiltins.opaquePathToBytes(link, posixLib, context.getPosixSupport(), context.getLanguage(inliningTarget));
                }
                return posixLib.getPathAsString(context.getPosixSupport(), link);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }
    }

    @Builtin(name="chown", minNumOfPositionalArgs=3, parameterNames={"path", "uid", "gid"}, keywordOnlyNames={"dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="uid", conversionClass=UidConversionNode.class), @ArgumentClinic(name="gid", conversionClass=GidConversionNode.class), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class ChownNode
    extends PythonClinicBuiltinNode {
        ChownNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object chown(VirtualFrame frame, PosixPath path, long uid, long gid, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            auditNode.audit(inliningTarget, "os.chown", path.originalObject, uid, gid, dirFd != PosixConstants.AT_FDCWD.value ? dirFd : -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchownat(context.getPosixSupport(), dirFd, path.value, uid, gid, followSymlinks);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object chown(VirtualFrame frame, PosixFd fd, long uid, long gid, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (dirFd != PosixConstants.AT_FDCWD.value) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_BOTH_DIR_FD_AND_FD);
            }
            if (followSymlinks) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "chown");
            }
            auditNode.audit(inliningTarget, "os.chown", fd.originalObject, uid, gid, -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchown(context.getPosixSupport(), fd.fd, uid, gid);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ChownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="lchown", parameterNames={"path", "uid", "gid"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="uid", conversionClass=UidConversionNode.class), @ArgumentClinic(name="gid", conversionClass=GidConversionNode.class)})
    @GenerateNodeFactory
    static abstract class LChownNode
    extends PythonTernaryClinicBuiltinNode {
        LChownNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object chown(VirtualFrame frame, PosixPath path, long uid, long gid, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.chown", path.originalObject, uid, gid, -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchownat(context.getPosixSupport(), PosixConstants.AT_FDCWD.value, path.value, uid, gid, false);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LChownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="fchown", parameterNames={"fd", "uid", "gid"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="uid", conversionClass=UidConversionNode.class), @ArgumentClinic(name="gid", conversionClass=GidConversionNode.class)})
    @GenerateNodeFactory
    static abstract class FChownNode
    extends PythonTernaryClinicBuiltinNode {
        FChownNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object chown(VirtualFrame frame, int fd, long uid, long gid, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.chown", fd, uid, gid, -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchown(context.getPosixSupport(), fd, uid, gid);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FChownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="chmod", minNumOfPositionalArgs=2, parameterNames={"path", "mode"}, keywordOnlyNames={"dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", defaultValue="true", conversion=ArgumentClinic.ClinicConversion.Boolean)})
    @GenerateNodeFactory
    static abstract class ChmodNode
    extends PythonClinicBuiltinNode {
        ChmodNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ChmodNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone chmodFollow(VirtualFrame frame, PosixPath path, int mode, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            auditNode.audit(inliningTarget, "os.chmod", path.originalObject, mode, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.fchmodat(context.getPosixSupport(), dirFd, path.value, mode, followSymlinks);
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (e.getErrorCode() == OSErrorEnum.EOPNOTSUPP.getNumber() && !followSymlinks) {
                    if (dirFd != PosixConstants.AT_FDCWD.value) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "chmod");
                    }
                    throw raiseNode.raise(inliningTarget, PythonErrorType.NotImplementedError, ErrorMessages.UNAVAILABLE_ON_THIS_PLATFORM, "chmod", "follow_symlinks");
                }
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        @Specialization
        static PNone chmodFollow(VirtualFrame frame, PosixFd fd, int mode, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            auditNode.audit(inliningTarget, "os.chmod", fd.originalObject, mode, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.fchmod(context.getPosixSupport(), fd.fd, mode);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="fchmod", minNumOfPositionalArgs=2, parameterNames={"fd", "mode"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class FChmodNode
    extends PythonBinaryClinicBuiltinNode {
        FChmodNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FChmodNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone fchmod(VirtualFrame frame, int fd, int mode, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.chmod", fd, mode, -1);
            try {
                posixLib.fchmod(context.getPosixSupport(), fd, mode);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="access", minNumOfPositionalArgs=2, parameterNames={"path", "mode"}, keywordOnlyNames={"dir_fd", "effective_ids", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="effective_ids", defaultValue="false", conversion=ArgumentClinic.ClinicConversion.Boolean), @ArgumentClinic(name="follow_symlinks", defaultValue="true", conversion=ArgumentClinic.ClinicConversion.Boolean)})
    @GenerateNodeFactory
    static abstract class AccessNode
    extends PythonClinicBuiltinNode {
        AccessNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.AccessNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean access(PosixPath path, int mode, int dirFd, boolean effectiveIds, boolean followSymlinks, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.faccessat(context.getPosixSupport(), dirFd, path.value, mode, effectiveIds, followSymlinks);
        }
    }

    @Builtin(name="replace", minNumOfPositionalArgs=2, parameterNames={"src", "dst"}, keywordOnlyNames={"src_dir_fd", "dst_dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="src_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="dst_dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class ReplaceNode
    extends RenameNode {
        ReplaceNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ReplaceNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="rename", minNumOfPositionalArgs=2, parameterNames={"src", "dst"}, keywordOnlyNames={"src_dir_fd", "dst_dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="src_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="dst_dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class RenameNode
    extends PythonClinicBuiltinNode {
        RenameNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.RenameNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone rename(VirtualFrame frame, PosixPath src, PosixPath dst, int srcDirFd, int dstDirFd, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.rename", src.originalObject, dst.originalObject, PosixModuleBuiltins.dirFdForAudit(srcDirFd), PosixModuleBuiltins.dirFdForAudit(dstDirFd));
            try {
                posixLib.renameat(context.getPosixSupport(), srcDirFd, src.value, dstDirFd, dst.value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, src.originalObject, dst.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="utime", minNumOfPositionalArgs=1, parameterNames={"path", "times"}, keywordOnlyNames={"ns", "dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    @ImportStatic(value={PosixConstants.class})
    static abstract class UtimeNode
    extends PythonClinicBuiltinNode {
        UtimeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UtimeNodeClinicProviderGen.INSTANCE;
        }

        private static Object checkNone(Object o) {
            return PGuards.isPNone(o) ? PNone.NONE : o;
        }

        @Specialization(guards={"HAVE_UTIMENSAT.value"})
        static PNone utimensat(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long[] timespec = timespecNode.execute(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", path.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.utimensat(context.getPosixSupport(), dirFd, path.value, timespec, followSymlinks);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "isDefault(dirFd)", "followSymlinks"})
        static PNone utimes(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.Timeval[] timeval = timespecNode.toTimeval(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", path.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.utimes(context.getPosixSupport(), path.value, timeval);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "isDefault(dirFd)", "!followSymlinks"})
        static PNone lutimes(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.Timeval[] timeval = timespecNode.toTimeval(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", path.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.lutimes(context.getPosixSupport(), path.value, timeval);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "!isDefault(dirFd)", "followSymlinks"})
        static PNone dirFdNotSupported(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.NotImplementedError, ErrorMessages.UNAVAILABLE_ON_THIS_PLATFORM_NO_FUNC, "dir_fd");
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "!isDefault(dirFd)", "!followSymlinks"})
        static PNone dirFdAndFollowSymlinksNotSupported(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.UTIME_CANNOT_USE_DIR_FD_AND_FOLLOW_SYMLINKS, "dir_fd");
        }

        @Specialization(guards={"HAVE_FUTIMENS.value", "isDefault(dirFd)", "followSymlinks"})
        static PNone futimens(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long[] timespec = timespecNode.execute(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", fd.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.futimens(context.getPosixSupport(), fd.fd, timespec);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_FUTIMENS.value", "isDefault(dirFd)", "followSymlinks"})
        static PNone futimes(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.Timeval[] timeval = timespecNode.toTimeval(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", fd.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.futimes(context.getPosixSupport(), fd.fd, timeval);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"isPNone(times) || isNoValue(ns)", "!isDefault(dirFd)"})
        static PNone fdWithDirFd(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_DIRFD_WITHOUT_PATH, "utime");
        }

        @Specialization(guards={"isPNone(times) || isNoValue(ns)", "isDefault(dirFd)", "!followSymlinks"})
        static PNone fdWithFollowSymlinks(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "utime");
        }

        protected static boolean isDefault(int dirFd) {
            return dirFd == PosixConstants.AT_FDCWD.value;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    static abstract class UtimeArgsToTimespecNode
    extends Node {
        UtimeArgsToTimespecNode() {
        }

        abstract long[] execute(VirtualFrame var1, Object var2, Object var3);

        final PosixSupportLibrary.Timeval[] toTimeval(VirtualFrame frame, Object times, Object ns) {
            PosixSupportLibrary.Timeval[] timevalArray;
            long[] timespec = this.execute(frame, times, ns);
            if (timespec == null) {
                timevalArray = null;
            } else {
                PosixSupportLibrary.Timeval[] timevalArray2 = new PosixSupportLibrary.Timeval[2];
                timevalArray2[0] = new PosixSupportLibrary.Timeval(timespec[0], timespec[1] / 1000L);
                timevalArray = timevalArray2;
                timevalArray2[1] = new PosixSupportLibrary.Timeval(timespec[2], timespec[3] / 1000L);
            }
            return timevalArray;
        }

        @Specialization(guards={"isNoValue(ns)"})
        static long[] now(VirtualFrame frame, PNone times, PNone ns) {
            return null;
        }

        @Specialization(guards={"isNoValue(ns)"})
        static long[] times(VirtualFrame frame, PTuple times, PNone ns, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.LenNode lenNode, @Cached.Shared @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached ObjectToTimespecNode objectToTimespecNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return UtimeArgsToTimespecNode.convertToTimespec(frame, inliningTarget, times, lenNode, getItemNode, objectToTimespecNode, raiseNode);
        }

        @Specialization
        static long[] ns(VirtualFrame frame, PNone times, PTuple ns, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.LenNode lenNode, @Cached.Shared @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached SplitLongToSAndNsNode splitLongToSAndNsNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return UtimeArgsToTimespecNode.convertToTimespec(frame, inliningTarget, ns, lenNode, getItemNode, splitLongToSAndNsNode, raiseNode);
        }

        @Specialization(guards={"!isPNone(times)", "!isNoValue(ns)"})
        static long[] bothSpecified(VirtualFrame frame, Object times, Object ns, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.YOU_MAY_SPECIFY_EITHER_OR_BUT_NOT_BOTH, "utime", "times", "ns");
        }

        @Specialization(guards={"!isPNone(times)", "!isPTuple(times)", "isNoValue(ns)"})
        static long[] timesNotATuple(VirtualFrame frame, Object times, PNone ns, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            throw UtimeArgsToTimespecNode.timesTupleError(inliningTarget, raiseNode);
        }

        @Specialization(guards={"!isNoValue(ns)", "!isPTuple(ns)"})
        static long[] nsNotATuple(VirtualFrame frame, PNone times, Object ns, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE, "utime", "ns", "a tuple of two ints");
        }

        private static PException timesTupleError(Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE_EITHER_OR, "utime", "times", "a tuple of two ints", "None");
        }

        private static long[] convertToTimespec(VirtualFrame frame, Node inliningTarget, PTuple times, SequenceNodes.LenNode lenNode, SequenceStorageNodes.GetItemNode getItemNode, ConvertToTimespecBaseNode convertToTimespecBaseNode, PRaiseNode raiseNode) {
            if (lenNode.execute(inliningTarget, times) != 2) {
                throw UtimeArgsToTimespecNode.timesTupleError(inliningTarget, raiseNode);
            }
            long[] timespec = new long[4];
            convertToTimespecBaseNode.execute(frame, inliningTarget, getItemNode.execute(times.getSequenceStorage(), 0), timespec, 0);
            convertToTimespecBaseNode.execute(frame, inliningTarget, getItemNode.execute(times.getSequenceStorage(), 1), timespec, 2);
            return timespec;
        }
    }

    @Builtin(name="listdir", minNumOfPositionalArgs=0, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"true", "true"})
    @GenerateNodeFactory
    static abstract class ListdirNode
    extends PythonUnaryClinicBuiltinNode {
        ListdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ListdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PList listdirPath(VirtualFrame frame, PosixPath path, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.listdir", path.originalObject == null ? PNone.NONE : path.originalObject);
            try {
                return ListdirNode.listdir(frame, inliningTarget, posixLib.opendir(context.getPosixSupport(), path.value), path.wasBufferLike, false, posixLib, constructAndRaiseNode, context.getLanguage(inliningTarget), context.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization
        static PList listdirFd(VirtualFrame frame, PosixFd fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.listdir", fd.originalObject);
            Object dirStream = PosixModuleBuiltins.dupAndFdopendir(frame, inliningTarget, posixLib, context.getPosixSupport(), fd, constructAndRaiseNode);
            return ListdirNode.listdir(frame, inliningTarget, dirStream, false, true, posixLib, constructAndRaiseNode, context.getLanguage(inliningTarget), context.getPosixSupport());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static PList listdir(VirtualFrame frame, Node inliningTarget, Object dirStream, boolean produceBytes, boolean needsRewind, PosixSupportLibrary posixLib, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PythonLanguage language, PosixSupport posixSupport) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                while (true) {
                    Object dirEntry;
                    if ((dirEntry = posixLib.readdir(posixSupport, dirStream)) == null) {
                        PList pList = PFactory.createList(language, ListdirNode.listToArray(list));
                        return pList;
                    }
                    Object name = posixLib.dirEntryGetName(posixSupport, dirEntry);
                    if (produceBytes) {
                        ListdirNode.addToList(list, PosixModuleBuiltins.opaquePathToBytes(name, posixLib, posixSupport, language));
                        continue;
                    }
                    ListdirNode.addToList(list, posixLib.getPathAsString(posixSupport, name));
                    continue;
                    break;
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                if (needsRewind) {
                    posixLib.rewinddir(posixSupport, dirStream);
                }
                try {
                    posixLib.closedir(posixSupport, dirStream);
                }
                catch (PosixSupportLibrary.PosixException posixException) {}
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void addToList(List<Object> list, Object element) {
            list.add(element);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] listToArray(List<Object> list) {
            return list.toArray();
        }
    }

    @Builtin(name="scandir", minNumOfPositionalArgs=0, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"true", "true"})
    @GenerateNodeFactory
    static abstract class ScandirNode
    extends PythonUnaryClinicBuiltinNode {
        ScandirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ScandirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PScandirIterator scandirPath(VirtualFrame frame, PosixPath path, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.scandir", path.originalObject == null ? PNone.NONE : path.originalObject);
            try {
                return PFactory.createScandirIterator(context.getLanguage(inliningTarget), context, posixLib.opendir(context.getPosixSupport(), path.value), path, false);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization
        static PScandirIterator scandirFd(VirtualFrame frame, PosixFd fd, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.scandir", fd.originalObject);
            Object dirStream = PosixModuleBuiltins.dupAndFdopendir(frame, inliningTarget, posixLib, context.getPosixSupport(), fd, constructAndRaiseNode);
            return PFactory.createScandirIterator(context.getLanguage(inliningTarget), context, dirStream, fd, true);
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class IsattyNode
    extends PythonUnaryClinicBuiltinNode {
        IsattyNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.IsattyNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean isatty(int fd, @Cached GilNode gil, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            gil.release(true);
            try {
                boolean bl = posixLib.isatty(context.getPosixSupport(), fd);
                return bl;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="fchdir", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversionClass=FileDescriptorConversionNode.class)
    @GenerateNodeFactory
    static abstract class FchdirNode
    extends PythonUnaryClinicBuiltinNode {
        FchdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FchdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone fchdir(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            while (true) {
                try {
                    posixLib.fchdir(context.getPosixSupport(), fd);
                    return PNone.NONE;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="chdir", minNumOfPositionalArgs=1, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"})
    @GenerateNodeFactory
    static abstract class ChdirNode
    extends PythonUnaryClinicBuiltinNode {
        ChdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ChdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone chdirPath(VirtualFrame frame, PosixPath path, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.chdir(context.getPosixSupport(), path.value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        @Specialization
        static PNone chdirFd(VirtualFrame frame, PosixFd fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.fchdir(context.getPosixSupport(), fd.fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getcwdb", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetcwdbNode
    extends PythonBuiltinNode {
        GetcwdbNode() {
        }

        @Specialization
        static PBytes getcwdb(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                Object path = posixLib.getcwd(context.getPosixSupport());
                return PosixModuleBuiltins.opaquePathToBytes(path, posixLib, context.getPosixSupport(), context.getLanguage(inliningTarget));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getcwd", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetcwdNode
    extends PythonBuiltinNode {
        GetcwdNode() {
        }

        @Specialization
        static TruffleString getcwd(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getPathAsString(context.getPosixSupport(), posixLib.getcwd(context.getPosixSupport()));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="rmdir", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class RmdirNode
    extends PythonClinicBuiltinNode {
        RmdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.RmdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone rmdir(VirtualFrame frame, PosixPath path, int dirFd, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.rmdir", path.originalObject, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.unlinkat(context.getPosixSupport(), dirFd, path.value, true);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="mkdir", minNumOfPositionalArgs=1, parameterNames={"path", "mode"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0777"), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class MkdirNode
    extends PythonClinicBuiltinNode {
        MkdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.MkdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone mkdir(VirtualFrame frame, PosixPath path, int mode, int dirFd, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.mkdir", path.originalObject, mode, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.mkdirat(context.getPosixSupport(), dirFd, path.value, mode);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="symlink", minNumOfPositionalArgs=2, parameterNames={"src", "dst", "target_is_directory"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="target_is_directory", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class SymlinkNode
    extends PythonClinicBuiltinNode {
        SymlinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SymlinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone symlink(VirtualFrame frame, PosixPath src, PosixPath dst, boolean targetIsDir, int dirFd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.symlinkat(context.getPosixSupport(), src.value, dirFd, dst.value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, src.originalObject, dst.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="link", minNumOfPositionalArgs=2, parameterNames={"src", "dst"}, keywordOnlyNames={"src_dir_fd", "dst_dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="src_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="dst_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class LinkNode
    extends PythonClinicBuiltinNode {
        LinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone link(VirtualFrame frame, PosixPath src, PosixPath dst, int srcDirFd, int dstDirFd, boolean followSymlinks, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.linkat(context.getPosixSupport(), srcDirFd, src.value, dstDirFd, dst.value, followSymlinks ? PosixConstants.AT_SYMLINK_FOLLOW.value : 0);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, src.originalObject, dst.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class RemoveNode
    extends UnlinkNode {
        RemoveNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.RemoveNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="unlink", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class UnlinkNode
    extends PythonClinicBuiltinNode {
        UnlinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UnlinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone unlink(VirtualFrame frame, PosixPath path, int dirFd, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.remove", path.originalObject, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.unlinkat(context.getPosixSupport(), dirFd, path.value, false);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtins(value={@Builtin(name="uname", minNumOfPositionalArgs=0, os=PythonOS.PLATFORM_LINUX), @Builtin(name="uname", minNumOfPositionalArgs=0, os=PythonOS.PLATFORM_DARWIN)})
    @GenerateNodeFactory
    static abstract class UnameNode
    extends PythonBuiltinNode {
        UnameNode() {
        }

        @Specialization
        static PTuple uname(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return PFactory.createStructSeq(context.getLanguage(inliningTarget), UNAME_RESULT_DESC, posixLib.uname(context.getPosixSupport()));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="fstatvfs", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class FStatvfsNode
    extends PythonUnaryClinicBuiltinNode {
        FStatvfsNode() {
        }

        @Specialization
        static PTuple doStatvfs(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile positiveLongProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long[] out;
            try {
                out = posixLib.fstatvfs(context.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd);
            }
            return PosixModuleBuiltins.createStatvfsResult(inliningTarget, out, positiveLongProfile, context.getLanguage(inliningTarget));
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FStatvfsNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="statvfs", minNumOfPositionalArgs=1, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"})
    @GenerateNodeFactory
    static abstract class StatvfsNode
    extends PythonUnaryClinicBuiltinNode {
        StatvfsNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.StatvfsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTuple doStatvfs(VirtualFrame frame, PosixFileHandle posixFileHandle, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile posixPathProfile, @Cached InlinedConditionProfile positiveLongProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long[] out;
            try {
                out = posixPathProfile.profile(inliningTarget, posixFileHandle instanceof PosixPath) ? posixLib.statvfs(context.getPosixSupport(), ((PosixPath)posixFileHandle).value) : posixLib.fstatvfs(context.getPosixSupport(), ((PosixFd)posixFileHandle).fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, posixFileHandle.originalObject);
            }
            return PosixModuleBuiltins.createStatvfsResult(inliningTarget, out, positiveLongProfile, context.getLanguage(inliningTarget));
        }
    }

    @Builtin(name="fstat", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class FStatNode
    extends PythonUnaryClinicBuiltinNode {
        FStatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FStatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTuple doStatFd(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile positiveLongProfile, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            while (true) {
                try {
                    long[] out = posixLib.fstat(context.getPosixSupport(), fd);
                    return PosixModuleBuiltins.createStatResult(inliningTarget, context.getLanguage(inliningTarget), positiveLongProfile, out);
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="lstat", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class LStatNode
    extends PythonClinicBuiltinNode {
        LStatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LStatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTuple doStatPath(VirtualFrame frame, PosixPath path, int dirFd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile positiveLongProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                long[] out = posixLib.fstatat(context.getPosixSupport(), dirFd, path.value, false);
                return PosixModuleBuiltins.createStatResult(inliningTarget, context.getLanguage(inliningTarget), positiveLongProfile, out);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }
    }

    @Builtin(name="stat", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class StatNode
    extends PythonClinicBuiltinNode {
        StatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.StatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTuple doStatPath(VirtualFrame frame, PosixPath path, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared(value="positive") @Cached InlinedConditionProfile positiveLongProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                long[] out = posixLib.fstatat(context.getPosixSupport(), dirFd, path.value, followSymlinks);
                return PosixModuleBuiltins.createStatResult(inliningTarget, context.getLanguage(inliningTarget), positiveLongProfile, out);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization(guards={"!isDefault(dirFd)"})
        static PTuple doStatFdWithDirFd(PosixFd fd, int dirFd, boolean followSymlinks, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_DIRFD_WITHOUT_PATH, "stat");
        }

        @Specialization(guards={"isDefault(dirFd)", "!followSymlinks"})
        static PTuple doStatFdWithFollowSymlinks(VirtualFrame frame, PosixFd fd, int dirFd, boolean followSymlinks, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "stat");
        }

        @Specialization(guards={"isDefault(dirFd)", "followSymlinks"})
        static PTuple doStatFd(VirtualFrame frame, PosixFd fd, int dirFd, boolean followSymlinks, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared(value="positive") @Cached InlinedConditionProfile positiveLongProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                long[] out = posixLib.fstat(context.getPosixSupport(), fd.fd);
                return PosixModuleBuiltins.createStatResult(inliningTarget, context.getLanguage(inliningTarget), positiveLongProfile, out);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
        }

        protected static boolean isDefault(int dirFd) {
            return dirFd == PosixConstants.AT_FDCWD.value;
        }
    }

    @Builtin(name="get_terminal_size", minNumOfPositionalArgs=0, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1")
    @GenerateNodeFactory
    static abstract class GetTerminalSizeNode
    extends PythonUnaryClinicBuiltinNode {
        GetTerminalSizeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetTerminalSizeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTuple getTerminalSize(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                int[] result = posixLib.getTerminalSize(context.getPosixSupport(), fd);
                return PFactory.createStructSeq(context.getLanguage(inliningTarget), TERMINAL_SIZE_DESC, result[0], result[1]);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="set_blocking", minNumOfPositionalArgs=2, parameterNames={"fd", "blocking"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="blocking", conversion=ArgumentClinic.ClinicConversion.IntToBoolean)})
    @GenerateNodeFactory
    static abstract class SetBlockingNode
    extends PythonBinaryClinicBuiltinNode {
        SetBlockingNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SetBlockingNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone setBlocking(VirtualFrame frame, int fd, boolean blocking, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setBlocking(context.getPosixSupport(), fd, blocking);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="get_blocking", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class GetBlockingNode
    extends PythonUnaryClinicBuiltinNode {
        GetBlockingNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetBlockingNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean getBlocking(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getBlocking(context.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="fsync", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversionClass=FileDescriptorConversionNode.class)
    @GenerateNodeFactory
    static abstract class FSyncNode
    extends PythonUnaryClinicBuiltinNode {
        FSyncNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FSyncNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone fsync(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            while (true) {
                try {
                    posixLib.fsync(context.getPosixSupport(), fd);
                    return PNone.NONE;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=2, parameterNames={"path", "length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="length", conversionClass=OffsetConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class TruncateNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.TruncateNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PNone truncate(VirtualFrame frame, PosixPath path, long length, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.truncate", path.originalObject, length);
            try {
                gil.release(true);
                try {
                    posixLib.truncate(context.getPosixSupport(), path.value, length);
                }
                finally {
                    gil.acquire();
                }
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization
        static PNone ftruncate(VirtualFrame frame, PosixFd fd, long length, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached InlinedBranchProfile errorProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            return FtruncateNode.ftruncate(frame, fd.fd, length, inliningTarget, context, posixLib, auditNode, gil, errorProfile, constructAndRaiseNode);
        }
    }

    @Builtin(name="ftruncate", minNumOfPositionalArgs=2, parameterNames={"fd", "length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="length", conversionClass=OffsetConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class FtruncateNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FtruncateNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PNone ftruncate(VirtualFrame frame, int fd, long length, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.truncate", fd, length);
            while (true) {
                try {
                    gil.release(true);
                    try {
                        posixLib.ftruncate(context.getPosixSupport(), fd, length);
                    }
                    finally {
                        gil.acquire();
                    }
                    return PNone.NONE;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="lseek", minNumOfPositionalArgs=3, parameterNames={"fd", "pos", "how"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="pos", conversionClass=OffsetConversionNode.class), @ArgumentClinic(name="how", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    public static abstract class LseekNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LseekNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static long lseek(VirtualFrame frame, int fd, long pos, int how, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.lseek(context.getPosixSupport(), fd, pos, PosixModuleBuiltins.mapPythonSeekWhenceToPosix(how));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="pipe", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class PipeNode
    extends PythonBuiltinNode {
        PipeNode() {
        }

        @Specialization
        static PTuple pipe(VirtualFrame frame, @Bind Node inliningTarget, @Cached GilNode gil, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int[] pipe;
            gil.release(true);
            try {
                pipe = posixLib.pipe(context.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                gil.acquire();
            }
            return PFactory.createTuple(context.getLanguage(inliningTarget), new Object[]{pipe[0], pipe[1]});
        }
    }

    @Builtin(name="set_inheritable", minNumOfPositionalArgs=2, parameterNames={"fd", "inheritable"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="inheritable", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class SetInheritableNode
    extends PythonBinaryClinicBuiltinNode {
        SetInheritableNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SetInheritableNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone setInheritable(VirtualFrame frame, int fd, int inheritable, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setInheritable(context.getPosixSupport(), fd, inheritable != 0);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="get_inheritable", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class GetInheritableNode
    extends PythonUnaryClinicBuiltinNode {
        GetInheritableNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetInheritableNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean getInheritable(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getInheritable(context.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="dup2", minNumOfPositionalArgs=2, parameterNames={"fd", "fd2", "inheritable"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="fd2", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="inheritable", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class Dup2Node
    extends PythonTernaryClinicBuiltinNode {
        Dup2Node() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.Dup2NodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int dup2(VirtualFrame frame, int fd, int fd2, boolean inheritable, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            if (fd < 0 || fd2 < 0) {
                int error = OSErrorEnum.EINVAL.getNumber();
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, error, posixLib.strerror(context.getPosixSupport(), error));
            }
            try {
                return posixLib.dup2(context.getPosixSupport(), fd, fd2, inheritable);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="dup", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class DupNode
    extends PythonUnaryClinicBuiltinNode {
        DupNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.DupNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int dup(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.dup(context.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2, parameterNames={"fd", "data"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)})
    @GenerateNodeFactory
    public static abstract class WriteNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(limit="3")
        static long doWrite(VirtualFrame frame, int fd, Object dataBuffer, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="dataBuffer") PythonBufferAccessLibrary bufferLib, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                long l = WriteNode.write(fd, bufferLib.getInternalOrCopiedByteArray(dataBuffer), bufferLib.getBufferLength(dataBuffer), inliningTarget, posixLib, context.getPosixSupport(), errorProfile, gil);
                return l;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                bufferLib.release(dataBuffer, frame, indirectCallData);
            }
        }

        public static long write(int fd, byte[] dataBytes, int dataLen, Node inliningTarget, PosixSupportLibrary posixLib, PosixSupport posixSupport, InlinedBranchProfile errorProfile, GilNode gil) throws PosixSupportLibrary.PosixException {
            gil.release(true);
            while (true) {
                try {
                    long l = posixLib.write(posixSupport, fd, new PosixSupportLibrary.Buffer(dataBytes, dataLen));
                    return l;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=2, parameterNames={"fd", "length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    public static abstract class ReadNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PBytes doRead(VirtualFrame frame, int fd, int length, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile1, @Cached InlinedBranchProfile errorProfile2, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            if (length < 0) {
                int error = OSErrorEnum.EINVAL.getNumber();
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, error, posixLib.strerror(context.getPosixSupport(), error));
            }
            try {
                return ReadNode.read(fd, length, inliningTarget, posixLib, context.getPosixSupport(), errorProfile1, gil);
            }
            catch (PosixSupportLibrary.PosixException e) {
                errorProfile2.enter(inliningTarget);
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        public static PBytes read(int fd, int length, Node inliningTarget, PosixSupportLibrary posixLib, PosixSupport posixSupport, InlinedBranchProfile errorProfile, GilNode gil) throws PosixSupportLibrary.PosixException {
            gil.release(true);
            while (true) {
                try {
                    PosixSupportLibrary.Buffer result = posixLib.read(posixSupport, fd, length);
                    if (result.length > Integer.MAX_VALUE) {
                        throw CompilerDirectives.shouldNotReachHere((String)"Posix read() returned more bytes than requested");
                    }
                    PBytes pBytes = PFactory.createBytes(PythonLanguage.get(inliningTarget), result.data, (int)result.length);
                    return pBytes;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class CloseNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.CloseNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PNone close(VirtualFrame frame, int fd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                if (context.getSharedMultiprocessingData().decrementFDRefCount(fd)) {
                    return PNone.NONE;
                }
                gil.release(true);
                try {
                    posixLib.close(context.getPosixSupport(), fd);
                }
                finally {
                    gil.acquire();
                }
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="open", numOfPositionalOnlyArgs=0, minNumOfPositionalArgs=2, parameterNames={"path", "flags", "mode"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0777"), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class OpenNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.OpenNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int open(VirtualFrame frame, PosixPath path, int flags, int mode, int dirFd, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached InlinedBranchProfile errorProfile, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int fixedFlags = flags;
            if (PosixConstants.O_CLOEXEC.defined) {
                fixedFlags |= PosixConstants.O_CLOEXEC.getValueIfDefined();
            }
            auditNode.audit(inliningTarget, "open", path.originalObject, PNone.NONE, fixedFlags);
            gil.release(true);
            while (true) {
                try {
                    int n = posixLib.openat(context.getPosixSupport(), dirFd, path.value, fixedFlags, mode);
                    return n;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="openpty")
    @GenerateNodeFactory
    public static abstract class OpenPtyNode
    extends PythonBuiltinNode {
        @Specialization
        static Object openpty(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                PosixSupportLibrary.OpenPtyResult result = posixLib.openpty(context.getPosixSupport());
                posixLib.setInheritable(context.getPosixSupport(), result.masterFd(), false);
                posixLib.setInheritable(context.getPosixSupport(), result.slaveFd(), false);
                return PFactory.createTuple(context.getLanguage(inliningTarget), new int[]{result.masterFd(), result.slaveFd()});
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getgroups")
    @GenerateNodeFactory
    static abstract class GetGroupsNode
    extends PythonBuiltinNode {
        GetGroupsNode() {
        }

        @Specialization
        static Object getgroups(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                long[] groups = posixLib.getgroups(context.getPosixSupport());
                return PFactory.createList(context.getLanguage(inliningTarget), new LongSequenceStorage(groups));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="setsid")
    @GenerateNodeFactory
    public static abstract class SetSidNode
    extends PythonBuiltinNode {
        @Specialization
        static Object setsid(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setsid(context.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getsid", minNumOfPositionalArgs=1, parameterNames={"pid"})
    @ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class)
    @GenerateNodeFactory
    public static abstract class GetSidNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetSidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static long getSid(VirtualFrame frame, long pid, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getsid(context.getPosixSupport(), pid);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getpgrp", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetPgrpNode
    extends PythonBuiltinNode {
        @Specialization
        static long getPpid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getpgrp(context.getPosixSupport());
        }
    }

    @Builtin(name="setpgrp", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class SetPgrpdNode
    extends PythonBuiltinNode {
        @Specialization
        static Object getPpid(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setpgid(context.getPosixSupport(), 0L, 0L);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="setpgid", minNumOfPositionalArgs=2, parameterNames={"pid", "pgid"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="pgid", conversionClass=PidtConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class SetPgidNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SetPgidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object setPgid(VirtualFrame frame, long pid, long pgid, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setpgid(context.getPosixSupport(), pid, pgid);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getpgid", minNumOfPositionalArgs=1, parameterNames={"pid"})
    @ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class)
    @GenerateNodeFactory
    public static abstract class GetPgidNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetPgidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static long getPgid(VirtualFrame frame, long pid, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getpgid(context.getPosixSupport(), pid);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getloadavg", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetLoadAvgNode
    extends PythonBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        static PTuple getloadavg(@Bind Node inliningTarget, @Bind PythonLanguage language) {
            double load = -1.0;
            if (ManagementFactory.getOperatingSystemMXBean() != null) {
                load = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            }
            if (load < 0.0) {
                PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.OSError);
            }
            return PFactory.createTuple(language, new Object[]{load, load, load});
        }
    }

    @Builtin(name="getppid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetPpidNode
    extends PythonBuiltinNode {
        @Specialization
        static long getPpid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getppid(context.getPosixSupport());
        }
    }

    @Builtin(name="getegid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetEGidNode
    extends PythonBuiltinNode {
        @Specialization
        static long getGid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getegid(context.getPosixSupport());
        }
    }

    @Builtin(name="getgid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetGidNode
    extends PythonBuiltinNode {
        @Specialization
        static long getGid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getgid(context.getPosixSupport());
        }
    }

    @Builtin(name="geteuid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetEUidNode
    extends PythonBuiltinNode {
        @Specialization
        static long getUid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.geteuid(context.getPosixSupport());
        }
    }

    @Builtin(name="getuid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetUidNode
    extends PythonBuiltinNode {
        @Specialization
        static long getUid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getuid(context.getPosixSupport());
        }
    }

    @Builtin(name="getpid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetPidNode
    extends PythonBuiltinNode {
        @Specialization
        static long getPid(@Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getpid(context.getPosixSupport());
        }
    }

    @Builtin(name="execv", minNumOfPositionalArgs=2, parameterNames={"pathname", "argv"})
    @ArgumentClinic(name="pathname", conversionClass=PathConversionNode.class, args={"false", "false"})
    @GenerateNodeFactory
    public static abstract class ExecvNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ExecvNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object execvArgsList(VirtualFrame frame, PosixPath path, PList argv, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached.Shared @Cached ObjectToOpaquePathNode toOpaquePathNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            ExecvNode.execv(frame, path, argv, argv.getSequenceStorage(), inliningTarget, posixLib, context.getPosixSupport(), toArrayNode, toOpaquePathNode, auditNode, gil, constructAndRaiseNode, raiseNode);
            throw CompilerDirectives.shouldNotReachHere((String)"execv should not return normally");
        }

        @Specialization
        static Object execvArgsTuple(VirtualFrame frame, PosixPath path, PTuple argv, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Shared @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached.Shared @Cached ObjectToOpaquePathNode toOpaquePathNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            ExecvNode.execv(frame, path, argv, argv.getSequenceStorage(), inliningTarget, posixLib, context.getPosixSupport(), toArrayNode, toOpaquePathNode, auditNode, gil, constructAndRaiseNode, raiseNode);
            throw CompilerDirectives.shouldNotReachHere((String)"execv should not return normally");
        }

        @Specialization(guards={"!isList(argv)", "!isPTuple(argv)"})
        static Object execvInvalidArgs(VirtualFrame frame, PosixPath path, Object argv, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S, "execv()", 2, "tuple or list");
        }

        private static void execv(VirtualFrame frame, PosixPath path, Object argv, SequenceStorage argvStorage, Node inliningTarget, PosixSupportLibrary posixLib, PosixSupport posixSupport, SequenceStorageNodes.ToArrayNode toArrayNode, ObjectToOpaquePathNode toOpaquePathNode, SysModuleBuiltins.AuditNode auditNode, GilNode gil, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PRaiseNode raiseNode) {
            Object[] args = toArrayNode.execute(inliningTarget, argvStorage);
            if (args.length < 1) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ARG_MUST_NOT_BE_EMPTY, "execv()", 2);
            }
            Object[] opaqueArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                opaqueArgs[i] = toOpaquePathNode.execute(frame, inliningTarget, args[i], i == 0);
            }
            auditNode.audit(inliningTarget, "os.exec", path.originalObject, argv, PNone.NONE);
            gil.release(true);
            try {
                posixLib.execv(posixSupport, path.value, opaqueArgs);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                gil.acquire();
            }
            throw CompilerDirectives.shouldNotReachHere((String)"execv should not return normally");
        }
    }

    @Builtin(name="unsetenv", minNumOfPositionalArgs=1, parameterNames={"name"})
    @ArgumentClinic(name="name", conversionClass=FsConverterNode.class)
    @GenerateNodeFactory
    public static abstract class UnsetenvNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UnsetenvNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone putenv(VirtualFrame frame, PBytes nameBytes, @Bind Node inliningTarget, @Bind PythonContext context, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            byte[] name = toBytesNode.execute(nameBytes);
            Object nameOpaque = UnsetenvNode.checkNull(inliningTarget, posixLib.createPathFromBytes(context.getPosixSupport(), name), raiseNode);
            auditNode.audit(inliningTarget, "os.unsetenv", nameBytes);
            try {
                posixLib.unsetenv(context.getPosixSupport(), nameOpaque);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        private static Object checkNull(Node inliningTarget, Object value, PRaiseNode raiseNode) {
            if (value == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return value;
        }
    }

    @Builtin(name="putenv", minNumOfPositionalArgs=2, parameterNames={"name", "value"})
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversionClass=FsConverterNode.class), @ArgumentClinic(name="value", conversionClass=FsConverterNode.class)})
    @GenerateNodeFactory
    public static abstract class PutenvNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.PutenvNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone putenv(VirtualFrame frame, PBytes nameBytes, PBytes valueBytes, @Bind Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            byte[] name = toBytesNode.execute(nameBytes);
            byte[] value = toBytesNode.execute(valueBytes);
            PosixSupport posixSupport = context.getPosixSupport();
            Object nameOpaque = PutenvNode.checkNull(inliningTarget, posixLib.createPathFromBytes(posixSupport, name), raiseNode);
            Object valueOpaque = PutenvNode.checkNull(inliningTarget, posixLib.createPathFromBytes(posixSupport, value), raiseNode);
            PutenvNode.checkEqualSign(inliningTarget, name, raiseNode);
            auditNode.audit(inliningTarget, "os.putenv", nameBytes, valueBytes);
            try {
                posixLib.setenv(posixSupport, nameOpaque, valueOpaque, true);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        private static Object checkNull(Node inliningTarget, Object value, PRaiseNode raiseNode) {
            if (value == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return value;
        }

        private static void checkEqualSign(Node inliningTarget, byte[] bytes, PRaiseNode raiseNode) {
            for (byte b : bytes) {
                if (b != 61) continue;
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ILLEGAL_ENVIRONMENT_VARIABLE_NAME);
            }
        }
    }
}

