/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.charset.PythonRawUnicodeEscapeCharset;
import com.oracle.graal.python.charset.PythonUTF32CharsetWrapper;
import com.oracle.graal.python.charset.PythonUnicodeEscapeCharset;
import com.oracle.graal.python.util.CharsetMappingFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.shadowed.com.ibm.icu.charset.CharsetICU;

public class CharsetMapping {
    private static final Charset UTF_32LE = new PythonUTF32CharsetWrapper(Charset.forName("UTF-32LE"), ByteOrder.LITTLE_ENDIAN);
    private static final Charset UTF_32LE_BOM = new PythonUTF32CharsetWrapper(Charset.forName("UTF-32LE-BOM"), ByteOrder.LITTLE_ENDIAN);
    private static final Charset UTF_32BE = new PythonUTF32CharsetWrapper(Charset.forName("UTF-32BE"), ByteOrder.BIG_ENDIAN);
    private static final Charset UTF_32BE_BOM = new PythonUTF32CharsetWrapper(Charset.forName("UTF-32BE-BOM"), ByteOrder.BIG_ENDIAN);
    private static final ConcurrentMap<String, Charset> JAVA_CHARSETS = new ConcurrentHashMap<String, Charset>();
    private static final Map<TruffleString, String> CHARSET_NAME_MAP = new HashMap<TruffleString, String>();
    private static final Map<String, TruffleString> CHARSET_NAME_MAP_REVERSE = new HashMap<String, TruffleString>();
    private static final TruffleString T_UTF_16_UNDERSCORE = PythonUtils.tsLiteral("utf_16");
    private static final TruffleString T_UTF_32_UNDERSCORE = PythonUtils.tsLiteral("utf_32");

    @CompilerDirectives.TruffleBoundary
    public static Charset getCharsetNormalized(TruffleString normalizedEncoding) {
        String name = CHARSET_NAME_MAP.get(normalizedEncoding);
        if (name != null) {
            return CharsetMapping.getJavaCharset(name);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset getCharsetForDecodingNormalized(TruffleString normalizedEncoding, byte[] bytes, int len) {
        String name;
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            Charset charset;
            if (T_UTF_16_UNDERSCORE.equalsUncached((AbstractTruffleString)normalizedEncoding, PythonUtils.TS_ENCODING) && CharsetMapping.hasUTF16BOM(bytes, len)) {
                return StandardCharsets.UTF_16;
            }
            if (T_UTF_32_UNDERSCORE.equalsUncached((AbstractTruffleString)normalizedEncoding, PythonUtils.TS_ENCODING) && (charset = CharsetMapping.getUTF32CharsetForBOM(bytes, len)) != null) {
                return charset;
            }
        }
        if ((name = CHARSET_NAME_MAP.get(normalizedEncoding)) != null) {
            return CharsetMapping.getJavaCharset(name);
        }
        return null;
    }

    private static boolean hasUTF16BOM(byte[] bytes, int len) {
        if (len < 2) {
            return false;
        }
        short head = PythonUtils.ARRAY_ACCESSOR.getShort(bytes, 0);
        return head == -2 || head == -257;
    }

    private static Charset getUTF32CharsetForBOM(byte[] bytes, int len) {
        if (len < 4) {
            return null;
        }
        int head = PythonUtils.ARRAY_ACCESSOR.getInt(bytes, 0);
        if (head == -131072) {
            return UTF_32BE_BOM;
        }
        if (head == 65279) {
            return UTF_32LE_BOM;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString getPythonEncodingNameFromJavaName(String javaEncodingName) {
        return CHARSET_NAME_MAP_REVERSE.get(javaEncodingName.toLowerCase());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString normalizeUncached(TruffleString encoding) {
        return CharsetMappingFactory.NormalizeEncodingNameNodeGen.getUncached().execute(null, encoding);
    }

    public static Charset getJavaCharset(String name) {
        return JAVA_CHARSETS.computeIfAbsent(name, key -> {
            if (name.equals("UTF-7") || name.equals("HZ")) {
                try {
                    return CharsetICU.forNameICU((String)name);
                }
                catch (UnsupportedCharsetException e) {
                    return null;
                }
            }
            try {
                return Charset.forName(name);
            }
            catch (UnsupportedCharsetException e) {
                return null;
            }
        });
    }

    private static void addMapping(String pythonName, String javaName) {
        TruffleString normalized = CharsetMapping.normalizeUncached(PythonUtils.toTruffleStringUncached(pythonName));
        CHARSET_NAME_MAP.put(normalized, javaName);
        if (javaName != null) {
            CHARSET_NAME_MAP_REVERSE.put(javaName.toLowerCase(), PythonUtils.toTruffleStringUncached(pythonName.replace('_', '-')));
        }
    }

    private static void addAlias(String alias, String pythonName) {
        TruffleString normalized = CharsetMapping.normalizeUncached(PythonUtils.toTruffleStringUncached(pythonName));
        assert (CHARSET_NAME_MAP.containsKey(normalized)) : normalized;
        CHARSET_NAME_MAP.put(CharsetMapping.normalizeUncached(PythonUtils.toTruffleStringUncached(alias)), CHARSET_NAME_MAP.get(normalized));
    }

    static {
        JAVA_CHARSETS.put("US-ASCII", StandardCharsets.US_ASCII);
        JAVA_CHARSETS.put("ISO-8859-1", StandardCharsets.ISO_8859_1);
        JAVA_CHARSETS.put("UTF-8", StandardCharsets.UTF_8);
        JAVA_CHARSETS.put("UTF-16BE", StandardCharsets.UTF_16BE);
        JAVA_CHARSETS.put("UTF-16LE", StandardCharsets.UTF_16LE);
        JAVA_CHARSETS.put("UTF-16", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? Charset.forName("UnicodeLittle") : StandardCharsets.UTF_16);
        JAVA_CHARSETS.put("UTF-32BE", UTF_32BE);
        JAVA_CHARSETS.put("UTF-32LE", UTF_32LE);
        JAVA_CHARSETS.put("UTF-32", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? UTF_32LE_BOM : UTF_32BE_BOM);
        CharsetMapping.addMapping("raw_unicode_escape", "x-python-raw-unicode-escape");
        CharsetMapping.addMapping("unicode-escape", "x-python-unicode-escape");
        CharsetMapping.addMapping("unicodeescape", "x-python-unicode-escape");
        JAVA_CHARSETS.put("x-python-raw-unicode-escape", new PythonRawUnicodeEscapeCharset());
        JAVA_CHARSETS.put("x-python-unicode-escape", new PythonUnicodeEscapeCharset());
        CharsetMapping.addMapping("ascii", "US-ASCII");
        CharsetMapping.addMapping("big5hkscs", "Big5-HKSCS");
        CharsetMapping.addMapping("big5", "Big5");
        CharsetMapping.addMapping("cp037", "IBM037");
        CharsetMapping.addMapping("cp1006", "x-IBM1006");
        CharsetMapping.addMapping("cp1026", "IBM1026");
        CharsetMapping.addMapping("cp1125", null);
        CharsetMapping.addMapping("cp1140", "IBM01140");
        CharsetMapping.addMapping("cp1250", "windows-1250");
        CharsetMapping.addMapping("cp1251", "windows-1251");
        CharsetMapping.addMapping("cp1252", "windows-1252");
        CharsetMapping.addMapping("cp1253", "windows-1253");
        CharsetMapping.addMapping("cp1254", "windows-1254");
        CharsetMapping.addMapping("cp1255", "windows-1255");
        CharsetMapping.addMapping("cp1256", "windows-1256");
        CharsetMapping.addMapping("cp1257", "windows-1257");
        CharsetMapping.addMapping("cp1258", "windows-1258");
        CharsetMapping.addMapping("cp273", "IBM273");
        CharsetMapping.addMapping("cp424", "IBM424");
        CharsetMapping.addMapping("cp437", "IBM437");
        CharsetMapping.addMapping("cp500", "IBM500");
        CharsetMapping.addMapping("cp720", null);
        CharsetMapping.addMapping("cp737", "x-IBM737");
        CharsetMapping.addMapping("cp775", "IBM775");
        CharsetMapping.addMapping("cp850", "IBM850");
        CharsetMapping.addMapping("cp852", "IBM852");
        CharsetMapping.addMapping("cp855", "IBM855");
        CharsetMapping.addMapping("cp856", "x-IBM856");
        CharsetMapping.addMapping("cp857", "IBM857");
        CharsetMapping.addMapping("cp858", "IBM00858");
        CharsetMapping.addMapping("cp860", "IBM860");
        CharsetMapping.addMapping("cp861", "IBM861");
        CharsetMapping.addMapping("cp862", "IBM862");
        CharsetMapping.addMapping("cp863", "IBM863");
        CharsetMapping.addMapping("cp864", "IBM864");
        CharsetMapping.addMapping("cp865", "IBM865");
        CharsetMapping.addMapping("cp866", "IBM866");
        CharsetMapping.addMapping("cp869", "IBM869");
        CharsetMapping.addMapping("cp874", "x-IBM874");
        CharsetMapping.addMapping("cp875", "x-IBM875");
        CharsetMapping.addMapping("cp932", "windows-31j");
        CharsetMapping.addMapping("cp949", "x-windows-949");
        CharsetMapping.addMapping("cp950", "x-IBM950");
        CharsetMapping.addMapping("euc_jis_2004", null);
        CharsetMapping.addMapping("euc_jisx0213", null);
        CharsetMapping.addMapping("euc_jp", "EUC-JP");
        CharsetMapping.addMapping("euc_kr", "EUC-KR");
        CharsetMapping.addMapping("gb18030", "GB18030");
        CharsetMapping.addMapping("gb2312", "GB2312");
        CharsetMapping.addMapping("gbk", "GBK");
        CharsetMapping.addMapping("hp_roman8", null);
        CharsetMapping.addMapping("hz", "HZ");
        CharsetMapping.addMapping("iso2022_jp_1", null);
        CharsetMapping.addMapping("iso2022_jp_2004", null);
        CharsetMapping.addMapping("iso2022_jp_2", "ISO-2022-JP-2");
        CharsetMapping.addMapping("iso2022_jp_3", null);
        CharsetMapping.addMapping("iso2022_jp_ext", null);
        CharsetMapping.addMapping("iso2022_jp", "ISO-2022-JP");
        CharsetMapping.addMapping("iso2022_kr", "ISO-2022-KR");
        CharsetMapping.addMapping("iso8859_10", null);
        CharsetMapping.addMapping("iso8859_11", "x-iso-8859-11");
        CharsetMapping.addMapping("iso8859_13", "ISO-8859-13");
        CharsetMapping.addMapping("iso8859_14", null);
        CharsetMapping.addMapping("iso8859_15", "ISO-8859-15");
        CharsetMapping.addMapping("iso8859_16", null);
        CharsetMapping.addMapping("iso8859_1", "ISO-8859-1");
        CharsetMapping.addMapping("iso8859_2", "ISO-8859-2");
        CharsetMapping.addMapping("iso8859_3", "ISO-8859-3");
        CharsetMapping.addMapping("iso8859_4", "ISO-8859-4");
        CharsetMapping.addMapping("iso8859_5", "ISO-8859-5");
        CharsetMapping.addMapping("iso8859_6", "ISO-8859-6");
        CharsetMapping.addMapping("iso8859_7", "ISO-8859-7");
        CharsetMapping.addMapping("iso8859_8", "ISO-8859-8");
        CharsetMapping.addMapping("iso8859_9", "ISO-8859-9");
        CharsetMapping.addMapping("johab", "x-Johab");
        CharsetMapping.addMapping("koi8_r", "KOI8-R");
        CharsetMapping.addMapping("koi8_t", null);
        CharsetMapping.addMapping("koi8_u", "KOI8-U");
        CharsetMapping.addMapping("kz1048", null);
        CharsetMapping.addMapping("latin_1", "ISO-8859-1");
        CharsetMapping.addMapping("mac_arabic", "x-MacArabic");
        CharsetMapping.addMapping("mac_centeuro", "x-MacCentralEurope");
        CharsetMapping.addMapping("mac_croatian", "x-MacCroatian");
        CharsetMapping.addMapping("mac_cyrillic", "x-MacCyrillic");
        CharsetMapping.addMapping("mac_farsi", null);
        CharsetMapping.addMapping("mac_greek", "x-MacGreek");
        CharsetMapping.addMapping("mac_iceland", "x-MacIceland");
        CharsetMapping.addMapping("mac_latin2", "x-MacCentralEurope");
        CharsetMapping.addMapping("mac_romanian", "x-MacRomania");
        CharsetMapping.addMapping("mac_roman", "x-MacRoman");
        CharsetMapping.addMapping("mac_turkish", "x-MacTurkish");
        CharsetMapping.addMapping("palmos", null);
        CharsetMapping.addMapping("ptcp154", null);
        CharsetMapping.addMapping("shift_jis_2004", "Shift_JISX0213");
        CharsetMapping.addMapping("shift_jis", "Shift_JIS");
        CharsetMapping.addMapping("shift_jisx0213", "x-SJIS_0213");
        CharsetMapping.addMapping("utf_16_be", "UTF-16BE");
        CharsetMapping.addMapping("utf_16_le", "UTF-16LE");
        CharsetMapping.addMapping("utf_16", "UTF-16");
        CharsetMapping.addMapping("utf_32_be", "UTF-32BE");
        CharsetMapping.addMapping("utf_32_le", "UTF-32LE");
        CharsetMapping.addMapping("utf_32", "UTF-32");
        CharsetMapping.addMapping("utf_7", "UTF-7");
        CharsetMapping.addMapping("utf_8", "UTF-8");
        CharsetMapping.addAlias("646", "ascii");
        CharsetMapping.addAlias("ansi_x3.4_1968", "ascii");
        CharsetMapping.addAlias("ansi_x3_4_1968", "ascii");
        CharsetMapping.addAlias("ansi_x3.4_1986", "ascii");
        CharsetMapping.addAlias("cp367", "ascii");
        CharsetMapping.addAlias("csascii", "ascii");
        CharsetMapping.addAlias("ibm367", "ascii");
        CharsetMapping.addAlias("iso646_us", "ascii");
        CharsetMapping.addAlias("iso_646.irv_1991", "ascii");
        CharsetMapping.addAlias("iso_ir_6", "ascii");
        CharsetMapping.addAlias("us", "ascii");
        CharsetMapping.addAlias("us_ascii", "ascii");
        CharsetMapping.addAlias("big5_tw", "big5");
        CharsetMapping.addAlias("csbig5", "big5");
        CharsetMapping.addAlias("big5_hkscs", "big5hkscs");
        CharsetMapping.addAlias("hkscs", "big5hkscs");
        CharsetMapping.addAlias("037", "cp037");
        CharsetMapping.addAlias("csibm037", "cp037");
        CharsetMapping.addAlias("ebcdic_cp_ca", "cp037");
        CharsetMapping.addAlias("ebcdic_cp_nl", "cp037");
        CharsetMapping.addAlias("ebcdic_cp_us", "cp037");
        CharsetMapping.addAlias("ebcdic_cp_wt", "cp037");
        CharsetMapping.addAlias("ibm037", "cp037");
        CharsetMapping.addAlias("ibm039", "cp037");
        CharsetMapping.addAlias("1026", "cp1026");
        CharsetMapping.addAlias("csibm1026", "cp1026");
        CharsetMapping.addAlias("ibm1026", "cp1026");
        CharsetMapping.addAlias("1125", "cp1125");
        CharsetMapping.addAlias("ibm1125", "cp1125");
        CharsetMapping.addAlias("cp866u", "cp1125");
        CharsetMapping.addAlias("ruscii", "cp1125");
        CharsetMapping.addAlias("1140", "cp1140");
        CharsetMapping.addAlias("ibm1140", "cp1140");
        CharsetMapping.addAlias("1250", "cp1250");
        CharsetMapping.addAlias("windows_1250", "cp1250");
        CharsetMapping.addAlias("1251", "cp1251");
        CharsetMapping.addAlias("windows_1251", "cp1251");
        CharsetMapping.addAlias("1252", "cp1252");
        CharsetMapping.addAlias("windows_1252", "cp1252");
        CharsetMapping.addAlias("1253", "cp1253");
        CharsetMapping.addAlias("windows_1253", "cp1253");
        CharsetMapping.addAlias("1254", "cp1254");
        CharsetMapping.addAlias("windows_1254", "cp1254");
        CharsetMapping.addAlias("1255", "cp1255");
        CharsetMapping.addAlias("windows_1255", "cp1255");
        CharsetMapping.addAlias("1256", "cp1256");
        CharsetMapping.addAlias("windows_1256", "cp1256");
        CharsetMapping.addAlias("1257", "cp1257");
        CharsetMapping.addAlias("windows_1257", "cp1257");
        CharsetMapping.addAlias("1258", "cp1258");
        CharsetMapping.addAlias("windows_1258", "cp1258");
        CharsetMapping.addAlias("273", "cp273");
        CharsetMapping.addAlias("ibm273", "cp273");
        CharsetMapping.addAlias("csibm273", "cp273");
        CharsetMapping.addAlias("424", "cp424");
        CharsetMapping.addAlias("csibm424", "cp424");
        CharsetMapping.addAlias("ebcdic_cp_he", "cp424");
        CharsetMapping.addAlias("ibm424", "cp424");
        CharsetMapping.addAlias("437", "cp437");
        CharsetMapping.addAlias("cspc8codepage437", "cp437");
        CharsetMapping.addAlias("ibm437", "cp437");
        CharsetMapping.addAlias("500", "cp500");
        CharsetMapping.addAlias("csibm500", "cp500");
        CharsetMapping.addAlias("ebcdic_cp_be", "cp500");
        CharsetMapping.addAlias("ebcdic_cp_ch", "cp500");
        CharsetMapping.addAlias("ibm500", "cp500");
        CharsetMapping.addAlias("775", "cp775");
        CharsetMapping.addAlias("cspc775baltic", "cp775");
        CharsetMapping.addAlias("ibm775", "cp775");
        CharsetMapping.addAlias("850", "cp850");
        CharsetMapping.addAlias("cspc850multilingual", "cp850");
        CharsetMapping.addAlias("ibm850", "cp850");
        CharsetMapping.addAlias("852", "cp852");
        CharsetMapping.addAlias("cspcp852", "cp852");
        CharsetMapping.addAlias("ibm852", "cp852");
        CharsetMapping.addAlias("855", "cp855");
        CharsetMapping.addAlias("csibm855", "cp855");
        CharsetMapping.addAlias("ibm855", "cp855");
        CharsetMapping.addAlias("857", "cp857");
        CharsetMapping.addAlias("csibm857", "cp857");
        CharsetMapping.addAlias("ibm857", "cp857");
        CharsetMapping.addAlias("858", "cp858");
        CharsetMapping.addAlias("csibm858", "cp858");
        CharsetMapping.addAlias("ibm858", "cp858");
        CharsetMapping.addAlias("860", "cp860");
        CharsetMapping.addAlias("csibm860", "cp860");
        CharsetMapping.addAlias("ibm860", "cp860");
        CharsetMapping.addAlias("861", "cp861");
        CharsetMapping.addAlias("cp_is", "cp861");
        CharsetMapping.addAlias("csibm861", "cp861");
        CharsetMapping.addAlias("ibm861", "cp861");
        CharsetMapping.addAlias("862", "cp862");
        CharsetMapping.addAlias("cspc862latinhebrew", "cp862");
        CharsetMapping.addAlias("ibm862", "cp862");
        CharsetMapping.addAlias("863", "cp863");
        CharsetMapping.addAlias("csibm863", "cp863");
        CharsetMapping.addAlias("ibm863", "cp863");
        CharsetMapping.addAlias("864", "cp864");
        CharsetMapping.addAlias("csibm864", "cp864");
        CharsetMapping.addAlias("ibm864", "cp864");
        CharsetMapping.addAlias("865", "cp865");
        CharsetMapping.addAlias("csibm865", "cp865");
        CharsetMapping.addAlias("ibm865", "cp865");
        CharsetMapping.addAlias("866", "cp866");
        CharsetMapping.addAlias("csibm866", "cp866");
        CharsetMapping.addAlias("ibm866", "cp866");
        CharsetMapping.addAlias("869", "cp869");
        CharsetMapping.addAlias("cp_gr", "cp869");
        CharsetMapping.addAlias("csibm869", "cp869");
        CharsetMapping.addAlias("ibm869", "cp869");
        CharsetMapping.addAlias("932", "cp932");
        CharsetMapping.addAlias("ms932", "cp932");
        CharsetMapping.addAlias("mskanji", "cp932");
        CharsetMapping.addAlias("ms_kanji", "cp932");
        CharsetMapping.addAlias("949", "cp949");
        CharsetMapping.addAlias("ms949", "cp949");
        CharsetMapping.addAlias("uhc", "cp949");
        CharsetMapping.addAlias("950", "cp950");
        CharsetMapping.addAlias("ms950", "cp950");
        CharsetMapping.addAlias("jisx0213", "euc_jis_2004");
        CharsetMapping.addAlias("eucjis2004", "euc_jis_2004");
        CharsetMapping.addAlias("euc_jis2004", "euc_jis_2004");
        CharsetMapping.addAlias("eucjisx0213", "euc_jisx0213");
        CharsetMapping.addAlias("eucjp", "euc_jp");
        CharsetMapping.addAlias("ujis", "euc_jp");
        CharsetMapping.addAlias("u_jis", "euc_jp");
        CharsetMapping.addAlias("euckr", "euc_kr");
        CharsetMapping.addAlias("korean", "euc_kr");
        CharsetMapping.addAlias("ksc5601", "euc_kr");
        CharsetMapping.addAlias("ks_c_5601", "euc_kr");
        CharsetMapping.addAlias("ks_c_5601_1987", "euc_kr");
        CharsetMapping.addAlias("ksx1001", "euc_kr");
        CharsetMapping.addAlias("ks_x_1001", "euc_kr");
        CharsetMapping.addAlias("gb18030_2000", "gb18030");
        CharsetMapping.addAlias("chinese", "gb2312");
        CharsetMapping.addAlias("csiso58gb231280", "gb2312");
        CharsetMapping.addAlias("euc_cn", "gb2312");
        CharsetMapping.addAlias("euccn", "gb2312");
        CharsetMapping.addAlias("eucgb2312_cn", "gb2312");
        CharsetMapping.addAlias("gb2312_1980", "gb2312");
        CharsetMapping.addAlias("gb2312_80", "gb2312");
        CharsetMapping.addAlias("iso_ir_58", "gb2312");
        CharsetMapping.addAlias("936", "gbk");
        CharsetMapping.addAlias("cp936", "gbk");
        CharsetMapping.addAlias("ms936", "gbk");
        CharsetMapping.addAlias("roman8", "hp_roman8");
        CharsetMapping.addAlias("r8", "hp_roman8");
        CharsetMapping.addAlias("csHPRoman8", "hp_roman8");
        CharsetMapping.addAlias("cp1051", "hp_roman8");
        CharsetMapping.addAlias("ibm1051", "hp_roman8");
        CharsetMapping.addAlias("hzgb", "hz");
        CharsetMapping.addAlias("hz_gb", "hz");
        CharsetMapping.addAlias("hz_gb_2312", "hz");
        CharsetMapping.addAlias("csiso2022jp", "iso2022_jp");
        CharsetMapping.addAlias("iso2022jp", "iso2022_jp");
        CharsetMapping.addAlias("iso_2022_jp", "iso2022_jp");
        CharsetMapping.addAlias("iso2022jp_1", "iso2022_jp_1");
        CharsetMapping.addAlias("iso_2022_jp_1", "iso2022_jp_1");
        CharsetMapping.addAlias("iso2022jp_2", "iso2022_jp_2");
        CharsetMapping.addAlias("iso_2022_jp_2", "iso2022_jp_2");
        CharsetMapping.addAlias("iso_2022_jp_2004", "iso2022_jp_2004");
        CharsetMapping.addAlias("iso2022jp_2004", "iso2022_jp_2004");
        CharsetMapping.addAlias("iso2022jp_3", "iso2022_jp_3");
        CharsetMapping.addAlias("iso_2022_jp_3", "iso2022_jp_3");
        CharsetMapping.addAlias("iso2022jp_ext", "iso2022_jp_ext");
        CharsetMapping.addAlias("iso_2022_jp_ext", "iso2022_jp_ext");
        CharsetMapping.addAlias("csiso2022kr", "iso2022_kr");
        CharsetMapping.addAlias("iso2022kr", "iso2022_kr");
        CharsetMapping.addAlias("iso_2022_kr", "iso2022_kr");
        CharsetMapping.addAlias("csisolatin6", "iso8859_10");
        CharsetMapping.addAlias("iso_8859_10", "iso8859_10");
        CharsetMapping.addAlias("iso_8859_10_1992", "iso8859_10");
        CharsetMapping.addAlias("iso_ir_157", "iso8859_10");
        CharsetMapping.addAlias("l6", "iso8859_10");
        CharsetMapping.addAlias("latin6", "iso8859_10");
        CharsetMapping.addAlias("thai", "iso8859_11");
        CharsetMapping.addAlias("iso_8859_11", "iso8859_11");
        CharsetMapping.addAlias("iso_8859_11_2001", "iso8859_11");
        CharsetMapping.addAlias("iso_8859_13", "iso8859_13");
        CharsetMapping.addAlias("l7", "iso8859_13");
        CharsetMapping.addAlias("latin7", "iso8859_13");
        CharsetMapping.addAlias("iso_8859_14", "iso8859_14");
        CharsetMapping.addAlias("iso_8859_14_1998", "iso8859_14");
        CharsetMapping.addAlias("iso_celtic", "iso8859_14");
        CharsetMapping.addAlias("iso_ir_199", "iso8859_14");
        CharsetMapping.addAlias("l8", "iso8859_14");
        CharsetMapping.addAlias("latin8", "iso8859_14");
        CharsetMapping.addAlias("iso_8859_15", "iso8859_15");
        CharsetMapping.addAlias("l9", "iso8859_15");
        CharsetMapping.addAlias("latin9", "iso8859_15");
        CharsetMapping.addAlias("iso_8859_16", "iso8859_16");
        CharsetMapping.addAlias("iso_8859_16_2001", "iso8859_16");
        CharsetMapping.addAlias("iso_ir_226", "iso8859_16");
        CharsetMapping.addAlias("l10", "iso8859_16");
        CharsetMapping.addAlias("latin10", "iso8859_16");
        CharsetMapping.addAlias("csisolatin2", "iso8859_2");
        CharsetMapping.addAlias("iso_8859_2", "iso8859_2");
        CharsetMapping.addAlias("iso_8859_2_1987", "iso8859_2");
        CharsetMapping.addAlias("iso_ir_101", "iso8859_2");
        CharsetMapping.addAlias("l2", "iso8859_2");
        CharsetMapping.addAlias("latin2", "iso8859_2");
        CharsetMapping.addAlias("csisolatin3", "iso8859_3");
        CharsetMapping.addAlias("iso_8859_3", "iso8859_3");
        CharsetMapping.addAlias("iso_8859_3_1988", "iso8859_3");
        CharsetMapping.addAlias("iso_ir_109", "iso8859_3");
        CharsetMapping.addAlias("l3", "iso8859_3");
        CharsetMapping.addAlias("latin3", "iso8859_3");
        CharsetMapping.addAlias("csisolatin4", "iso8859_4");
        CharsetMapping.addAlias("iso_8859_4", "iso8859_4");
        CharsetMapping.addAlias("iso_8859_4_1988", "iso8859_4");
        CharsetMapping.addAlias("iso_ir_110", "iso8859_4");
        CharsetMapping.addAlias("l4", "iso8859_4");
        CharsetMapping.addAlias("latin4", "iso8859_4");
        CharsetMapping.addAlias("csisolatincyrillic", "iso8859_5");
        CharsetMapping.addAlias("cyrillic", "iso8859_5");
        CharsetMapping.addAlias("iso_8859_5", "iso8859_5");
        CharsetMapping.addAlias("iso_8859_5_1988", "iso8859_5");
        CharsetMapping.addAlias("iso_ir_144", "iso8859_5");
        CharsetMapping.addAlias("arabic", "iso8859_6");
        CharsetMapping.addAlias("asmo_708", "iso8859_6");
        CharsetMapping.addAlias("csisolatinarabic", "iso8859_6");
        CharsetMapping.addAlias("ecma_114", "iso8859_6");
        CharsetMapping.addAlias("iso_8859_6", "iso8859_6");
        CharsetMapping.addAlias("iso_8859_6_1987", "iso8859_6");
        CharsetMapping.addAlias("iso_ir_127", "iso8859_6");
        CharsetMapping.addAlias("csisolatingreek", "iso8859_7");
        CharsetMapping.addAlias("ecma_118", "iso8859_7");
        CharsetMapping.addAlias("elot_928", "iso8859_7");
        CharsetMapping.addAlias("greek", "iso8859_7");
        CharsetMapping.addAlias("greek8", "iso8859_7");
        CharsetMapping.addAlias("iso_8859_7", "iso8859_7");
        CharsetMapping.addAlias("iso_8859_7_1987", "iso8859_7");
        CharsetMapping.addAlias("iso_ir_126", "iso8859_7");
        CharsetMapping.addAlias("csisolatinhebrew", "iso8859_8");
        CharsetMapping.addAlias("hebrew", "iso8859_8");
        CharsetMapping.addAlias("iso_8859_8", "iso8859_8");
        CharsetMapping.addAlias("iso_8859_8_1988", "iso8859_8");
        CharsetMapping.addAlias("iso_ir_138", "iso8859_8");
        CharsetMapping.addAlias("csisolatin5", "iso8859_9");
        CharsetMapping.addAlias("iso_8859_9", "iso8859_9");
        CharsetMapping.addAlias("iso_8859_9_1989", "iso8859_9");
        CharsetMapping.addAlias("iso_ir_148", "iso8859_9");
        CharsetMapping.addAlias("l5", "iso8859_9");
        CharsetMapping.addAlias("latin5", "iso8859_9");
        CharsetMapping.addAlias("cp1361", "johab");
        CharsetMapping.addAlias("ms1361", "johab");
        CharsetMapping.addAlias("cskoi8r", "koi8_r");
        CharsetMapping.addAlias("kz_1048", "kz1048");
        CharsetMapping.addAlias("rk1048", "kz1048");
        CharsetMapping.addAlias("strk1048_2002", "kz1048");
        CharsetMapping.addAlias("8859", "latin_1");
        CharsetMapping.addAlias("cp819", "latin_1");
        CharsetMapping.addAlias("csisolatin1", "latin_1");
        CharsetMapping.addAlias("ibm819", "latin_1");
        CharsetMapping.addAlias("iso8859", "latin_1");
        CharsetMapping.addAlias("iso8859_1", "latin_1");
        CharsetMapping.addAlias("iso_8859_1", "latin_1");
        CharsetMapping.addAlias("iso_8859_1_1987", "latin_1");
        CharsetMapping.addAlias("iso_ir_100", "latin_1");
        CharsetMapping.addAlias("l1", "latin_1");
        CharsetMapping.addAlias("latin", "latin_1");
        CharsetMapping.addAlias("latin1", "latin_1");
        CharsetMapping.addAlias("maccyrillic", "mac_cyrillic");
        CharsetMapping.addAlias("macgreek", "mac_greek");
        CharsetMapping.addAlias("maciceland", "mac_iceland");
        CharsetMapping.addAlias("maccentraleurope", "mac_latin2");
        CharsetMapping.addAlias("maclatin2", "mac_latin2");
        CharsetMapping.addAlias("macintosh", "mac_roman");
        CharsetMapping.addAlias("macroman", "mac_roman");
        CharsetMapping.addAlias("macturkish", "mac_turkish");
        CharsetMapping.addAlias("csptcp154", "ptcp154");
        CharsetMapping.addAlias("pt154", "ptcp154");
        CharsetMapping.addAlias("cp154", "ptcp154");
        CharsetMapping.addAlias("cyrillic_asian", "ptcp154");
        CharsetMapping.addAlias("csshiftjis", "shift_jis");
        CharsetMapping.addAlias("shiftjis", "shift_jis");
        CharsetMapping.addAlias("sjis", "shift_jis");
        CharsetMapping.addAlias("s_jis", "shift_jis");
        CharsetMapping.addAlias("shiftjis2004", "shift_jis_2004");
        CharsetMapping.addAlias("sjis_2004", "shift_jis_2004");
        CharsetMapping.addAlias("s_jis_2004", "shift_jis_2004");
        CharsetMapping.addAlias("shiftjisx0213", "shift_jisx0213");
        CharsetMapping.addAlias("sjisx0213", "shift_jisx0213");
        CharsetMapping.addAlias("s_jisx0213", "shift_jisx0213");
        CharsetMapping.addAlias("u16", "utf_16");
        CharsetMapping.addAlias("utf16", "utf_16");
        CharsetMapping.addAlias("unicodebigunmarked", "utf_16_be");
        CharsetMapping.addAlias("utf_16be", "utf_16_be");
        CharsetMapping.addAlias("unicodelittleunmarked", "utf_16_le");
        CharsetMapping.addAlias("utf_16le", "utf_16_le");
        CharsetMapping.addAlias("u32", "utf_32");
        CharsetMapping.addAlias("utf32", "utf_32");
        CharsetMapping.addAlias("utf_32be", "utf_32_be");
        CharsetMapping.addAlias("utf_32le", "utf_32_le");
        CharsetMapping.addAlias("u7", "utf_7");
        CharsetMapping.addAlias("utf7", "utf_7");
        CharsetMapping.addAlias("unicode_1_1_utf_7", "utf_7");
        CharsetMapping.addAlias("u8", "utf_8");
        CharsetMapping.addAlias("utf", "utf_8");
        CharsetMapping.addAlias("utf8", "utf_8");
        CharsetMapping.addAlias("utf8_ucs2", "utf_8");
        CharsetMapping.addAlias("utf8_ucs4", "utf_8");
        CharsetMapping.addAlias("cp65001", "utf_8");
        CharsetMapping.addAlias("x_mac_japanese", "shift_jis");
        CharsetMapping.addAlias("x_mac_korean", "euc_kr");
        CharsetMapping.addAlias("x_mac_simp_chinese", "gb2312");
        CharsetMapping.addAlias("x_mac_trad_chinese", "big5");
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NormalizeEncodingNameNode
    extends Node {
        public abstract TruffleString execute(Node var1, TruffleString var2);

        @Specialization
        static TruffleString normalize(TruffleString encoding, @Cached(inline=false) TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached(inline=false) TruffleStringIterator.NextNode nextNode, @Cached(inline=false) TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached(inline=false) TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder str = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)encoding.byteLength(PythonUtils.TS_ENCODING));
            boolean lastCharInvalid = false;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)encoding, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int c = nextNode.execute(it, PythonUtils.TS_ENCODING);
                if (c >= 65 && c <= 90) {
                    appendCodePointNode.execute(str, c - 65 + 97, 1, true);
                    lastCharInvalid = false;
                    continue;
                }
                if (c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 46 || c == 95) {
                    appendCodePointNode.execute(str, c, 1, true);
                    lastCharInvalid = false;
                    continue;
                }
                if (lastCharInvalid) continue;
                appendCodePointNode.execute(str, 95, 1, true);
                lastCharInvalid = true;
            }
            return toStringNode.execute(str);
        }
    }
}

