/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.JnsObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.jdbc.Version2;
import com.informix.util.DelayedWeakReference;
import com.informix.util.IfxErrMsg;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class IfxDriver
implements Driver {
    private final String INFORMIXSQLI = "informix-sqli";
    private final String INFORMIXDIRECT = "informix-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.informix.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.informix.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.informix.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.informix.jdbc.IfxSqli";
    private static final int JDBC_SPEC_MAJOR_VERSION = 4;
    private static final int JDBC_SPEC_MINOR_VERSION = 2;

    @Override
    public Connection connect(String url, Properties prop) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (prop == null) {
            prop = new Properties();
        }
        this.checkClientLocale(url, prop);
        UrlInfo urlInfo = this.checkURL(url);
        String newURL = urlInfo.newUrl;
        Properties newProp = new Properties();
        String key = null;
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            newProp.put(key.toUpperCase(), prop.getProperty(key));
        }
        if (prop.containsKey("SETJVMLOCALE")) {
            newProp.put("SETJVMLOCALE", prop.getProperty("SETJVMLOCALE"));
        }
        newProp.put("USERURL", url);
        if (newURL == null && urlInfo.protocol.equals("informix-direct")) {
            newURL = url;
        }
        this.getPropertiesFromUrl(url, urlInfo, newProp);
        String newConnectionClass = newProp.getProperty("CONNECTIONCLASS");
        try {
            if (newConnectionClass.equals("com.informix.jdbc.IfxSqliConnect")) {
                return new IfxSqliConnect(newProp.getProperty("USER"), newProp.getProperty("PASSWORD"), newURL, newProp);
            }
            Class<?> clsRef = Class.forName(newProp.getProperty("CONNECTIONCLASS"));
            Class[] classArgs = new Class[]{url.getClass(), newProp.getClass()};
            Object[] objs = new Object[]{newURL, newProp};
            Constructor<?> cons = clsRef.getConstructor(classArgs);
            return (Connection)cons.newInstance(objs);
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (InvocationTargetException e3) {
            Throwable te = e3.getTargetException();
            throw (SQLException)te;
        }
        catch (Exception e4) {
            throw IfxErrMsg.getSQLException((Throwable)e4, -79704, new Object[0]);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith("jdbc:informix");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties prop) throws SQLException {
        DriverPropertyInfo[] displayPropertyInfoList = new DriverPropertyInfo[3];
        if (prop == null) {
            prop = new Properties();
        }
        StringTokenizer tokens = new StringTokenizer(url, "/:=; \t\n\r\f", true);
        int i = 1;
        String protocol = "";
        String dbName = "";
        String user = "";
        String password = "";
        if (tokens != null) {
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken();
                if (i == 3) {
                    protocol = t;
                }
                if (i > 3 && protocol.equalsIgnoreCase("informix-sqli")) {
                    if (i == 11) {
                        dbName = t;
                    } else if (i > 11) {
                        if (t.equalsIgnoreCase("user")) {
                            t = tokens.nextToken();
                            user = tokens.nextToken();
                        }
                        if (t.equalsIgnoreCase("password")) {
                            t = tokens.nextToken();
                            password = tokens.nextToken();
                        }
                    }
                }
                ++i;
                if (protocol.length() <= 0 || dbName.length() <= 0 || user.length() <= 0 || password.length() <= 0) continue;
                break;
            }
        }
        for (i = 0; i < 3; ++i) {
            DriverPropertyInfo info = null;
            if (i == 0) {
                info = new DriverPropertyInfo("DATABASE", dbName);
                info.description = "Database for connection";
                info.required = true;
            }
            if (i == 1) {
                if (user.length() == 0 && (prop.contains("user") || prop.contains("USER")) && ((user = prop.getProperty("user")) == null || user.length() == 0)) {
                    user = prop.getProperty("USER");
                }
                info = new DriverPropertyInfo("USER", user);
                info.description = "User name for connection ";
                info.required = true;
            }
            if (i == 2) {
                if (password.length() == 0 && (prop.contains("password") || prop.contains("PASSWORD")) && ((user = prop.getProperty("password")) == null || user.length() == 0)) {
                    user = prop.getProperty("PASSWORD");
                }
                info = new DriverPropertyInfo("PASSWORD", password);
                info.description = "Password for connection ";
                info.required = true;
            }
            displayPropertyInfoList[i] = info;
        }
        return displayPropertyInfoList;
    }

    @Override
    public int getMajorVersion() {
        return IfxDriver.getJDBCMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return IfxDriver.getJDBCMinorVersion();
    }

    public static int getMajorMinorVersion() {
        int maj = IfxDriver.getJDBCMajorVersion() * 100;
        int min = IfxDriver.getJDBCMinorVersion();
        return maj + min;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    UrlInfo checkURL(String url) throws SQLException {
        UrlInfo urlInfo = new UrlInfo();
        boolean checkSubprotocol = true;
        boolean gotIpV6Literal = false;
        int poNo = -1;
        String newURL = null;
        if (url.indexOf(58) == -1) {
            throw IfxErrMsg.getSQLException(-80004, ": '" + IfxErrMsg.getMinorMsg(-80035, Locale.getDefault()) + " '" + url + "'" + IfxErrMsg.getMinorMsg(-80004, Locale.getDefault()) + " ':''");
        }
        StringTokenizer urlStartTok = new StringTokenizer(url, ";=", true);
        String urlStart = urlStartTok.nextToken();
        boolean endsColon = false;
        boolean notLDAP = true;
        if (urlStart.charAt(urlStart.length() - 1) == ':') {
            endsColon = true;
        }
        StringTokenizer tok = new StringTokenizer(urlStart, ":", true);
        String jdbc = tok.nextToken();
        if (urlStartTok.hasMoreTokens() && urlStartTok.nextToken().equals("=")) {
            notLDAP = false;
        }
        if (!jdbc.equalsIgnoreCase("jdbc")) {
            throw IfxErrMsg.getSQLException(-79756);
        }
        tok.nextToken();
        String addr = tok.nextToken();
        if (tok.hasMoreTokens()) {
            tok.nextToken();
        }
        if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
            addr = addr.substring(2, addr.length());
        }
        if (addr.equals("informix-sqli")) {
            urlInfo.protocol = "informix-sqli";
            if (tok.hasMoreTokens()) {
                addr = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                tok.nextToken();
            }
        } else if (addr.equals("informix-direct")) {
            urlInfo.protocol = "informix-direct";
            checkSubprotocol = false;
            if (tok.hasMoreTokens()) {
                addr = tok.nextToken();
                if (!addr.equals(":") && tok.hasMoreTokens()) {
                    tok.nextToken();
                }
            } else {
                addr = null;
            }
        } else {
            throw IfxErrMsg.getSQLException(-79757, addr);
        }
        if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
            addr = addr.substring(2, addr.length());
            if (checkSubprotocol) {
                gotIpV6Literal = true;
            }
        }
        if (!checkSubprotocol) {
            if (addr != null && addr.length() > 0 && addr.charAt(0) == '/') {
                String dbAndOptionals = addr;
                StringTokenizer portT = new StringTokenizer(dbAndOptionals, "/");
                String dbName = portT.nextToken();
                if (!this.validDatabaseIdentifier(dbName)) {
                    throw IfxErrMsg.getSQLException(-79760, dbName);
                }
                urlInfo.databaseName = dbName;
                newURL = null;
            }
        } else {
            int requiredTokens;
            int tokensLeft = tok.countTokens();
            int n = requiredTokens = endsColon ? 3 : 4;
            if (gotIpV6Literal && tokensLeft <= requiredTokens) {
                gotIpV6Literal = false;
            }
            if (gotIpV6Literal) {
                addr = addr + ":";
                while (tokensLeft > requiredTokens) {
                    addr = addr + tok.nextToken();
                    --tokensLeft;
                }
                tok.nextToken();
            }
            StringTokenizer addrT = new StringTokenizer(addr, ".");
            String token1 = addrT.nextToken();
            if (notLDAP || tok.hasMoreTokens()) {
                if (token1.indexOf(47) == -1) {
                    if (!gotIpV6Literal && this.isANum(token1)) {
                        if (addrT.countTokens() != 3 || !this.isAIPNum(token1)) {
                            throw IfxErrMsg.getSQLException(-79758, addr);
                        }
                        while (addrT.hasMoreTokens()) {
                            token1 = addrT.nextToken();
                            if (this.isAIPNum(token1)) continue;
                            throw IfxErrMsg.getSQLException(-79758, addr);
                        }
                    }
                    if (!tok.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLException(-79705);
                    }
                    String port = tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        tok.nextToken();
                    }
                    if (port != null && port.indexOf(47) == -1) {
                        if (!this.isANum(port)) {
                            poNo = JnsObject.getServiceByName(port);
                            if (poNo == -1) {
                                throw IfxErrMsg.getSQLException(-79759, port);
                            }
                            newURL = addr + ":" + poNo;
                        } else {
                            newURL = addr + ":" + port;
                        }
                    } else if (port != null) {
                        StringTokenizer portT = new StringTokenizer(port, "/");
                        if (!this.isANum(port = portT.nextToken())) {
                            poNo = JnsObject.getServiceByName(port);
                            if (poNo == -1) {
                                throw IfxErrMsg.getSQLException(-79759, port);
                            }
                            newURL = addr + ":" + poNo;
                        } else {
                            newURL = addr + ":" + port;
                        }
                        String dbName = portT.nextToken(":").substring(1);
                        if (dbName == null || dbName.length() == 0) {
                            throw IfxErrMsg.getSQLException(-79760, dbName);
                        }
                        if (!this.validDatabaseIdentifier(dbName)) {
                            throw IfxErrMsg.getSQLException(-79760, dbName);
                        }
                        urlInfo.databaseName = dbName;
                    }
                } else {
                    urlInfo.databaseName = token1.substring(1, token1.length());
                }
            }
        }
        urlInfo.newUrl = newURL;
        return urlInfo;
    }

    private boolean isAIPNum(String s) {
        try {
            int ip = Integer.parseInt(s);
            return ip >= 0 && ip <= 255;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isANum(String s) {
        try {
            return Integer.parseInt(s) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void getPropertiesFromUrl(String url, UrlInfo urlInfo, Properties prop) throws SQLException {
        int a;
        int lastColon = -1;
        String propertiesStr = null;
        String propStr = null;
        StringTokenizer tok = null;
        StringTokenizer propT = null;
        if (prop.get("DATABASE") == null && urlInfo.databaseName != null) {
            prop.put("DATABASE", urlInfo.databaseName);
        }
        if ((a = url.indexOf(61)) != -1) {
            int b = -1;
            while ((b = url.indexOf(58, (lastColon = b) + 1)) != -1 && b < a) {
            }
            if (lastColon == -1) {
                return;
            }
        }
        if ((propertiesStr = url.substring(lastColon + 1)) != null) {
            if (propertiesStr.startsWith("//") && propertiesStr.contains("SQLH_FILE")) {
                propertiesStr = propertiesStr.substring(2);
            }
            tok = new StringTokenizer(propertiesStr, ";");
        }
        if (propertiesStr != null && propertiesStr.indexOf(61) != -1 && tok.hasMoreTokens()) {
            while (tok.hasMoreTokens()) {
                propStr = tok.nextToken(";");
                propT = new StringTokenizer(propStr, "=");
                String key = propT.nextToken();
                String value = propT.nextToken(";").substring(1);
                if (key.equalsIgnoreCase("CSM")) {
                    if (value == null || !value.startsWith("(") || !value.endsWith(")")) {
                        throw IfxErrMsg.getSQLException(-79705);
                    }
                    String csm_value = value.substring(1, value.length() - 1);
                    prop.put("CSM", csm_value);
                    continue;
                }
                prop.put(key.toUpperCase(), value);
            }
        }
        if (urlInfo.protocol.equals("informix-direct")) {
            if (prop.get("PROTOCOLCLASS") == null) {
                prop.put("PROTOCOLCLASS", "com.informix.jdbc.IfxDirectProtocol");
            }
            if (prop.get("CONNECTIONCLASS") == null) {
                prop.put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
            }
        } else {
            if (prop.get("PROTOCOLCLASS") == null) {
                prop.put("PROTOCOLCLASS", "com.informix.jdbc.IfxSqli");
            }
            if (prop.get("CONNECTIONCLASS") == null) {
                prop.put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            }
        }
        if ((urlInfo.proxy = prop.getProperty("PROXY")) != null) {
            urlInfo.proxy = this.formatProxy(urlInfo.proxy);
            prop.put("PROXY", urlInfo.proxy);
        }
    }

    private void checkClientLocale(String url, Properties prop) {
        int index;
        String clocale = prop.getProperty("CLIENT_LOCALE");
        if (clocale == null && (index = url.indexOf("CLIENT_LOCALE")) != -1) {
            String propStr = null;
            propStr = url.substring(index, url.length());
            StringTokenizer tok = new StringTokenizer(propStr, ";");
            while (tok.hasMoreTokens()) {
                String entry = tok.nextToken(";");
                if (entry.indexOf(61) == -1) continue;
                StringTokenizer propT = new StringTokenizer(entry, "=");
                String key = propT.nextToken();
                String value = propT.hasMoreTokens() ? propT.nextToken() : null;
                if (!key.equals("CLIENT_LOCALE")) continue;
                clocale = value;
            }
        }
    }

    private boolean validDatabaseIdentifier(String dbName) {
        int i = 1;
        int index = 0;
        String dbnam = null;
        index = dbName.lastIndexOf(47);
        dbnam = index != -1 ? dbName.substring(index + 1) : dbName;
        int len = dbnam.length();
        char c = dbnam.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (i = 1; i < len; ++i) {
            c = dbnam.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '#') continue;
            return false;
        }
        return true;
    }

    public static String getJDBCVersion() {
        return Version2.getLegacyVersionString();
    }

    static int getJDBCMajorVersion() {
        return 4;
    }

    static int extractMajorVersion(String version) throws SQLException {
        Integer major;
        StringTokenizer tok = new StringTokenizer(version, ".");
        String majorString = tok.nextToken();
        try {
            major = Integer.valueOf(majorString);
        }
        catch (NumberFormatException e) {
            throw IfxErrMsg.getSQLException((Throwable)e, -79716, new Object[0]);
        }
        return major;
    }

    static int extractMinorVersion(String version) throws SQLException {
        Integer minor;
        StringTokenizer tok = new StringTokenizer(version, ".");
        if (!tok.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79716);
        }
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79716);
        }
        String minorString = tok.nextToken();
        try {
            minor = Integer.valueOf(minorString);
        }
        catch (NumberFormatException e) {
            throw IfxErrMsg.getSQLException(-79716);
        }
        return minor;
    }

    static int getJDBCMinorVersion() {
        return 2;
    }

    private String formatProxy(String str) {
        String strT = null;
        String sub1 = null;
        String sub2 = null;
        String defHost = null;
        StringBuilder sb = new StringBuilder("http://");
        int i = str.indexOf(63);
        if (i != -1) {
            sub1 = str.substring(0, i);
            sub2 = str.substring(i, str.length());
        } else {
            sub1 = str;
        }
        try {
            defHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return str;
        }
        StringTokenizer st = new StringTokenizer(sub1, "/");
        while (st.hasMoreTokens()) {
            strT = st.nextToken();
            if (strT.toUpperCase().indexOf("HTTP") != -1 || strT.toUpperCase().indexOf("SERVLET") != -1 || strT.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            defHost = strT;
        }
        sb.append(defHost);
        sb.append("/servlet/IfxJDBCProxy");
        if (sub2 != null) {
            sb.append(sub2);
        }
        return sb.toString();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.informix.jdbc");
    }

    public static List<BSONObject> getPreparedStatementInfo() {
        DelayedWeakReference<PreparedStatementCache>[] arrayOfCaches;
        ArrayList<BSONObject> pstmtInfos = new ArrayList<BSONObject>();
        block2: for (DelayedWeakReference<PreparedStatementCache> dwrPsCache : arrayOfCaches = PreparedStatementCache.getPreparedStatementCaches()) {
            IfxSqliConnect.StmtList[] stmtArray;
            IfxSqliConnect connection;
            PreparedStatementCache psCache;
            if (dwrPsCache == null || dwrPsCache.isEnqueued() || (psCache = (PreparedStatementCache)dwrPsCache.get()) == null || psCache.connectionWeakReference == null || psCache.connectionWeakReference.isEnqueued() || (connection = (IfxSqliConnect)psCache.connectionWeakReference.get()) == null) break;
            for (IfxSqliConnect.StmtList node : stmtArray = connection.stmtList.toArray(new IfxSqliConnect.StmtList[0])) {
                if (node.weakReferenceStmt == null || node.weakReferenceStmt.isEnqueued()) continue block2;
                IfxStatement stmt = (IfxStatement)node.weakReferenceStmt.get();
                if (stmt == null) continue;
                BasicBSONObject pstmtInfo = new BasicBSONObject();
                if (stmt instanceof IfxPreparedStatement) {
                    IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                    pstmtInfo.put((Object)"sql", (Object)pstmt.baseStatement);
                    pstmtInfo.put((Object)"closed", (Object)pstmt.Closed);
                    pstmtInfo.put((Object)"currentResultIsNull", (Object)(pstmt.currentResult == null ? 1 : 0));
                    if (pstmt.jconn != null) {
                        try {
                            pstmtInfo.put((Object)"url", (Object)pstmt.jconn.getURL());
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                pstmtInfos.add((BSONObject)pstmtInfo);
            }
        }
        return pstmtInfos;
    }

    static {
        try {
            DriverManager.registerDriver(new IfxDriver());
        }
        catch (SQLException e) {
            System.out.println(IfxErrMsg.getMinorMsg(-80034, Locale.getDefault()) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704));
        }
    }

    private static class UrlInfo {
        private String databaseName;
        private String protocol;
        private String proxy;
        private String newUrl;

        private UrlInfo() {
        }
    }
}

