/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.exc;

import java.io.Closeable;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.introspect.BeanPropertyDefinition;

public class InvalidDefinitionException
extends DatabindException {
    protected final JavaType _type;
    protected transient BeanDescription _beanDesc;
    protected transient BeanPropertyDefinition _property;

    protected InvalidDefinitionException(JsonParser p, String msg, JavaType type) {
        super((Closeable)p, msg);
        this._type = type;
        this._beanDesc = null;
        this._property = null;
    }

    protected InvalidDefinitionException(JsonGenerator g, String msg, JavaType type) {
        super((Closeable)g, msg);
        this._type = type;
        this._beanDesc = null;
        this._property = null;
    }

    protected InvalidDefinitionException(JsonParser p, String msg, BeanDescription bean, BeanPropertyDefinition prop) {
        super((Closeable)p, msg);
        this._type = bean == null ? null : bean.getType();
        this._beanDesc = bean;
        this._property = prop;
    }

    protected InvalidDefinitionException(JsonGenerator g, String msg, BeanDescription bean, BeanPropertyDefinition prop) {
        super((Closeable)g, msg);
        this._type = bean == null ? null : bean.getType();
        this._beanDesc = bean;
        this._property = prop;
    }

    public static InvalidDefinitionException from(JsonParser p, String msg, BeanDescription bean, BeanPropertyDefinition prop) {
        return new InvalidDefinitionException(p, msg, bean, prop);
    }

    public static InvalidDefinitionException from(JsonParser p, String msg, BeanDescription.Supplier beanDescRef, BeanPropertyDefinition prop) {
        return new InvalidDefinitionException(p, msg, beanDescRef.get(), prop);
    }

    public static InvalidDefinitionException from(JsonParser p, String msg, JavaType type) {
        return new InvalidDefinitionException(p, msg, type);
    }

    public static InvalidDefinitionException from(JsonGenerator g, String msg, BeanDescription bean, BeanPropertyDefinition prop) {
        return new InvalidDefinitionException(g, msg, bean, prop);
    }

    public static InvalidDefinitionException from(JsonGenerator g, String msg, JavaType type) {
        return new InvalidDefinitionException(g, msg, type);
    }

    public JavaType getType() {
        return this._type;
    }

    public BeanDescription getBeanDescription() {
        return this._beanDesc;
    }

    public BeanPropertyDefinition getProperty() {
        return this._property;
    }
}

