/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.Serializable;
import tools.jackson.core.io.ContentReference;

public class TokenStreamLocation
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final TokenStreamLocation NA = new TokenStreamLocation(ContentReference.unknown(), -1L, -1L, -1, -1);
    private static final String NO_LOCATION_DESC = "[No location information]";
    protected final long _totalBytes;
    protected final long _totalChars;
    protected final int _lineNr;
    protected final int _columnNr;
    protected final ContentReference _contentReference;
    protected transient String _sourceDescription;

    public TokenStreamLocation(ContentReference contentRef, long totalChars, int lineNr, int colNr) {
        this(contentRef, -1L, totalChars, lineNr, colNr);
    }

    public TokenStreamLocation(ContentReference contentRef, long totalBytes, long totalChars, int lineNr, int columnNr) {
        if (contentRef == null) {
            contentRef = ContentReference.unknown();
        }
        this._contentReference = contentRef;
        this._totalBytes = totalBytes;
        this._totalChars = totalChars;
        this._lineNr = lineNr;
        this._columnNr = columnNr;
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    public int getLineNr() {
        return this._lineNr;
    }

    public int getColumnNr() {
        return this._columnNr;
    }

    public long getCharOffset() {
        return this._totalChars;
    }

    public long getByteOffset() {
        return this._totalBytes;
    }

    public String sourceDescription() {
        if (this._sourceDescription == null) {
            this._sourceDescription = this._contentReference.buildSourceDescription();
        }
        return this._sourceDescription;
    }

    public String offsetDescription() {
        return this.appendOffsetDescription(new StringBuilder(40)).toString();
    }

    public StringBuilder appendOffsetDescription(StringBuilder sb) {
        if (this._contentReference.hasTextualContent()) {
            sb.append("line: ");
            if (this._lineNr >= 0) {
                sb.append(this._lineNr);
            } else {
                sb.append("UNKNOWN");
            }
            sb.append(", column: ");
            if (this._columnNr >= 0) {
                sb.append(this._columnNr);
            } else {
                sb.append("UNKNOWN");
            }
        } else {
            sb.append("byte offset: #");
            if (this._totalBytes >= 0L) {
                sb.append(this._totalBytes);
            } else {
                sb.append("UNKNOWN");
            }
        }
        return sb;
    }

    public int hashCode() {
        int hash = this._contentReference == null ? 1 : 2;
        hash ^= this._lineNr;
        hash += this._columnNr;
        hash ^= (int)this._totalChars;
        return hash += (int)this._totalBytes;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TokenStreamLocation)) {
            return false;
        }
        TokenStreamLocation otherLoc = (TokenStreamLocation)other;
        if (this._contentReference == null ? otherLoc._contentReference != null : !this._contentReference.equals(otherLoc._contentReference)) {
            return false;
        }
        return this._lineNr == otherLoc._lineNr && this._columnNr == otherLoc._columnNr && this._totalChars == otherLoc._totalChars && this._totalBytes == otherLoc._totalBytes;
    }

    public String toString() {
        if (this == NA) {
            return NO_LOCATION_DESC;
        }
        String srcDesc = this.sourceDescription();
        StringBuilder sb = new StringBuilder(40 + srcDesc.length()).append("[Source: ").append(srcDesc).append("; ");
        return this.appendOffsetDescription(sb).append(']').toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (this == NA) {
            return sb.append(NO_LOCATION_DESC);
        }
        sb.append("[Source: ").append(this.sourceDescription()).append("; ");
        return this.appendOffsetDescription(sb).append(']');
    }
}

