/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.CopyRectDecoder;
import com.tigervnc.rfb.HextileDecoder;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.RREDecoder;
import com.tigervnc.rfb.RawDecoder;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Region;
import com.tigervnc.rfb.ServerParams;
import com.tigervnc.rfb.TightDecoder;
import com.tigervnc.rfb.ZRLEDecoder;

public abstract class Decoder {
    public final int flags;

    public Decoder(int n) {
        this.flags = n;
    }

    public abstract void readRect(Rect var1, InStream var2, ServerParams var3, OutStream var4);

    public abstract void decodeRect(Rect var1, Object var2, int var3, ServerParams var4, ModifiablePixelBuffer var5);

    public void getAffectedRegion(Rect rect, Object object, int n, ServerParams serverParams, Region region) {
        region.reset(rect);
    }

    public boolean doRectsConflict(Rect rect, Object object, int n, Rect rect2, Object object2, int n2, ServerParams serverParams) {
        return false;
    }

    public static boolean supported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static Decoder createDecoder(int n) {
        switch (n) {
            case 0: {
                return new RawDecoder();
            }
            case 1: {
                return new CopyRectDecoder();
            }
            case 2: {
                return new RREDecoder();
            }
            case 5: {
                return new HextileDecoder();
            }
            case 16: {
                return new ZRLEDecoder();
            }
            case 7: {
                return new TightDecoder();
            }
        }
        return null;
    }

    public static class DecoderFlags {
        public static int DecoderPlain = 0;
        public static int DecoderOrdered = 1;
        public static int DecoderPartiallyOrdered = 2;
    }
}

