" Name:         Retro Box
" Description:  Retro groove color scheme similar to gruvbox originally designed by morhetz <morhetz@gmail.com>
" Author:       Maxim Kim <habamax@gmail.com>, ported from gruvbox8 of Lifepillar <lifepillar@lifepillar.me>
" URL:          https://www.github.com/vim/colorschemes
" Last Change:  2025 Oct 08

" Generated by Colortemplate v3.0.0-beta10

hi clear
let g:colors_name = 'retrobox'

let s:t_Co = has('gui_running') ? 16777216 : str2nr(&t_Co)
let s:tgc = has('termguicolors') && &termguicolors

hi! link CurSearch IncSearch
hi! link CursorColumn CursorLine
hi! link CursorLineFold FoldColumn
hi! link CursorLineSign FoldColumn
hi! link LineNrAbove LineNr
hi! link LineNrBelow LineNr
hi! link MessageWindow PMenu
hi! link PopupNotification Todo
hi! link PreInsert LineNr
hi! link StatusLineTerm StatusLine
hi! link StatusLineTermNC StatusLineNC
hi! link Tag Special
hi! link Terminal Normal
hi! link VisualNOS Visual
hi! link lCursor Cursor

if &background == 'dark'
  let g:terminal_ansi_colors = ['#1c1c1c', '#cc241d', '#98971a', '#d79921', '#458588', '#b16286', '#689d6a', '#a89984', '#928374', '#fb5944', '#b8bb26', '#fabd2f', '#83a598', '#d3869b', '#8ec07c', '#ebdbb2']

  hi Normal guifg=#ebdbb2 guibg=#1c1c1c guisp=NONE gui=NONE ctermfg=187 ctermbg=234 cterm=NONE term=NONE
  hi Boolean guifg=#d3869b guibg=NONE guisp=NONE gui=NONE ctermfg=175 ctermbg=NONE cterm=NONE term=NONE
  hi Character guifg=#d3869b guibg=NONE guisp=NONE gui=NONE ctermfg=175 ctermbg=NONE cterm=NONE term=NONE
  hi ColorColumn guifg=NONE guibg=#000000 guisp=NONE gui=NONE ctermfg=NONE ctermbg=16 cterm=NONE term=reverse
  hi Comment guifg=#928374 guibg=NONE guisp=NONE gui=NONE ctermfg=102 ctermbg=NONE cterm=NONE term=bold
  hi Conceal guifg=#504945 guibg=NONE guisp=NONE gui=NONE ctermfg=239 ctermbg=NONE cterm=NONE term=NONE
  hi Conditional guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi Constant guifg=#d3869b guibg=NONE guisp=NONE gui=NONE ctermfg=175 ctermbg=NONE cterm=NONE term=NONE
  hi Cursor guifg=#1c1c1c guibg=#fbf1c7 guisp=NONE gui=NONE ctermfg=234 ctermbg=230 cterm=NONE term=reverse
  hi CursorIM guifg=#1c1c1c guibg=#fbf1c7 guisp=NONE gui=NONE ctermfg=234 ctermbg=230 cterm=NONE term=NONE
  hi CursorLine guifg=NONE guibg=#303030 guisp=NONE gui=NONE ctermfg=NONE ctermbg=236 cterm=NONE term=underline
  hi CursorLineNr guifg=#fabd2f guibg=#1c1c1c guisp=NONE gui=bold ctermfg=214 ctermbg=234 cterm=bold term=bold
  hi Debug guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi Define guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi Delimiter guifg=#fe8019 guibg=NONE guisp=NONE gui=NONE ctermfg=208 ctermbg=NONE cterm=NONE term=NONE
  hi DiffAdd guifg=NONE guibg=#273923 guisp=NONE gui=NONE ctermfg=230 ctermbg=22 cterm=NONE term=reverse
  hi DiffChange guifg=NONE guibg=#37352f guisp=NONE gui=NONE ctermfg=230 ctermbg=59 cterm=NONE term=NONE
  hi DiffDelete guifg=#a89984 guibg=#2f1f1a guisp=NONE gui=NONE ctermfg=102 ctermbg=52 cterm=NONE term=reverse
  hi DiffText guifg=NONE guibg=#0f4f4f guisp=NONE gui=NONE ctermfg=230 ctermbg=23 cterm=NONE term=reverse
  hi Directory guifg=#b8bb26 guibg=NONE guisp=NONE gui=bold ctermfg=142 ctermbg=NONE cterm=bold term=NONE
  hi EndOfBuffer guifg=#504945 guibg=NONE guisp=NONE gui=NONE ctermfg=239 ctermbg=NONE cterm=NONE term=NONE
  hi Error guifg=#fb5944 guibg=#1c1c1c guisp=NONE gui=bold,reverse ctermfg=203 ctermbg=234 cterm=bold,reverse term=bold,reverse
  hi ErrorMsg guifg=#1c1c1c guibg=#fb5944 guisp=NONE gui=bold ctermfg=234 ctermbg=203 cterm=bold term=bold,reverse
  hi Exception guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi Float guifg=#d3869b guibg=NONE guisp=NONE gui=NONE ctermfg=175 ctermbg=NONE cterm=NONE term=NONE
  hi FoldColumn guifg=#928374 guibg=#1c1c1c guisp=NONE gui=NONE ctermfg=102 ctermbg=234 cterm=NONE term=NONE
  hi Folded guifg=#928374 guibg=#121212 guisp=NONE gui=NONE ctermfg=102 ctermbg=233 cterm=NONE term=NONE
  hi Function guifg=#b8bb26 guibg=NONE guisp=NONE gui=bold ctermfg=142 ctermbg=NONE cterm=bold term=NONE
  hi Identifier guifg=#83a598 guibg=NONE guisp=NONE gui=NONE ctermfg=109 ctermbg=NONE cterm=NONE term=NONE
  hi Ignore guifg=fg guibg=NONE guisp=NONE gui=NONE ctermfg=fg ctermbg=NONE cterm=NONE term=NONE
  hi IncSearch guifg=NONE guibg=#5f431f guisp=NONE gui=NONE ctermfg=208 ctermbg=234 cterm=reverse term=bold,reverse,underline
  hi Include guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi Keyword guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi Label guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi LineNr guifg=#7c6f64 guibg=NONE guisp=NONE gui=NONE ctermfg=243 ctermbg=NONE cterm=NONE term=NONE
  hi Macro guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi MatchParen guifg=NONE guibg=#504945 guisp=NONE gui=bold,underline ctermfg=NONE ctermbg=239 cterm=bold,underline term=bold,underline
  hi ModeMsg guifg=#fabd2f guibg=NONE guisp=NONE gui=bold ctermfg=214 ctermbg=NONE cterm=bold term=bold
  hi MoreMsg guifg=#fabd2f guibg=NONE guisp=NONE gui=bold ctermfg=214 ctermbg=NONE cterm=bold term=NONE
  hi NonText guifg=#504945 guibg=NONE guisp=NONE gui=NONE ctermfg=239 ctermbg=NONE cterm=NONE term=NONE
  hi Number guifg=#d3869b guibg=NONE guisp=NONE gui=NONE ctermfg=175 ctermbg=NONE cterm=NONE term=NONE
  hi Operator guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi Pmenu guifg=NONE guibg=#3c3836 guisp=NONE gui=NONE ctermfg=NONE ctermbg=237 cterm=NONE term=reverse
  hi PmenuBorder guifg=#a89984 guibg=#3c3836 guisp=NONE gui=NONE ctermfg=102 ctermbg=237 cterm=NONE term=NONE
  hi PmenuExtra guifg=#a89984 guibg=#3c3836 guisp=NONE gui=NONE ctermfg=102 ctermbg=237 cterm=NONE term=NONE
  hi PmenuExtraSel guifg=#a89984 guibg=#504945 guisp=NONE gui=NONE ctermfg=102 ctermbg=239 cterm=NONE term=NONE
  hi PmenuKind guifg=#fb5944 guibg=#3c3836 guisp=NONE gui=NONE ctermfg=203 ctermbg=237 cterm=NONE term=NONE
  hi PmenuKindSel guifg=#fb5944 guibg=#504945 guisp=NONE gui=NONE ctermfg=203 ctermbg=239 cterm=NONE term=NONE
  hi PmenuMatch guifg=#d3869b guibg=#3c3836 guisp=NONE gui=NONE ctermfg=175 ctermbg=237 cterm=NONE term=NONE
  hi PmenuMatchSel guifg=#d3869b guibg=#504945 guisp=NONE gui=NONE ctermfg=175 ctermbg=239 cterm=NONE term=NONE
  hi PmenuSbar guifg=NONE guibg=#3c3836 guisp=NONE gui=NONE ctermfg=NONE ctermbg=237 cterm=NONE term=reverse
  hi PmenuSel guifg=NONE guibg=#504945 guisp=NONE gui=NONE ctermfg=NONE ctermbg=239 cterm=NONE term=bold
  hi PmenuThumb guifg=NONE guibg=#7c6f64 guisp=NONE gui=NONE ctermfg=NONE ctermbg=243 cterm=NONE term=NONE
  hi PreCondit guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi PreProc guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi Question guifg=#fe8019 guibg=NONE guisp=NONE gui=bold ctermfg=208 ctermbg=NONE cterm=bold term=standout
  hi QuickFixLine guifg=NONE guibg=#4f2f4f guisp=NONE gui=NONE ctermfg=230 ctermbg=53 cterm=NONE term=NONE
  hi Repeat guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi Search guifg=NONE guibg=#3a4a3a guisp=NONE gui=NONE ctermfg=100 ctermbg=234 cterm=reverse term=reverse
  hi SignColumn guifg=#928374 guibg=#1c1c1c guisp=NONE gui=NONE ctermfg=102 ctermbg=234 cterm=NONE term=reverse
  hi Special guifg=#fe8019 guibg=NONE guisp=NONE gui=NONE ctermfg=208 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialChar guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialComment guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialKey guifg=#928374 guibg=NONE guisp=NONE gui=NONE ctermfg=102 ctermbg=NONE cterm=NONE term=bold
  hi SpellBad guifg=#fb5944 guibg=NONE guisp=#fb5944 gui=undercurl ctermfg=203 ctermbg=NONE cterm=underline term=underline
  hi SpellCap guifg=#83a598 guibg=NONE guisp=#83a598 gui=undercurl ctermfg=109 ctermbg=NONE cterm=underline term=underline
  hi SpellLocal guifg=#8ec07c guibg=NONE guisp=#8ec07c gui=undercurl ctermfg=107 ctermbg=NONE cterm=underline term=underline
  hi SpellRare guifg=#d3869b guibg=NONE guisp=#d3869b gui=undercurl ctermfg=175 ctermbg=NONE cterm=underline term=underline
  hi Statement guifg=#fb5944 guibg=NONE guisp=NONE gui=NONE ctermfg=203 ctermbg=NONE cterm=NONE term=NONE
  hi StatusLine guifg=#504945 guibg=#ebdbb2 guisp=NONE gui=bold,reverse ctermfg=239 ctermbg=187 cterm=bold,reverse term=bold,reverse
  hi StatusLineNC guifg=#3c3836 guibg=#a89984 guisp=NONE gui=reverse ctermfg=237 ctermbg=102 cterm=reverse term=bold,underline
  hi StorageClass guifg=#fe8019 guibg=NONE guisp=NONE gui=NONE ctermfg=208 ctermbg=NONE cterm=NONE term=NONE
  hi String guifg=#b8bb26 guibg=NONE guisp=NONE gui=NONE ctermfg=142 ctermbg=NONE cterm=NONE term=NONE
  hi Structure guifg=#8ec07c guibg=NONE guisp=NONE gui=NONE ctermfg=107 ctermbg=NONE cterm=NONE term=NONE
  hi TabLine guifg=#a89984 guibg=#3c3836 guisp=NONE gui=NONE ctermfg=102 ctermbg=237 cterm=NONE term=bold,underline
  hi TabLineFill guifg=#ebdbb2 guibg=#3c3836 guisp=NONE gui=NONE ctermfg=187 ctermbg=237 cterm=NONE term=NONE
  hi TabLineSel guifg=#fbf1c7 guibg=#1c1c1c guisp=NONE gui=bold ctermfg=230 ctermbg=234 cterm=bold term=bold,reverse
  hi Title guifg=#b8bb26 guibg=NONE guisp=NONE gui=bold ctermfg=142 ctermbg=NONE cterm=bold term=NONE
  hi TitleBar guifg=#ebdbb2 guibg=#3c3c3c guisp=NONE gui=NONE ctermfg=187 ctermbg=237 cterm=NONE term=NONE
  hi TitleBarNC guifg=#a89984 guibg=#2c2c2c guisp=NONE gui=NONE ctermfg=102 ctermbg=236 cterm=NONE term=NONE
  hi Todo guifg=fg guibg=#1c1c1c guisp=NONE gui=bold ctermfg=fg ctermbg=234 cterm=bold term=bold,reverse
  hi ToolbarButton guifg=#fbf1c7 guibg=#303030 guisp=NONE gui=bold ctermfg=230 ctermbg=236 cterm=bold term=bold,reverse
  hi ToolbarLine guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi Type guifg=#fabd2f guibg=NONE guisp=NONE gui=NONE ctermfg=214 ctermbg=NONE cterm=NONE term=NONE
  hi Typedef guifg=#fabd2f guibg=NONE guisp=NONE gui=NONE ctermfg=214 ctermbg=NONE cterm=NONE term=NONE
  hi Underlined guifg=#83a598 guibg=NONE guisp=NONE gui=underline ctermfg=109 ctermbg=NONE cterm=underline term=underline
  hi VertSplit guifg=#303030 guibg=#1c1c1c guisp=NONE gui=NONE ctermfg=236 ctermbg=234 cterm=NONE term=NONE
  hi Visual guifg=NONE guibg=#2a405a guisp=NONE gui=NONE ctermfg=109 ctermbg=234 cterm=reverse term=reverse
  hi WarningMsg guifg=#fb5944 guibg=NONE guisp=NONE gui=bold ctermfg=203 ctermbg=NONE cterm=bold term=standout
  hi WildMenu guifg=#83a598 guibg=#504945 guisp=NONE gui=bold ctermfg=109 ctermbg=239 cterm=bold term=bold

  if s:tgc || s:t_Co >= 256
    if s:tgc
      hi IncSearch cterm=NONE
      hi QuickFixLine cterm=NONE
      hi Search cterm=NONE
      hi Visual cterm=NONE
    endif
    finish
  endif

  if s:t_Co >= 16
    hi Normal ctermfg=White ctermbg=Black cterm=NONE
    hi Boolean ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Character ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=Black ctermbg=DarkYellow cterm=NONE
    hi Comment ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Conceal ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Conditional ctermfg=Red ctermbg=NONE cterm=NONE
    hi Constant ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Cursor ctermfg=Black ctermbg=White cterm=NONE
    hi CursorIM ctermfg=Black ctermbg=White cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Debug ctermfg=Red ctermbg=NONE cterm=NONE
    hi Define ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Delimiter ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi DiffAdd ctermfg=Black ctermbg=darkgreen cterm=NONE
    hi DiffChange ctermfg=Black ctermbg=darkyellow cterm=NONE
    hi DiffDelete ctermfg=Black ctermbg=darkred cterm=NONE
    hi DiffText ctermfg=Black ctermbg=darkcyan cterm=NONE
    hi Directory ctermfg=Green ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Error ctermfg=Red ctermbg=Black cterm=reverse
    hi ErrorMsg ctermfg=Black ctermbg=Red cterm=NONE
    hi Exception ctermfg=Red ctermbg=NONE cterm=NONE
    hi Float ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi FoldColumn ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Folded ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Function ctermfg=Green ctermbg=NONE cterm=bold
    hi Identifier ctermfg=Blue ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=fg ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=Magenta ctermbg=Black cterm=reverse
    hi Include ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Keyword ctermfg=Red ctermbg=NONE cterm=NONE
    hi Label ctermfg=Red ctermbg=NONE cterm=NONE
    hi LineNr ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Macro ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=NONE ctermbg=Black cterm=bold,underline
    hi ModeMsg ctermfg=Yellow ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=Yellow ctermbg=NONE cterm=bold
    hi NonText ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Number ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Operator ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=Black ctermbg=White cterm=NONE
    hi PmenuBorder ctermfg=Black ctermbg=White cterm=NONE
    hi PmenuExtra ctermfg=DarkGray ctermbg=White cterm=NONE
    hi PmenuExtraSel ctermfg=DarkGray ctermbg=Black cterm=NONE
    hi PmenuKind ctermfg=DarkRed ctermbg=White cterm=NONE
    hi PmenuKindSel ctermfg=DarkRed ctermbg=Black cterm=NONE
    hi PmenuMatch ctermfg=Black ctermbg=White cterm=bold
    hi PmenuMatchSel ctermfg=Black ctermbg=White cterm=bold,reverse
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=White ctermbg=Black cterm=NONE
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreCondit ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi PreProc ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=Magenta ctermbg=NONE cterm=bold
    hi QuickFixLine ctermfg=Black ctermbg=magenta cterm=NONE
    hi Repeat ctermfg=Red ctermbg=NONE cterm=NONE
    hi Search ctermfg=DarkGreen ctermbg=Black cterm=reverse
    hi SignColumn ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Special ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi SpecialChar ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialComment ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=Red ctermbg=NONE cterm=underline
    hi SpellCap ctermfg=Blue ctermbg=NONE cterm=underline
    hi SpellLocal ctermfg=Cyan ctermbg=NONE cterm=underline
    hi SpellRare ctermfg=Magenta ctermbg=NONE cterm=underline
    hi Statement ctermfg=Red ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=gray ctermbg=Black cterm=bold,reverse
    hi StatusLineNC ctermfg=gray ctermbg=Black cterm=reverse
    hi StorageClass ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi String ctermfg=Green ctermbg=NONE cterm=NONE
    hi Structure ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=Black ctermbg=DarkGray cterm=NONE
    hi TabLineFill ctermfg=Black ctermbg=DarkGray cterm=NONE
    hi TabLineSel ctermfg=White ctermbg=Black cterm=bold
    hi Title ctermfg=Green ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=White ctermbg=black cterm=NONE
    hi TitleBarNC ctermfg=gray ctermbg=black cterm=NONE
    hi Todo ctermfg=fg ctermbg=Black cterm=bold
    hi ToolbarButton ctermfg=White ctermbg=DarkGray cterm=bold
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Typedef ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=Blue ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=Black ctermbg=gray cterm=NONE
    hi Visual ctermfg=Blue ctermbg=Black cterm=reverse
    hi WarningMsg ctermfg=Red ctermbg=NONE cterm=bold
    hi WildMenu ctermfg=White ctermbg=Black cterm=bold
    finish
  endif

  if s:t_Co >= 8
    hi Normal ctermfg=gray ctermbg=Black cterm=NONE
    hi Boolean ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Character ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=Black ctermbg=gray cterm=NONE
    hi Comment ctermfg=gray ctermbg=NONE cterm=bold
    hi Conceal ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Conditional ctermfg=Red ctermbg=NONE cterm=NONE
    hi Constant ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Cursor ctermfg=Black ctermbg=White cterm=NONE
    hi CursorIM ctermfg=Black ctermbg=White cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Debug ctermfg=Red ctermbg=NONE cterm=NONE
    hi Define ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Delimiter ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi DiffAdd ctermfg=Black ctermbg=darkgreen cterm=NONE
    hi DiffChange ctermfg=Black ctermbg=darkyellow cterm=NONE
    hi DiffDelete ctermfg=Black ctermbg=darkred cterm=NONE
    hi DiffText ctermfg=Black ctermbg=darkcyan cterm=NONE
    hi Directory ctermfg=Green ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Error ctermfg=Red ctermbg=Black cterm=reverse
    hi ErrorMsg ctermfg=Black ctermbg=Red cterm=NONE
    hi Exception ctermfg=Red ctermbg=NONE cterm=NONE
    hi Float ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi FoldColumn ctermfg=gray ctermbg=NONE cterm=NONE
    hi Folded ctermfg=gray ctermbg=NONE cterm=NONE
    hi Function ctermfg=Green ctermbg=NONE cterm=bold
    hi Identifier ctermfg=Blue ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=fg ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=Magenta ctermbg=Black cterm=reverse
    hi Include ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Keyword ctermfg=Red ctermbg=NONE cterm=NONE
    hi Label ctermfg=Red ctermbg=NONE cterm=NONE
    hi LineNr ctermfg=gray ctermbg=NONE cterm=NONE
    hi Macro ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=gray ctermbg=NONE cterm=bold,underline
    hi ModeMsg ctermfg=Yellow ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=Yellow ctermbg=NONE cterm=bold
    hi NonText ctermfg=gray ctermbg=NONE cterm=NONE
    hi Number ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Operator ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuBorder ctermfg=gray ctermbg=DarkGray cterm=NONE
    hi PmenuExtra ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuExtraSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuKind ctermfg=NONE ctermbg=NONE cterm=bold,reverse
    hi PmenuKindSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuMatch ctermfg=NONE ctermbg=Red cterm=reverse
    hi PmenuMatchSel ctermfg=Red ctermbg=NONE cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreCondit ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi PreProc ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=Magenta ctermbg=NONE cterm=bold
    hi QuickFixLine ctermfg=White ctermbg=magenta cterm=NONE
    hi Repeat ctermfg=Red ctermbg=NONE cterm=NONE
    hi Search ctermfg=DarkGreen ctermbg=Black cterm=reverse
    hi SignColumn ctermfg=gray ctermbg=NONE cterm=NONE
    hi Special ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi SpecialChar ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialComment ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=gray ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=Red ctermbg=NONE cterm=underline
    hi SpellCap ctermfg=Blue ctermbg=NONE cterm=underline
    hi SpellLocal ctermfg=Cyan ctermbg=NONE cterm=underline
    hi SpellRare ctermfg=Magenta ctermbg=NONE cterm=underline
    hi Statement ctermfg=Red ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=gray ctermbg=Black cterm=bold,reverse
    hi StatusLineNC ctermfg=gray ctermbg=Black cterm=reverse
    hi StorageClass ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi String ctermfg=Green ctermbg=NONE cterm=NONE
    hi Structure ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=Black ctermbg=gray cterm=NONE
    hi TabLineFill ctermfg=Black ctermbg=gray cterm=NONE
    hi TabLineSel ctermfg=gray ctermbg=Black cterm=NONE
    hi Title ctermfg=NONE ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=White ctermbg=black cterm=NONE
    hi TitleBarNC ctermfg=gray ctermbg=black cterm=NONE
    hi Todo ctermfg=fg ctermbg=Black cterm=bold
    hi ToolbarButton ctermfg=Black ctermbg=gray cterm=bold
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Typedef ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=Blue ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=Black ctermbg=gray cterm=NONE
    hi Visual ctermfg=Black ctermbg=Blue cterm=NONE
    hi WarningMsg ctermfg=Red ctermbg=NONE cterm=bold
    hi WildMenu ctermfg=Blue ctermbg=DarkGray cterm=bold
    finish
  endif

  if s:t_Co >= 0
    hi CurSearch term=reverse
    hi CursorColumn term=NONE
    hi CursorLineFold term=underline
    hi CursorLineSign term=underline
    hi StatusLineTerm term=bold,reverse
    hi StatusLineTermNC term=bold,underline
    hi Terminal term=NONE
    hi VisualNOS term=NONE
    finish
  endif

  finish
endif

if &background == 'light'
  let g:terminal_ansi_colors = ['#3c3836', '#cc241d', '#98971a', '#d79921', '#458588', '#b16286', '#689d6a', '#7c6f64', '#928374', '#9d0006', '#79740e', '#b57614', '#076678', '#8f3f71', '#427b58', '#fbf1c7']

  hi Normal guifg=#3c3836 guibg=#fbf1c7 guisp=NONE gui=NONE ctermfg=237 ctermbg=230 cterm=NONE term=NONE
  hi Boolean guifg=#8f3f71 guibg=NONE guisp=NONE gui=NONE ctermfg=126 ctermbg=NONE cterm=NONE term=NONE
  hi Character guifg=#8f3f71 guibg=NONE guisp=NONE gui=NONE ctermfg=126 ctermbg=NONE cterm=NONE term=NONE
  hi ColorColumn guifg=NONE guibg=#ebe1b7 guisp=NONE gui=NONE ctermfg=NONE ctermbg=229 cterm=NONE term=reverse
  hi Comment guifg=#928374 guibg=NONE guisp=NONE gui=NONE ctermfg=102 ctermbg=NONE cterm=NONE term=bold
  hi Conceal guifg=#a89984 guibg=NONE guisp=NONE gui=NONE ctermfg=137 ctermbg=NONE cterm=NONE term=NONE
  hi Conditional guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi Constant guifg=#8f3f71 guibg=NONE guisp=NONE gui=NONE ctermfg=126 ctermbg=NONE cterm=NONE term=NONE
  hi Cursor guifg=#fbf1c7 guibg=#282828 guisp=NONE gui=NONE ctermfg=230 ctermbg=235 cterm=NONE term=reverse
  hi CursorIM guifg=#fbf1c7 guibg=#282828 guisp=NONE gui=NONE ctermfg=230 ctermbg=235 cterm=NONE term=NONE
  hi CursorLine guifg=NONE guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=NONE ctermbg=187 cterm=NONE term=underline
  hi CursorLineNr guifg=#b57614 guibg=#fbf1c7 guisp=NONE gui=bold ctermfg=172 ctermbg=230 cterm=bold term=bold
  hi Debug guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi Define guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi Delimiter guifg=#ff5f00 guibg=NONE guisp=NONE gui=NONE ctermfg=202 ctermbg=NONE cterm=NONE term=NONE
  hi DiffAdd guifg=NONE guibg=#d7d7a7 guisp=NONE gui=NONE ctermfg=235 ctermbg=108 cterm=NONE term=reverse
  hi DiffChange guifg=NONE guibg=#e7d7a7 guisp=NONE gui=NONE ctermfg=235 ctermbg=250 cterm=NONE term=NONE
  hi DiffDelete guifg=#7c6f64 guibg=#e7b7a7 guisp=NONE gui=NONE ctermfg=187 ctermbg=131 cterm=NONE term=reverse
  hi DiffText guifg=NONE guibg=#a7d7a7 guisp=NONE gui=NONE ctermfg=235 ctermbg=109 cterm=NONE term=reverse
  hi Directory guifg=#79740e guibg=NONE guisp=NONE gui=bold ctermfg=64 ctermbg=NONE cterm=bold term=NONE
  hi EndOfBuffer guifg=#e5d4b1 guibg=NONE guisp=NONE gui=NONE ctermfg=187 ctermbg=NONE cterm=NONE term=NONE
  hi Error guifg=#9d0006 guibg=#fbf1c7 guisp=NONE gui=bold,reverse ctermfg=124 ctermbg=230 cterm=bold,reverse term=bold,reverse
  hi ErrorMsg guifg=#fbf1c7 guibg=#9d0006 guisp=NONE gui=bold ctermfg=230 ctermbg=124 cterm=bold term=bold,reverse
  hi Exception guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi Float guifg=#8f3f71 guibg=NONE guisp=NONE gui=NONE ctermfg=126 ctermbg=NONE cterm=NONE term=NONE
  hi FoldColumn guifg=#928374 guibg=#fbf1c7 guisp=NONE gui=NONE ctermfg=102 ctermbg=230 cterm=NONE term=NONE
  hi Folded guifg=#928374 guibg=#ffffd7 guisp=NONE gui=NONE ctermfg=102 ctermbg=231 cterm=NONE term=NONE
  hi Function guifg=#79740e guibg=NONE guisp=NONE gui=bold ctermfg=64 ctermbg=NONE cterm=bold term=NONE
  hi Identifier guifg=#076678 guibg=NONE guisp=NONE gui=NONE ctermfg=23 ctermbg=NONE cterm=NONE term=NONE
  hi Ignore guifg=fg guibg=NONE guisp=NONE gui=NONE ctermfg=fg ctermbg=NONE cterm=NONE term=NONE
  hi IncSearch guifg=NONE guibg=#f7c7a7 guisp=NONE gui=NONE ctermfg=202 ctermbg=230 cterm=reverse term=bold,reverse,underline
  hi Include guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi Keyword guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi Label guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi LineNr guifg=#a89984 guibg=NONE guisp=NONE gui=NONE ctermfg=137 ctermbg=NONE cterm=NONE term=NONE
  hi Macro guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi MatchParen guifg=NONE guibg=#e5d4b1 guisp=NONE gui=bold,underline ctermfg=NONE ctermbg=187 cterm=bold,underline term=bold,underline
  hi ModeMsg guifg=#3c3836 guibg=NONE guisp=NONE gui=bold ctermfg=237 ctermbg=NONE cterm=bold term=bold
  hi MoreMsg guifg=#3c3836 guibg=NONE guisp=NONE gui=bold ctermfg=237 ctermbg=NONE cterm=bold term=NONE
  hi NonText guifg=#e5d4b1 guibg=NONE guisp=NONE gui=NONE ctermfg=187 ctermbg=NONE cterm=NONE term=NONE
  hi Number guifg=#8f3f71 guibg=NONE guisp=NONE gui=NONE ctermfg=126 ctermbg=NONE cterm=NONE term=NONE
  hi Operator guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi Pmenu guifg=NONE guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=237 ctermbg=187 cterm=NONE term=reverse
  hi PmenuBorder guifg=#7c6f64 guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=237 ctermbg=187 cterm=NONE term=NONE
  hi PmenuExtra guifg=#7c6f64 guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=243 ctermbg=187 cterm=NONE term=NONE
  hi PmenuExtraSel guifg=#3c3836 guibg=#bdae93 guisp=NONE gui=NONE ctermfg=237 ctermbg=144 cterm=NONE term=NONE
  hi PmenuKind guifg=#9d0006 guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=124 ctermbg=187 cterm=NONE term=NONE
  hi PmenuKindSel guifg=#9d0006 guibg=#bdae93 guisp=NONE gui=NONE ctermfg=124 ctermbg=144 cterm=NONE term=NONE
  hi PmenuMatch guifg=#8f3f71 guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=126 ctermbg=187 cterm=NONE term=NONE
  hi PmenuMatchSel guifg=#8f3f71 guibg=#bdae93 guisp=NONE gui=NONE ctermfg=126 ctermbg=144 cterm=NONE term=NONE
  hi PmenuSbar guifg=NONE guibg=#e5d4b1 guisp=NONE gui=NONE ctermfg=NONE ctermbg=187 cterm=NONE term=reverse
  hi PmenuSel guifg=NONE guibg=#bdae93 guisp=NONE gui=NONE ctermfg=NONE ctermbg=144 cterm=NONE term=bold
  hi PmenuThumb guifg=NONE guibg=#a89984 guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=reverse term=NONE
  hi PreCondit guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi PreProc guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi Question guifg=#ff5f00 guibg=NONE guisp=NONE gui=bold ctermfg=202 ctermbg=NONE cterm=bold term=standout
  hi QuickFixLine guifg=NONE guibg=#e7cfd7 guisp=NONE gui=NONE ctermfg=235 ctermbg=182 cterm=NONE term=NONE
  hi Repeat guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi Search guifg=NONE guibg=#dbebb2 guisp=NONE gui=NONE ctermfg=100 ctermbg=230 cterm=reverse term=reverse
  hi SignColumn guifg=#3c3836 guibg=#fbf1c7 guisp=NONE gui=NONE ctermfg=237 ctermbg=230 cterm=NONE term=reverse
  hi Special guifg=#ff5f00 guibg=NONE guisp=NONE gui=NONE ctermfg=202 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialChar guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialComment guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialKey guifg=#928374 guibg=NONE guisp=NONE gui=NONE ctermfg=102 ctermbg=NONE cterm=NONE term=bold
  hi SpellBad guifg=#9d0006 guibg=NONE guisp=#9d0006 gui=undercurl ctermfg=124 ctermbg=NONE cterm=underline term=underline
  hi SpellCap guifg=#076678 guibg=NONE guisp=#076678 gui=undercurl ctermfg=23 ctermbg=NONE cterm=underline term=underline
  hi SpellLocal guifg=#427b58 guibg=NONE guisp=#427b58 gui=undercurl ctermfg=29 ctermbg=NONE cterm=underline term=underline
  hi SpellRare guifg=#8f3f71 guibg=NONE guisp=#8f3f71 gui=undercurl ctermfg=126 ctermbg=NONE cterm=underline term=underline
  hi Statement guifg=#9d0006 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi StatusLine guifg=#bdae93 guibg=#3c3836 guisp=NONE gui=bold,reverse ctermfg=144 ctermbg=237 cterm=bold,reverse term=bold,reverse
  hi StatusLineNC guifg=#ebdbb2 guibg=#3c3836 guisp=NONE gui=reverse ctermfg=187 ctermbg=237 cterm=reverse term=bold,underline
  hi StorageClass guifg=#ff5f00 guibg=NONE guisp=NONE gui=NONE ctermfg=202 ctermbg=NONE cterm=NONE term=NONE
  hi String guifg=#79740e guibg=NONE guisp=NONE gui=NONE ctermfg=64 ctermbg=NONE cterm=NONE term=NONE
  hi Structure guifg=#427b58 guibg=NONE guisp=NONE gui=NONE ctermfg=29 ctermbg=NONE cterm=NONE term=NONE
  hi TabLine guifg=#665c54 guibg=#ebdbb2 guisp=NONE gui=NONE ctermfg=59 ctermbg=187 cterm=NONE term=bold,underline
  hi TabLineFill guifg=#3c3836 guibg=#ebdbb2 guisp=NONE gui=NONE ctermfg=237 ctermbg=187 cterm=NONE term=NONE
  hi TabLineSel guifg=#282828 guibg=#fbf1c7 guisp=NONE gui=bold ctermfg=235 ctermbg=230 cterm=bold term=bold,reverse
  hi Title guifg=#79740e guibg=NONE guisp=NONE gui=bold ctermfg=64 ctermbg=NONE cterm=bold term=NONE
  hi TitleBar guifg=#3c3836 guibg=#dbcba2 guisp=NONE gui=NONE ctermfg=237 ctermbg=255 cterm=NONE term=NONE
  hi TitleBarNC guifg=#7c6f64 guibg=#e9d9b0 guisp=NONE gui=NONE ctermfg=243 ctermbg=255 cterm=NONE term=NONE
  hi Todo guifg=fg guibg=#fbf1c7 guisp=NONE gui=bold ctermfg=fg ctermbg=230 cterm=bold term=bold,reverse
  hi ToolbarButton guifg=#282828 guibg=#bdae93 guisp=NONE gui=bold ctermfg=235 ctermbg=144 cterm=bold term=bold,reverse
  hi ToolbarLine guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi Type guifg=#b57614 guibg=NONE guisp=NONE gui=NONE ctermfg=172 ctermbg=NONE cterm=NONE term=NONE
  hi Typedef guifg=#b57614 guibg=NONE guisp=NONE gui=NONE ctermfg=172 ctermbg=NONE cterm=NONE term=NONE
  hi Underlined guifg=#076678 guibg=NONE guisp=NONE gui=underline ctermfg=23 ctermbg=NONE cterm=underline term=underline
  hi VertSplit guifg=#bdae93 guibg=#fbf1c7 guisp=NONE gui=NONE ctermfg=144 ctermbg=230 cterm=NONE term=NONE
  hi Visual guifg=NONE guibg=#b0d0d0 guisp=NONE gui=NONE ctermfg=23 ctermbg=230 cterm=reverse term=reverse
  hi WarningMsg guifg=#9d0006 guibg=NONE guisp=NONE gui=bold ctermfg=124 ctermbg=NONE cterm=bold term=standout
  hi WildMenu guifg=#076678 guibg=#e5d4b1 guisp=NONE gui=bold ctermfg=23 ctermbg=187 cterm=bold term=bold

  if s:tgc || s:t_Co >= 256
    if s:tgc
      hi IncSearch cterm=NONE
      hi QuickFixLine cterm=NONE
      hi Search cterm=NONE
      hi Visual cterm=NONE
    endif
    finish
  endif

  if s:t_Co >= 16
    hi Normal ctermfg=Black ctermbg=White cterm=NONE
    hi Boolean ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Character ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=White ctermbg=Grey cterm=NONE
    hi Comment ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi Conceal ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Conditional ctermfg=Red ctermbg=NONE cterm=NONE
    hi Constant ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Cursor ctermfg=White ctermbg=DarkGray cterm=NONE
    hi CursorIM ctermfg=White ctermbg=DarkGray cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Debug ctermfg=Red ctermbg=NONE cterm=NONE
    hi Define ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Delimiter ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi DiffAdd ctermfg=Black ctermbg=green cterm=NONE
    hi DiffChange ctermfg=Black ctermbg=yellow cterm=NONE
    hi DiffDelete ctermfg=DarkGray ctermbg=red cterm=NONE
    hi DiffText ctermfg=Black ctermbg=cyan cterm=NONE
    hi Directory ctermfg=Green ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Error ctermfg=Red ctermbg=White cterm=reverse
    hi ErrorMsg ctermfg=White ctermbg=Red cterm=bold
    hi Exception ctermfg=Red ctermbg=NONE cterm=NONE
    hi Float ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi FoldColumn ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Folded ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Function ctermfg=Green ctermbg=NONE cterm=bold
    hi Identifier ctermfg=Blue ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=fg ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=Magenta ctermbg=White cterm=reverse
    hi Include ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Keyword ctermfg=Red ctermbg=NONE cterm=NONE
    hi Label ctermfg=Red ctermbg=NONE cterm=NONE
    hi LineNr ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Macro ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=NONE ctermbg=White cterm=bold,underline
    hi ModeMsg ctermfg=Black ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=Black ctermbg=NONE cterm=bold
    hi NonText ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Number ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Operator ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=Black ctermbg=Grey cterm=NONE
    hi PmenuBorder ctermfg=Black ctermbg=Grey cterm=NONE
    hi PmenuExtra ctermfg=DarkGray ctermbg=Grey cterm=NONE
    hi PmenuExtraSel ctermfg=DarkGray ctermbg=NONE cterm=NONE
    hi PmenuKind ctermfg=DarkRed ctermbg=Grey cterm=NONE
    hi PmenuKindSel ctermfg=DarkRed ctermbg=NONE cterm=NONE
    hi PmenuMatch ctermfg=Black ctermbg=Grey cterm=bold
    hi PmenuMatchSel ctermfg=Black ctermbg=NONE cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=Grey cterm=NONE
    hi PmenuSel ctermfg=Black ctermbg=White cterm=NONE
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreCondit ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi PreProc ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=Magenta ctermbg=NONE cterm=bold
    hi QuickFixLine ctermfg=DarkGray ctermbg=magenta cterm=NONE
    hi Repeat ctermfg=Red ctermbg=NONE cterm=NONE
    hi Search ctermfg=DarkGreen ctermbg=White cterm=reverse
    hi SignColumn ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Special ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi SpecialChar ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialComment ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=Grey ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=Red ctermbg=NONE cterm=underline
    hi SpellCap ctermfg=Blue ctermbg=NONE cterm=underline
    hi SpellLocal ctermfg=Cyan ctermbg=NONE cterm=underline
    hi SpellRare ctermfg=Magenta ctermbg=NONE cterm=underline
    hi Statement ctermfg=Red ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=DarkGray ctermbg=White cterm=bold,reverse
    hi StatusLineNC ctermfg=Grey ctermbg=DarkGray cterm=reverse
    hi StorageClass ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi String ctermfg=Green ctermbg=NONE cterm=NONE
    hi Structure ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=DarkGray ctermbg=Grey cterm=NONE
    hi TabLineFill ctermfg=White ctermbg=Grey cterm=NONE
    hi TabLineSel ctermfg=DarkGray ctermbg=White cterm=bold
    hi Title ctermfg=NONE ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=Black ctermbg=white cterm=NONE
    hi TitleBarNC ctermfg=Black ctermbg=white cterm=NONE
    hi Todo ctermfg=fg ctermbg=White cterm=bold
    hi ToolbarButton ctermfg=Black ctermbg=Grey cterm=bold
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Typedef ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=Blue ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=DarkGray ctermbg=Grey cterm=NONE
    hi Visual ctermfg=Blue ctermbg=White cterm=reverse
    hi WarningMsg ctermfg=Red ctermbg=NONE cterm=bold
    hi WildMenu ctermfg=Black ctermbg=White cterm=bold
    finish
  endif

  if s:t_Co >= 8
    hi Normal ctermfg=Black ctermbg=Grey cterm=NONE
    hi Boolean ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Character ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=White ctermbg=Black cterm=NONE
    hi Comment ctermfg=Black ctermbg=NONE cterm=bold
    hi Conceal ctermfg=Grey ctermbg=NONE cterm=NONE
    hi Conditional ctermfg=Red ctermbg=NONE cterm=NONE
    hi Constant ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Cursor ctermfg=White ctermbg=DarkGray cterm=NONE
    hi CursorIM ctermfg=White ctermbg=DarkGray cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Debug ctermfg=Red ctermbg=NONE cterm=NONE
    hi Define ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Delimiter ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi DiffAdd ctermfg=DarkGray ctermbg=green cterm=NONE
    hi DiffChange ctermfg=DarkGray ctermbg=yellow cterm=NONE
    hi DiffDelete ctermfg=DarkGray ctermbg=red cterm=NONE
    hi DiffText ctermfg=DarkGray ctermbg=cyan cterm=NONE
    hi Directory ctermfg=Green ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Error ctermfg=Red ctermbg=White cterm=reverse
    hi ErrorMsg ctermfg=White ctermbg=Red cterm=NONE
    hi Exception ctermfg=Red ctermbg=NONE cterm=NONE
    hi Float ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi FoldColumn ctermfg=Black ctermbg=NONE cterm=NONE
    hi Folded ctermfg=Black ctermbg=NONE cterm=NONE
    hi Function ctermfg=Green ctermbg=NONE cterm=bold
    hi Identifier ctermfg=Blue ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=fg ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=Magenta ctermbg=White cterm=reverse
    hi Include ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Keyword ctermfg=Red ctermbg=NONE cterm=NONE
    hi Label ctermfg=Red ctermbg=NONE cterm=NONE
    hi LineNr ctermfg=Black ctermbg=NONE cterm=NONE
    hi Macro ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=Black ctermbg=NONE cterm=bold,underline
    hi ModeMsg ctermfg=Black ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=Black ctermbg=NONE cterm=bold
    hi NonText ctermfg=Black ctermbg=NONE cterm=NONE
    hi Number ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi Operator ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuBorder ctermfg=Black ctermbg=Grey cterm=NONE
    hi PmenuExtra ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuExtraSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuKind ctermfg=NONE ctermbg=NONE cterm=bold,reverse
    hi PmenuKindSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuMatch ctermfg=NONE ctermbg=Red cterm=reverse
    hi PmenuMatchSel ctermfg=Red ctermbg=NONE cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreCondit ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi PreProc ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=Magenta ctermbg=NONE cterm=bold
    hi QuickFixLine ctermfg=DarkGray ctermbg=magenta cterm=NONE
    hi Repeat ctermfg=Red ctermbg=NONE cterm=NONE
    hi Search ctermfg=DarkGreen ctermbg=White cterm=reverse
    hi SignColumn ctermfg=Black ctermbg=NONE cterm=NONE
    hi Special ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi SpecialChar ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialComment ctermfg=Red ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=Black ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=Red ctermbg=NONE cterm=underline
    hi SpellCap ctermfg=Blue ctermbg=NONE cterm=underline
    hi SpellLocal ctermfg=Cyan ctermbg=NONE cterm=underline
    hi SpellRare ctermfg=Magenta ctermbg=NONE cterm=underline
    hi Statement ctermfg=Red ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=Black ctermbg=White cterm=bold,reverse
    hi StatusLineNC ctermfg=Black ctermbg=White cterm=reverse
    hi StorageClass ctermfg=Magenta ctermbg=NONE cterm=NONE
    hi String ctermfg=Green ctermbg=NONE cterm=NONE
    hi Structure ctermfg=Cyan ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=White ctermbg=Black cterm=NONE
    hi TabLineFill ctermfg=White ctermbg=Black cterm=NONE
    hi TabLineSel ctermfg=Black ctermbg=White cterm=NONE
    hi Title ctermfg=Green ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=Black ctermbg=white cterm=NONE
    hi TitleBarNC ctermfg=Black ctermbg=white cterm=NONE
    hi Todo ctermfg=fg ctermbg=White cterm=bold
    hi ToolbarButton ctermfg=White ctermbg=Black cterm=bold
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Typedef ctermfg=Yellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=Blue ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=White ctermbg=Black cterm=NONE
    hi Visual ctermfg=White ctermbg=Blue cterm=NONE
    hi WarningMsg ctermfg=Red ctermbg=NONE cterm=bold
    hi WildMenu ctermfg=Blue ctermbg=Grey cterm=bold
    finish
  endif

  if s:t_Co >= 0
    hi CurSearch term=reverse
    hi CursorColumn term=NONE
    hi CursorLineFold term=underline
    hi CursorLineSign term=underline
    hi StatusLineTerm term=bold,reverse
    hi StatusLineTermNC term=bold,underline
    hi Terminal term=NONE
    hi VisualNOS term=NONE
    finish
  endif

endif

" vim: et ts=8 sw=2 sts=2
